/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import hdi.edi.codecollector.CodeEntityResolver;
import hdi.edi.parser.EdiParser;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import hdi.edi.parserhelper.SegMatcher;
import hdi.edi.parserhelper.SegMatchingCriteria;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiTextRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiTextRenderer.class);
    private CodeEntityResolver codeResolver;
    private boolean isRenderRaw = true;
    private boolean isRenderElts = true;
    private boolean useFriendlyNames = false;
    private boolean buildLoopHierarchy = false;
    private boolean showParents = true;
    private final SegMatcher segMatcher = new SegMatcher();
    private SegMatchingCriteria segMatchingCriteria;
    private Set<SegmentType> segTypeFilter = new HashSet<SegmentType>();
    private SegmentType includeAll;
    private int numberOfSpacesToIndentSeg = 4;
    private int numberOfSpacesToIndentElt = 2;
    public static final String ELT_NAME_FORMAT = "%s (%s) (%d) [%s]: ";

    public static String render(File file, SegmentType ... filters) {
        return EdiTextRenderer.render(null, file, filters);
    }

    public static String render(SegmentType includeAll, File file, SegmentType ... filters) {
        EdiParser par = new EdiParser(file);
        List<EdiSeg> segs = par.parseAllSegs();
        EdiTextRenderer reporter = new EdiTextRenderer().addSegTypeFilters(filters);
        reporter.includeAll(includeAll);
        return reporter.render(segs);
    }

    public String renderFile(File file) {
        EdiParser par = new EdiParser(file);
        par.buildLoopHierarchy(this.buildLoopHierarchy);
        par.codeResolver(this.codeResolver);
        List<EdiSeg> segs = par.parseAll().segs();
        if (this.segMatchingCriteria != null) {
            segs = this.segMatcher.match(segs, this.segMatchingCriteria);
        }
        return this.render(segs);
    }

    public String render(EdiSeg seg) {
        return this.render(List.of(seg), 0);
    }

    public EdiTextRenderer addSegTypeFilters(SegmentType ... segmentTypes) {
        this.segTypeFilter.addAll(Set.of(segmentTypes));
        return this;
    }

    public String render(List<EdiSeg> segs) {
        return this.render(segs, 0);
    }

    private String render(List<EdiSeg> segs, int level) {
        StringBuilder buf = new StringBuilder();
        for (EdiSeg seg : segs) {
            String segStr = this.renderSegAsString(seg, level);
            if (StringUtils.isNotBlank((CharSequence)segStr)) {
                buf.append(segStr).append('\n');
                if (!seg.childSegs().isEmpty()) {
                    String nestedS = this.render(seg.childSegs(), level + 1);
                    buf.append('\n').append(nestedS);
                }
            }
            if (level != 0 || buf.isEmpty()) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public String renderSegAsString(EdiSeg seg, int level) {
        if (!(this.segTypeFilter.isEmpty() || this.segTypeFilter.contains((Object)seg.type()) || this.includeAll != null && seg.parentSeg().type() == this.includeAll)) {
            return null;
        }
        Object s = "";
        String indent = StringUtils.repeat((char)' ', (int)(level * this.numberOfSpacesToIndentSeg));
        if (this.isRenderRaw) {
            s = (String)s + indent + seg.typeAsString() + seg.getEdiSeparatorsForRendering().elementSeparator() + StringUtils.stripEnd((String)seg.rawString(), null) + seg.getEdiSeparatorsForRendering().segmentTerminator() + "\n";
        }
        String header = seg.type() == SegmentType.LOOP ? this.renderLoopHeaderAsString(seg) : this.renderSegHeaderAsString(seg, indent);
        s = (String)s + header;
        if (this.isRenderElts && seg.eltSet() != null) {
            String eltsStr = this.renderElementsAsString(seg.eltSet(), indent, "\n");
            s = (String)s + "\n" + eltsStr;
        }
        return s;
    }

    private String renderLoopHeaderAsString(EdiSeg seg) {
        String format = "Loop %s: %s Unique ID: %s%s";
        String segName = seg.name();
        if (this.useFriendlyNames) {
            segName = seg.friendlyName();
        }
        String parentS = this.renderParentHeader(seg);
        return String.format(format, seg.loop(), segName, seg.id(), parentS);
    }

    private String renderSegHeaderAsString(EdiSeg seg, String indent) {
        String format = "%s (Loop: %s Seg.ID: %s %sIndex within tran:%d Ent:%s %s)";
        String parentS = "";
        String segName = seg.name();
        if (this.useFriendlyNames) {
            segName = seg.friendlyName();
        }
        if (this.showParents) {
            parentS = this.renderParentHeader(seg);
        }
        if (StringUtils.isBlank((CharSequence)segName)) {
            segName = "Unknown Segment";
        }
        String isArrayStr = "";
        if (seg.isArray()) {
            isArrayStr = " Array ";
        }
        String entClass = "";
        if (seg.entity() != null) {
            entClass = seg.entity().getClass().getSimpleName();
        }
        String s = indent + String.format(format, segName, seg.loop(), seg.typeAsString(), isArrayStr, seg.indexWithinTran(), entClass, parentS);
        if (seg.entity() != null && StringUtils.isNotBlank((CharSequence)seg.entity().summaryString())) {
            s = s + "\n" + indent + seg.entity().summaryString();
        }
        return s;
    }

    private String renderParentHeader(EdiSeg seg) {
        Object parentS = "";
        if (seg.parentSeg() != null) {
            Object parentSegName = seg.parentSeg().name();
            if (this.useFriendlyNames) {
                parentSegName = seg.parentSeg().friendlyName();
            }
            if (seg.parentSeg().type() == SegmentType.LOOP) {
                parentSegName = "Loop " + seg.parentSeg().loop() + ": " + (String)parentSegName;
            }
            parentS = "Parent: " + (String)parentSegName;
        }
        return parentS;
    }

    private String renderElementsAsString(EltSet eltSet, String baseIndent, String sep) {
        if (sep == null) {
            sep = "\n";
        }
        List<Elt> elts = eltSet.elts();
        String indent = baseIndent + StringUtils.repeat((char)' ', (int)this.numberOfSpacesToIndentElt);
        StringBuilder buf = new StringBuilder();
        if (!elts.isEmpty()) {
            int i = 0;
            for (Elt e : elts) {
                if (i == 0 || StringUtils.endsWith((CharSequence)buf, (CharSequence)"\n")) {
                    buf.append(indent);
                }
                String es = this.renderElement(e, indent);
                buf.append(es);
                if (i < elts.size() - 1) {
                    buf.append(sep);
                }
                ++i;
            }
        } else {
            buf.append(indent);
            buf.append("No elements");
        }
        return buf.toString();
    }

    public String renderEltAsString(Elt elt) {
        return this.renderElement(elt, "");
    }

    private String renderElement(Elt elt, String indent) {
        Object eltValStr;
        String eltName = elt.name();
        if (this.useFriendlyNames) {
            eltName = elt.friendlyName();
        }
        Object rawVal = StringUtils.stripEnd((String)elt.rawEdiString(), null);
        if (elt.ncpdpId() != null) {
            rawVal = elt.ncpdpId() + " " + (String)rawVal;
        }
        String eltType = "";
        if (elt.val() != null) {
            eltType = elt.val().getClass().getSimpleName();
        }
        String nameS = String.format(ELT_NAME_FORMAT, eltName, eltType, elt.position(), rawVal);
        StringBuilder s = new StringBuilder(nameS);
        switch (elt.dataType()) {
            case ELT_SET: {
                Object object = "\n" + this.renderElementsAsString(elt.eltSet(), indent, ", ");
                break;
            }
            case LIST: {
                Object object = "[\n" + elt.eltSets().stream().map(es -> this.renderElementsAsString((EltSet)es, indent, ", ")).collect(Collectors.joining(",\n")) + "\n" + indent + "]";
                break;
            }
            default: {
                Object object = eltValStr = elt.valAsStr();
            }
        }
        if (elt.codeEntity() != null) {
            eltValStr = (String)eltValStr + "\tCode Ent: " + elt.codeEntity().code() + " " + elt.codeEntity().desc();
        }
        return s.append((String)eltValStr).toString();
    }

    @Generated
    public EdiTextRenderer() {
    }

    @Generated
    public CodeEntityResolver codeResolver() {
        return this.codeResolver;
    }

    @Generated
    public boolean isRenderRaw() {
        return this.isRenderRaw;
    }

    @Generated
    public boolean isRenderElts() {
        return this.isRenderElts;
    }

    @Generated
    public boolean useFriendlyNames() {
        return this.useFriendlyNames;
    }

    @Generated
    public boolean buildLoopHierarchy() {
        return this.buildLoopHierarchy;
    }

    @Generated
    public boolean showParents() {
        return this.showParents;
    }

    @Generated
    public SegMatcher segMatcher() {
        return this.segMatcher;
    }

    @Generated
    public SegMatchingCriteria segMatchingCriteria() {
        return this.segMatchingCriteria;
    }

    @Generated
    public Set<SegmentType> segTypeFilter() {
        return this.segTypeFilter;
    }

    @Generated
    public SegmentType includeAll() {
        return this.includeAll;
    }

    @Generated
    public int numberOfSpacesToIndentSeg() {
        return this.numberOfSpacesToIndentSeg;
    }

    @Generated
    public int numberOfSpacesToIndentElt() {
        return this.numberOfSpacesToIndentElt;
    }

    @Generated
    public EdiTextRenderer codeResolver(CodeEntityResolver codeResolver) {
        this.codeResolver = codeResolver;
        return this;
    }

    @Generated
    public EdiTextRenderer isRenderRaw(boolean isRenderRaw) {
        this.isRenderRaw = isRenderRaw;
        return this;
    }

    @Generated
    public EdiTextRenderer isRenderElts(boolean isRenderElts) {
        this.isRenderElts = isRenderElts;
        return this;
    }

    @Generated
    public EdiTextRenderer useFriendlyNames(boolean useFriendlyNames) {
        this.useFriendlyNames = useFriendlyNames;
        return this;
    }

    @Generated
    public EdiTextRenderer buildLoopHierarchy(boolean buildLoopHierarchy) {
        this.buildLoopHierarchy = buildLoopHierarchy;
        return this;
    }

    @Generated
    public EdiTextRenderer showParents(boolean showParents) {
        this.showParents = showParents;
        return this;
    }

    @Generated
    public EdiTextRenderer segMatchingCriteria(SegMatchingCriteria segMatchingCriteria) {
        this.segMatchingCriteria = segMatchingCriteria;
        return this;
    }

    @Generated
    public EdiTextRenderer segTypeFilter(Set<SegmentType> segTypeFilter) {
        this.segTypeFilter = segTypeFilter;
        return this;
    }

    @Generated
    public EdiTextRenderer includeAll(SegmentType includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    @Generated
    public EdiTextRenderer numberOfSpacesToIndentSeg(int numberOfSpacesToIndentSeg) {
        this.numberOfSpacesToIndentSeg = numberOfSpacesToIndentSeg;
        return this;
    }

    @Generated
    public EdiTextRenderer numberOfSpacesToIndentElt(int numberOfSpacesToIndentElt) {
        this.numberOfSpacesToIndentElt = numberOfSpacesToIndentElt;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdiTextRenderer)) {
            return false;
        }
        EdiTextRenderer other = (EdiTextRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRenderRaw() != other.isRenderRaw()) {
            return false;
        }
        if (this.isRenderElts() != other.isRenderElts()) {
            return false;
        }
        if (this.useFriendlyNames() != other.useFriendlyNames()) {
            return false;
        }
        if (this.buildLoopHierarchy() != other.buildLoopHierarchy()) {
            return false;
        }
        if (this.showParents() != other.showParents()) {
            return false;
        }
        if (this.numberOfSpacesToIndentSeg() != other.numberOfSpacesToIndentSeg()) {
            return false;
        }
        if (this.numberOfSpacesToIndentElt() != other.numberOfSpacesToIndentElt()) {
            return false;
        }
        CodeEntityResolver this$codeResolver = this.codeResolver();
        CodeEntityResolver other$codeResolver = other.codeResolver();
        if (this$codeResolver == null ? other$codeResolver != null : !this$codeResolver.equals(other$codeResolver)) {
            return false;
        }
        SegMatcher this$segMatcher = this.segMatcher();
        SegMatcher other$segMatcher = other.segMatcher();
        if (this$segMatcher == null ? other$segMatcher != null : !this$segMatcher.equals(other$segMatcher)) {
            return false;
        }
        SegMatchingCriteria this$segMatchingCriteria = this.segMatchingCriteria();
        SegMatchingCriteria other$segMatchingCriteria = other.segMatchingCriteria();
        if (this$segMatchingCriteria == null ? other$segMatchingCriteria != null : !this$segMatchingCriteria.equals(other$segMatchingCriteria)) {
            return false;
        }
        Set<SegmentType> this$segTypeFilter = this.segTypeFilter();
        Set<SegmentType> other$segTypeFilter = other.segTypeFilter();
        if (this$segTypeFilter == null ? other$segTypeFilter != null : !((Object)this$segTypeFilter).equals(other$segTypeFilter)) {
            return false;
        }
        SegmentType this$includeAll = this.includeAll();
        SegmentType other$includeAll = other.includeAll();
        return !(this$includeAll == null ? other$includeAll != null : !((Object)((Object)this$includeAll)).equals((Object)other$includeAll));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdiTextRenderer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRenderRaw() ? 79 : 97);
        result = result * 59 + (this.isRenderElts() ? 79 : 97);
        result = result * 59 + (this.useFriendlyNames() ? 79 : 97);
        result = result * 59 + (this.buildLoopHierarchy() ? 79 : 97);
        result = result * 59 + (this.showParents() ? 79 : 97);
        result = result * 59 + this.numberOfSpacesToIndentSeg();
        result = result * 59 + this.numberOfSpacesToIndentElt();
        CodeEntityResolver $codeResolver = this.codeResolver();
        result = result * 59 + ($codeResolver == null ? 43 : $codeResolver.hashCode());
        SegMatcher $segMatcher = this.segMatcher();
        result = result * 59 + ($segMatcher == null ? 43 : $segMatcher.hashCode());
        SegMatchingCriteria $segMatchingCriteria = this.segMatchingCriteria();
        result = result * 59 + ($segMatchingCriteria == null ? 43 : $segMatchingCriteria.hashCode());
        Set<SegmentType> $segTypeFilter = this.segTypeFilter();
        result = result * 59 + ($segTypeFilter == null ? 43 : ((Object)$segTypeFilter).hashCode());
        SegmentType $includeAll = this.includeAll();
        result = result * 59 + ($includeAll == null ? 43 : ((Object)((Object)$includeAll)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdiTextRenderer(codeResolver=" + String.valueOf(this.codeResolver()) + ", isRenderRaw=" + this.isRenderRaw() + ", isRenderElts=" + this.isRenderElts() + ", useFriendlyNames=" + this.useFriendlyNames() + ", buildLoopHierarchy=" + this.buildLoopHierarchy() + ", showParents=" + this.showParents() + ", segMatcher=" + String.valueOf(this.segMatcher()) + ", segMatchingCriteria=" + String.valueOf(this.segMatchingCriteria()) + ", segTypeFilter=" + String.valueOf(this.segTypeFilter()) + ", includeAll=" + String.valueOf((Object)this.includeAll()) + ", numberOfSpacesToIndentSeg=" + this.numberOfSpacesToIndentSeg() + ", numberOfSpacesToIndentElt=" + this.numberOfSpacesToIndentElt() + ")";
    }
}

