/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import hdi.edi.openedi.InputStandardType;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.InvalidEdiException;
import hdi.edi.parser.IsaParser;
import hdi.edi.parserhelper.EdiConst;
import hdi.edi.parserhelper.EdiPreParsingResults;
import hdi.edi.parserhelper.ParsedLine;
import hdi.edi.parserhelper.ParsingError;
import hdi.ncpdp.NcpdpUtils;
import hdi.util.Loggers;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.MalformedInputException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiPreParser
implements EdiConst,
Loggers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiPreParser.class);

    public EdiPreParsingResults preParseEdi(String ediText) {
        return this.preParseEdi(ediText, InputStandardType.EDI);
    }

    public EdiPreParsingResults preParseEdi(String ediText, InputStandardType inputType) {
        try {
            if (inputType == InputStandardType.EDI) {
                return this.preParseX12Edi(ediText);
            }
            if (inputType == InputStandardType.NCPDP) {
                return this.preParseNcpdp(ediText);
            }
        }
        catch (IOException e) {
            if (e instanceof MalformedInputException) {
                throw new EdiParserException("Encountered binary input at the beginning of the file; is this a valid text/EDI file?", new Object[0]);
            }
            log.error("Encountered exception while initiating file parsing", (Throwable)e);
            throw new EdiParserException("Encountered exception while initiating parsing: %s", e.toString());
        }
        throw new InvalidEdiException("Unknown input type: " + String.valueOf((Object)inputType), new Object[0]);
    }

    private EdiPreParsingResults preParseNcpdp(String ediText) {
        EdiPreParsingResults results = new EdiPreParsingResults();
        results.ediSeparators(EdiSeparators.NCPDP_SEPARATORS);
        ediText = StringUtils.strip((String)ediText, (String)"\n");
        ediText = StringUtils.strip((String)ediText, (String)" ");
        ediText = NcpdpUtils.replaceSeparatorsWithUnicodeIcons(ediText);
        return results.sanitizedEdiString(ediText);
    }

    private EdiPreParsingResults preParseX12Edi(String ediText) throws IOException {
        EdiPreParsingResults results = new EdiPreParsingResults();
        StringReader reader = new StringReader(ediText);
        EdiSeparators ediSeparators = IsaParser.attemptToParseISA(reader);
        boolean isEdiSeparatorsFound = ediSeparators.isIsaNotFound() ? IsaParser.probeForEdiDelimiter(reader, 300, ediSeparators) : true;
        if (!isEdiSeparatorsFound) {
            results.isEdiValid(false);
            results.sanitizedEdiString(StringUtils.strip((String)ediText));
            return results;
        }
        results.isEdiValid(true);
        results.ediSeparators(ediSeparators);
        ediText = StringUtils.strip((String)ediText);
        ediText = StringUtils.strip((String)ediText, (String)" ");
        int segmentCount = 0;
        String[] segmentStrings = StringUtils.splitPreserveAllTokens((String)ediText, (String)ediSeparators.segmentTerminator());
        StringBuilder buf = new StringBuilder();
        for (String segStr : segmentStrings) {
            Object ediLine = StringUtils.stripToEmpty((String)segStr);
            if (StringUtils.isNotBlank((CharSequence)(ediLine = ((String)ediLine).replaceAll("\\R", "")))) {
                if (!((String)ediLine).endsWith(ediSeparators.segmentTerminator())) {
                    ediLine = (String)ediLine + ediSeparators.segmentTerminator();
                }
                if (StringUtils.contains((CharSequence)ediLine, (CharSequence)ediSeparators.elementSeparator())) {
                    ++segmentCount;
                }
            }
            if (!buf.isEmpty() && buf.charAt(buf.length() - 1) != '\n') {
                buf.append("\n");
            }
            buf.append((String)ediLine);
        }
        return results.sanitizedEdiString(StringUtils.strip((String)buf.toString())).segmentCount(segmentCount).ediSeparators(ediSeparators);
    }

    private EdiPreParsingResults preParseX12EdiWithWarnings(String ediText) {
        EdiSeparators ediSeparators;
        EdiPreParsingResults results = new EdiPreParsingResults();
        try {
            ediSeparators = IsaParser.attemptToParseISA(new StringReader(ediText));
        }
        catch (InvalidEdiException invalidEdiException) {
            ParsedLine parsedLine = new ParsedLine(StringUtils.left((String)ediText, (int)"ISA~00~          ~00~          ~ZZ~860813402      ~ZZ~CCN412117      ~201015~1418~^~00501~730382717~1~P~:|".length()), 0);
            parsedLine.addError(new ParsingError(invalidEdiException.getMessage()));
            results.invalidLines().add(parsedLine);
            results.sanitizedEdiString(ediText);
            return results;
        }
        int segmentCount = 0;
        String[] segmentStrings = StringUtils.splitPreserveAllTokens((String)ediText, (String)ediSeparators.segmentTerminator());
        StringBuilder buf = new StringBuilder();
        int lineCount = 0;
        for (String segStr : segmentStrings) {
            ParsedLine parsedLine = this.parseEdiLine(lineCount, segStr, ediSeparators);
            String ediLine = parsedLine.line();
            if (!buf.isEmpty() && buf.charAt(buf.length() - 1) != '\n') {
                buf.append("\n");
            }
            buf.append(ediLine);
            if (!StringUtils.isNotBlank((CharSequence)ediLine)) continue;
            if (!parsedLine.parsingErrors().isEmpty()) {
                results.invalidLines().add(parsedLine);
            } else {
                ++segmentCount;
            }
            ++lineCount;
        }
        if (!results.invalidLines().isEmpty() && lineCount / results.invalidLines().size() < 3) {
            ParsedLine parsedLine = results.invalidLines().get(0);
            parsedLine.parsingErrors().add(0, new ParsingError("Too many EDI parsing errors, make sure your file is a text file in X12 EDI format"));
            buf = new StringBuilder();
        }
        return results.sanitizedEdiString(StringUtils.strip((String)buf.toString())).segmentCount(segmentCount).ediSeparators(ediSeparators);
    }

    private ParsedLine parseEdiLine(int lineNumber, String ediLine, EdiSeparators ediSeparators) {
        ediLine = StringUtils.stripToEmpty((String)ediLine);
        ediLine = ediLine.replaceAll("\\R", "");
        ParsedLine parsedLine = new ParsedLine(ediLine, lineNumber);
        if (StringUtils.isNotEmpty((CharSequence)ediLine)) {
            String segName;
            String eltSep = ediSeparators.elementSeparator();
            if (!StringUtils.contains((CharSequence)ediLine, (CharSequence)eltSep)) {
                ediParsingIssuesLogger.warn("This line does not contain the EDI element separator '{}'", (Object)eltSep);
            }
            if (StringUtils.isBlank((CharSequence)(segName = StringUtils.substringBefore((String)ediLine, (String)eltSep)))) {
                parsedLine.addError("Line without a segment ID", new Object[0]);
            } else {
                String firstChar;
                if (StringUtils.length((CharSequence)segName) > 3) {
                    parsedLine.addError("Segment ID is too long: '%s'", segName);
                }
                if (!StringUtils.isAlpha((CharSequence)(firstChar = StringUtils.left((String)ediLine, (int)1)))) {
                    parsedLine.addError("Segment ID does not start with a letter: '%s'", segName);
                } else if (!StringUtils.isAlphanumeric((CharSequence)segName)) {
                    parsedLine.addError("Segment ID can contain only letters and digits: '%s'", segName);
                }
            }
            if (ediLine.length() > 3000) {
                parsedLine.addError("Line is too long", new Object[0]);
            }
            if (!ediLine.endsWith(ediSeparators.segmentTerminator())) {
                parsedLine.appendToLine(ediSeparators.segmentTerminator());
            }
        }
        return parsedLine;
    }
}

