/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltFormatter;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextCollector.class);
    public static final String eltSep = " ";
    public static final String segSep = "\n";
    public static final String segHeadSep = "\n";
    private Set<SegmentType> segTypeFilter = new HashSet<SegmentType>();
    private EltFormatter eltFormatter = new EltFormatter();

    public String collectText(EdiSeg seg) {
        return this.collectText(List.of(seg));
    }

    public String collectText(List<EdiSeg> segs) {
        StringBuilder buf = new StringBuilder();
        for (EdiSeg seg : segs) {
            String segStr = this.renderSegAsString(seg);
            if (!StringUtils.isNotBlank((CharSequence)segStr)) continue;
            buf.append(segStr).append("\n");
            if (seg.childSegs().isEmpty()) continue;
            String nestedS = this.collectText(seg.childSegs());
            buf.append("\n").append(nestedS);
        }
        return buf.toString();
    }

    public String renderSegAsString(EdiSeg seg) {
        Object s = this.segHeaderToString(seg);
        if (seg.eltSet() != null) {
            String eltsStr = this.elementsToString(seg.eltSet());
            s = (String)s + "\n" + eltsStr;
        }
        return s;
    }

    private String segHeaderToString(EdiSeg seg) {
        return seg.loop() + eltSep + seg.typeAsString() + eltSep + seg.friendlyName();
    }

    private String elementsToString(EltSet eltSet) {
        List<Elt> elts = eltSet.elts();
        int i = 0;
        StringBuilder buf = new StringBuilder();
        for (Elt e : elts) {
            String es = this.elementToString(e);
            buf.append(es);
            if (i < elts.size() - 1) {
                buf.append(eltSep);
            }
            ++i;
        }
        return buf.toString();
    }

    private String elementToString(Elt elt) {
        StringBuilder s = new StringBuilder(elt.friendlyName()).append(eltSep);
        Object eltValStr = switch (elt.dataType()) {
            case DataType.ELT_SET -> this.elementsToString(elt.eltSet());
            case DataType.LIST -> elt.eltSets().stream().map(this::elementsToString).collect(Collectors.joining(eltSep));
            default -> this.eltFormatter.formatEltVal(elt);
        };
        return s.append(eltValStr).toString();
    }

    @Generated
    public TextCollector() {
    }

    @Generated
    public Set<SegmentType> segTypeFilter() {
        return this.segTypeFilter;
    }

    @Generated
    public EltFormatter eltFormatter() {
        return this.eltFormatter;
    }

    @Generated
    public TextCollector segTypeFilter(Set<SegmentType> segTypeFilter) {
        this.segTypeFilter = segTypeFilter;
        return this;
    }

    @Generated
    public TextCollector eltFormatter(EltFormatter eltFormatter) {
        this.eltFormatter = eltFormatter;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextCollector)) {
            return false;
        }
        TextCollector other = (TextCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<SegmentType> this$segTypeFilter = this.segTypeFilter();
        Set<SegmentType> other$segTypeFilter = other.segTypeFilter();
        if (this$segTypeFilter == null ? other$segTypeFilter != null : !((Object)this$segTypeFilter).equals(other$segTypeFilter)) {
            return false;
        }
        EltFormatter this$eltFormatter = this.eltFormatter();
        EltFormatter other$eltFormatter = other.eltFormatter();
        return !(this$eltFormatter == null ? other$eltFormatter != null : !this$eltFormatter.equals(other$eltFormatter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextCollector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<SegmentType> $segTypeFilter = this.segTypeFilter();
        result = result * 59 + ($segTypeFilter == null ? 43 : ((Object)$segTypeFilter).hashCode());
        EltFormatter $eltFormatter = this.eltFormatter();
        result = result * 59 + ($eltFormatter == null ? 43 : $eltFormatter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TextCollector(segTypeFilter=" + String.valueOf(this.segTypeFilter()) + ", eltFormatter=" + String.valueOf(this.eltFormatter()) + ")";
    }
}

