/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public final class NameUtils {
    public static String capitalize(String name) {
        String nm = StringUtils.replace((String)name, (String)"_", (String)" ");
        return WordUtils.capitalizeFully((String)nm);
    }

    public static String cleanName(String nm) {
        nm = StringUtils.remove((String)nm, (char)'\n');
        nm = StringUtils.remove((String)nm, (char)'\r');
        return StringUtils.strip((String)nm, (String)"\"' ");
    }

    public static String nameWithIndex(String nm, int i) {
        if (i <= 1) {
            return nm;
        }
        return nm + "_" + i;
    }

    public static String cleanSegmentName(String nm) {
        if (StringUtils.startsWith((CharSequence)(nm = NameUtils.cleanName(nm)), (CharSequence)"date_") && StringUtils.endsWithAny((CharSequence)nm, (CharSequence[])new CharSequence[]{"date", "dates", "date_hour"})) {
            nm = StringUtils.removeStart((String)nm, (String)"date_");
        }
        return nm;
    }

    static String fixupLegacyName(EdiSeg seg, String eltName) {
        if (seg.type() == SegmentType.NTE && ((String)eltName).endsWith("note_text")) {
            eltName = seg.name();
        } else if (seg.type() == SegmentType.REF && ((String)eltName).endsWith("referral_number")) {
            eltName = seg.name();
        } else if (seg.type() == SegmentType.AMT && ((String)eltName).startsWith("patient_amount_paid")) {
            eltName = "patient_amount_paid";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"date_time_period_format_qualifier", (CharSequence)eltName)) {
            eltName = "date_time_period_format";
        } else if (seg.type() == SegmentType.HI) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"patient_reason_for_visit", (CharSequence)eltName)) {
                eltName = (String)eltName + "_code";
            } else if (((String)eltName).startsWith("health_care_code_information")) {
                eltName = seg.name() + StringUtils.substringAfter((String)eltName, (String)"health_care_code_information");
            }
        }
        return eltName;
    }

    @Generated
    private NameUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

