/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.InvalidEdiException;
import hdi.edi.parser.SegmentType;
import hdi.util.Loggers;
import java.io.IOException;
import java.io.Reader;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsaParser
implements Loggers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IsaParser.class);
    public static final String ISA_V5_SAMPLE = "ISA~00~          ~00~          ~ZZ~860813402      ~ZZ~CCN412117      ~201015~1418~^~00501~730382717~1~P~:|";
    private static final String ISA_V4_SAMPLE = "ISA*00*          *00*          *ZZ*DTURNER        *ZZ*THEORY         *20230215*130043720*U*00401*000000044*0*P*>~";
    public static final int ISA_NUMBER_OF_ELEMENTS = 16;
    public static final int REPETITION_SEPARATOR_POS = 11;

    public static EdiSeparators attemptToParseISA(Reader reader) throws IOException {
        IsaParser.skipWhiteSpace(reader);
        EdiSeparators ediSeparators = IsaParser.parseIsaUsingSampleString(reader, ISA_V5_SAMPLE);
        return ediSeparators;
    }

    public static EdiSeparators attemptToParseISAV5andV4(Reader reader) throws IOException {
        EdiSeparators ediSeparators;
        IsaParser.skipWhiteSpace(reader);
        try {
            ediSeparators = IsaParser.parseIsaUsingSampleString(reader, ISA_V5_SAMPLE);
        }
        catch (InvalidEdiException ide) {
            ediParsingIssuesLogger.warn("Unable to parse ISA using V5 version, trying V4: {}", (Object)ide.toString());
            try {
                ediSeparators = IsaParser.parseIsaUsingSampleString(reader, ISA_V4_SAMPLE);
            }
            catch (InvalidEdiException ideV4) {
                ediParsingIssuesLogger.warn("Unable to parse ISA using V4 version, throwing V5 exception {}", (Object)ideV4.toString());
                throw ide;
            }
        }
        if (ediSeparators == null) {
            ediParsingIssuesLogger.info("Was not able to find or parse ISA segment, using default separators");
            ediSeparators = new EdiSeparators(EdiSeparators.DEFAULT_EDI_SEPARATORS);
        }
        return ediSeparators;
    }

    private static EdiSeparators parseIsaUsingSampleString(Reader reader, String isaSampleString) throws IOException {
        reader.mark(3000);
        EdiSeparators ediSeparators = null;
        Object errorMsg = null;
        String elementSep = null;
        String repetitionSep = null;
        int isaLength = isaSampleString.length();
        char[] chars = new char[isaLength];
        int numberOfCharsRead = reader.read(chars, 0, isaLength);
        if (numberOfCharsRead <= 0) {
            throw new EdiParserException("Blank input string or empty file", new Object[0]);
        }
        if (numberOfCharsRead >= isaLength) {
            String isaSegS = new String(chars);
            int isaNameLength = SegmentType.ISA.name().length();
            if (StringUtils.startsWithIgnoreCase((CharSequence)isaSegS, (CharSequence)SegmentType.ISA.name())) {
                elementSep = StringUtils.substring((String)isaSegS, (int)isaNameLength, (int)(isaNameLength + 1));
                String[] elems = StringUtils.splitPreserveAllTokens((String)isaSegS, (String)elementSep);
                if (elems.length >= 11) {
                    repetitionSep = elems[11];
                } else {
                    log.warn("Less than {} elements, cannot deduce the repetition separator", (Object)11);
                    repetitionSep = "^";
                }
                if (elems.length >= 17) {
                    String lastElem = elems[16];
                    if (StringUtils.length((CharSequence)lastElem) >= 2) {
                        String componentElementSep = StringUtils.left((String)lastElem, (int)1);
                        String segTerminator = StringUtils.substring((String)lastElem, (int)1, (int)2);
                        ediSeparators = new EdiSeparators(elementSep, segTerminator, componentElementSep, repetitionSep);
                        ediParsingIssuesLogger.debug("Parsed ISA segment, using following separators: {}", (Object)ediSeparators);
                    } else {
                        errorMsg = String.format("Expected the last ISA element to consist of two characters, found '%s'", lastElem);
                    }
                    if (elems.length > 17) {
                        errorMsg = "ISA segment is shorter than expected. Fixed length elements are probably shorter than needed. Parsed string: " + isaSegS;
                    }
                } else {
                    errorMsg = String.format("Unable to parse 'ISA' segment, expected %d elements, but found %d. The ISA segment must have a fixed length of %d bytes and it must consist of %d elements. All elements are required.", 16, elems.length - 1, isaSampleString.length(), 16);
                }
            }
        }
        reader.reset();
        if (ediSeparators == null) {
            ediSeparators = new EdiSeparators(EdiSeparators.DEFAULT_EDI_SEPARATORS);
            ediSeparators.isIsaNotFound(true);
            if (StringUtils.isNotBlank(elementSep)) {
                ediSeparators.elementSeparator(elementSep);
            }
            if (StringUtils.isNotBlank(repetitionSep)) {
                ediSeparators.repetitionSeparator(repetitionSep);
            }
        }
        if (errorMsg != null) {
            ediSeparators.isaParsingErrorMessage((String)errorMsg);
        }
        return ediSeparators;
    }

    private static void skipWhiteSpace(Reader reader) throws IOException {
        block1: {
            int ch;
            do {
                reader.mark(10);
                ch = reader.read();
                if (ch < 0) break block1;
            } while (!Character.isLetterOrDigit(ch));
            reader.reset();
        }
    }

    public static boolean probeForEdiDelimiter(Reader reader, int nChars, EdiSeparators ediSeparators) throws IOException {
        int ch;
        reader.mark(nChars);
        boolean isFound = false;
        boolean isElementSeparatorFound = false;
        boolean isSegmentTerminatorFound = false;
        for (int i = 0; i < nChars && (ch = reader.read()) >= 0; ++i) {
            if (ch == ediSeparators.elementSeparator().charAt(0)) {
                isElementSeparatorFound = true;
            }
            if (ch == ediSeparators.segmentTerminator().charAt(0)) {
                isSegmentTerminatorFound = true;
            }
            if (!isElementSeparatorFound || !isSegmentTerminatorFound) continue;
            isFound = true;
            break;
        }
        reader.reset();
        return isFound;
    }
}

