/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.parser.DataType;
import hdi.edi.parser.Elt;
import hdi.edi.parser.FormattedElt;
import hdi.util.FormattingUtils;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public class EltFormatter {
    public FormattedElt formatEltVal(Elt elt) {
        String s;
        FormattedElt formattedElt = new FormattedElt().elt(elt);
        if (elt.isCurrency()) {
            s = FormattingUtils.formatAmountAsCurrency(elt.bigDecimalVal());
        } else {
            s = switch (elt.dataType()) {
                case DataType.DATE -> elt.dateVal().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
                case DataType.DATE_TIME -> elt.dateTimeVal().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT));
                case DataType.TIME -> elt.timeVal().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT));
                case DataType.DOUBLE, DataType.BIG_DEC, DataType.FLOAT -> FormattingUtils.formatNumberBasedOnIntrinsicScale((Number)elt.val());
                case DataType.INT -> FormattingUtils.formatInt(elt.intVal());
                case DataType.QUALIFIER -> elt.qualifier().descAndCode();
                case DataType.ELT_SET -> null;
                default -> elt.valAsStr();
            };
        }
        formattedElt.valAsString(s);
        return formattedElt;
    }
}

