/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.parser.SegmentType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class EltDesignator {
    private SegmentType segType;
    private int pos;
    private int subPos;
    private String str;

    public static EltDesignator fromString(String desStr) {
        desStr = StringUtils.trim((String)desStr);
        desStr = StringUtils.remove((String)desStr, (char)' ');
        desStr = StringUtils.substringBefore((String)desStr, (int)42);
        String cleanStr = desStr.toUpperCase();
        String[] posParts = StringUtils.splitPreserveAllTokens((String)desStr, (char)'-');
        if (posParts.length > 2) {
            throw new IllegalArgumentException("Invalid designator format, too many dashes: " + desStr);
        }
        String subPosStr = null;
        if (posParts.length == 2) {
            desStr = posParts[0];
            subPosStr = posParts[1];
        }
        String posStr = null;
        String seg = desStr;
        if (desStr.length() > 3) {
            posStr = StringUtils.right((String)desStr, (int)2);
            seg = StringUtils.left((String)desStr, (int)(desStr.length() - 2));
        }
        EltDesignator designator = new EltDesignator();
        designator.str = cleanStr;
        designator.segType = SegmentType.fromTag(seg);
        if (designator.segType == null) {
            throw new IllegalArgumentException("Invalid designator segment: " + seg);
        }
        if (posStr != null) {
            designator.pos = Integer.parseInt(posStr);
        }
        if (subPosStr != null) {
            designator.subPos = Integer.parseInt(subPosStr);
        }
        return designator;
    }

    @Generated
    public SegmentType segType() {
        return this.segType;
    }

    @Generated
    public int pos() {
        return this.pos;
    }

    @Generated
    public int subPos() {
        return this.subPos;
    }

    @Generated
    public String str() {
        return this.str;
    }

    @Generated
    public String toString() {
        return "EltDesignator(segType=" + String.valueOf((Object)this.segType()) + ", pos=" + this.pos() + ", subPos=" + this.subPos() + ", str=" + this.str() + ")";
    }
}

