/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hdi.codeent.CodeEntity;
import hdi.edi.legacyparser.EltValHolder;
import hdi.edi.parser.DataType;
import hdi.edi.parser.DatePair;
import hdi.edi.parser.EdiDateUtils;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.NameUtils;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.parserhelper.EdiTextRenderer;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.QualifierResolver;
import hdi.model.enumtype.DateFormatType;
import hdi.util.Loggers;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

public class Elt
implements Loggers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Elt.class);
    public static final String POSITION_NAME = "position";
    public static final String IS_DERIVED_NAME = "isDerived";
    public static final String RAW_EDI_NAME = "edi";
    @Transient
    static final EdiTextRenderer ediTextRenderer = new EdiTextRenderer().useFriendlyNames(false).buildLoopHierarchy(true);
    private String ncpdpId;
    private boolean isDerived;
    private String ediDelim;
    private int position;
    private int parentPosition = -1;
    private String rawEdiString;
    private boolean isFixedWidth;
    private int maxWidth = -1;
    private int minWidth = -1;
    private DataType dataType;
    private boolean isCurrency;
    private int index;
    private int parentIndex;
    @Transient
    private Elt parentElement;
    private String name;
    private Object val;
    private EltSet eltSet;
    private LocalDate dateVal;
    private LocalDateTime dateTimeVal;
    private LocalTime timeVal;
    private DatePair datePair;
    private Integer intVal;
    private Float floatVal;
    private Double doubleVal;
    private BigDecimal bigDecimalVal;
    private final List<EltSet> eltSets = new ArrayList<EltSet>();
    private EdiQualifier qualifier;
    private CodeEntity codeEntity;
    private boolean isFailedConversion;
    @JsonIgnore
    private final QualifierResolver qualifierResolver = new QualifierResolver();
    public static final String SPECIAL_NAME_SUFFIX_DELIM = "##";
    @Transient
    private final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    public String toFormattedString() {
        return ediTextRenderer.renderEltAsString(this);
    }

    private Elt(String name) {
        this.name(name);
    }

    public Elt codeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
        return this;
    }

    public Elt(String name, Elt anotherElt) {
        this.name = name;
        this.isDerived = anotherElt.isDerived;
        this.ediDelim = anotherElt.ediDelim;
        this.position = anotherElt.position;
        this.rawEdiString = anotherElt.rawEdiString;
        this.dataType = anotherElt.dataType;
        this.index = anotherElt.index;
        this.parentIndex = anotherElt.parentIndex;
        this.val = anotherElt.val;
        this.intVal = anotherElt.intVal;
        this.doubleVal = anotherElt.doubleVal;
        this.floatVal = anotherElt.floatVal;
        this.dateVal = anotherElt.dateVal;
        this.timeVal = anotherElt.timeVal;
        this.dateTimeVal = anotherElt.dateTimeVal;
        this.eltSet = anotherElt.eltSet;
        this.qualifier = anotherElt.qualifier;
        this.codeEntity = anotherElt.codeEntity;
        this.isFailedConversion = anotherElt.isFailedConversion;
    }

    public BigDecimal bigDecimalVal() {
        if (this.bigDecimalVal != null) {
            return this.bigDecimalVal;
        }
        if (this.doubleVal != null) {
            return new BigDecimal(this.doubleVal).setScale(2, RoundingMode.HALF_UP);
        }
        if (this.floatVal != null) {
            return new BigDecimal(this.floatVal.floatValue()).setScale(2, RoundingMode.HALF_UP);
        }
        if (this.intVal != null) {
            return new BigDecimal(this.intVal).setScale(0, RoundingMode.HALF_UP);
        }
        return null;
    }

    public String stringVal() {
        return this.valAsStr();
    }

    public boolean isSimple() {
        return this.eltSet == null && this.eltSets.isEmpty();
    }

    public boolean isRawValue() {
        return this.dataType == DataType.STR && StringUtils.equalsIgnoreCase((CharSequence)"value", (CharSequence)this.name);
    }

    public String valAsStr() {
        if (this.val == null) {
            return null;
        }
        String s = this.dataType == DataType.QUALIFIER ? this.qualifier.toSummaryString() : (this.dataType == DataType.ELT_SET ? "{...}" : (this.dataType == DataType.DATE ? this.dateVal.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL)) : (this.dataType == DataType.DATE_TIME ? this.dateTimeVal.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.MEDIUM)) : this.val.toString())));
        return s;
    }

    public String ediString() {
        String ediString = this.dataType == DataType.ELT_SET ? this.eltSet.getRawValue() : this.val.toString();
        return ediString;
    }

    public String friendlyName() {
        String cleanName = StringUtils.substringBefore((String)this.name, (String)SPECIAL_NAME_SUFFIX_DELIM);
        if (StringUtils.isAllUpperCase((CharSequence)StringUtils.left((String)cleanName, (int)2))) {
            return cleanName;
        }
        return NameUtils.capitalize(cleanName);
    }

    public Elt name(String nm) {
        this.name = NameUtils.cleanName(nm);
        return this;
    }

    public static Elt fromSimpleVal(String name, Object val) {
        return Elt.fromSimpleVal(null, name, val, null);
    }

    public static Elt fromSimpleVal(EltSet owningEltSet, String name, Object val, EdiQualifier qualifier) {
        Elt elt = new Elt(name);
        elt.setSimpleVal(owningEltSet, name, val, qualifier, null, null);
        return elt;
    }

    public static Elt fromSimpleVal(EltSet owningEltSet, String name, Object val, EdiQualifier qualifier, EdiParsingResults parsingResults, EltValHolder eltValHolder) {
        Elt elt = new Elt(name);
        elt.setSimpleVal(owningEltSet, name, val, qualifier, parsingResults, eltValHolder);
        return elt;
    }

    public static Elt fromEltHolder(EltSet owningEltSet, EltValHolder eltValHolder, EdiQualifier qualifier, EdiParsingResults parsingResults) {
        String name = eltValHolder.eltMeta().getJsonName();
        Object val = eltValHolder.value();
        Elt elt = Elt.fromSimpleVal(owningEltSet, name, val, qualifier, parsingResults, eltValHolder);
        elt.rawEdiString = eltValHolder.rawValue();
        elt.position = eltValHolder.eltMeta().getIndex();
        if (!elt.isFailedConversion) {
            elt.isFailedConversion = eltValHolder.isFailedConversion();
        }
        return elt;
    }

    public static Elt fromEltSet(String name, EltSet eltSet) {
        Elt elt = new Elt(name);
        elt.eltSet = eltSet.parentElt(elt);
        elt.dataType = DataType.ELT_SET;
        elt.val = eltSet;
        return elt;
    }

    private void setSimpleVal(EltSet eltSet, String name, Object objVal, EdiQualifier myQualifier, EdiParsingResults parsingResults, EltValHolder eltValHolder) {
        this.val = objVal;
        if (objVal instanceof String) {
            String str = (String)objVal;
            if (myQualifier instanceof DateFormatType) {
                this.setDate((DateFormatType)myQualifier, str, parsingResults, eltValHolder);
            } else {
                EdiQualifier possibleEnum = null;
                if (eltSet != null && (possibleEnum = this.qualifierResolver.resolveEnums(eltSet.parentSeg(), name, objVal)) != null) {
                    this.qualifier = possibleEnum;
                    this.val = possibleEnum;
                    this.dataType = DataType.QUALIFIER;
                }
                if (possibleEnum == null) {
                    this.dataType = DataType.STR;
                }
            }
        } else if (objVal instanceof EdiQualifier) {
            EdiQualifier ediQualifier = (EdiQualifier)objVal;
            this.dataType = DataType.QUALIFIER;
            this.qualifier = ediQualifier;
        } else if (objVal instanceof CodeEntity) {
            this.dataType = DataType.CODE_ENTITY;
            this.codeEntity = (CodeEntity)objVal;
        } else if (objVal instanceof Float) {
            this.dataType = DataType.FLOAT;
            this.floatVal = (Float)objVal;
        } else if (objVal instanceof Double) {
            this.dataType = DataType.DOUBLE;
            this.doubleVal = (Double)objVal;
        } else if (objVal instanceof BigDecimal) {
            this.dataType = DataType.BIG_DEC;
            this.bigDecimalVal = (BigDecimal)objVal;
        } else if (objVal instanceof Integer) {
            this.dataType = DataType.INT;
            this.intVal = (Integer)objVal;
        } else if (objVal instanceof LocalDate) {
            LocalDate ld = (LocalDate)objVal;
            this.dataType = DataType.DATE;
            this.dateVal = ld;
        } else if (objVal instanceof DatePair) {
            DatePair dates = (DatePair)objVal;
            this.dataType = DataType.DATE_INTERVAL;
            this.datePair = dates;
        } else if (objVal instanceof LocalDateTime) {
            this.dataType = DataType.DATE_TIME;
            this.dateTimeVal = (LocalDateTime)objVal;
        } else if (objVal instanceof LocalTime) {
            this.dataType = DataType.TIME;
            this.timeVal = (LocalTime)objVal;
        } else {
            this.dataType = objVal instanceof EltSet ? DataType.ELT_SET : DataType.OBJ;
        }
    }

    private void setDate(DateFormatType dateFormatType, String dateStr, EdiParsingResults parsingResults, EltValHolder eltValHolder) {
        this.dataType = DataType.STR;
        if (eltValHolder != null && eltValHolder.isFailedConversion()) {
            return;
        }
        dateStr = StringUtils.strip((String)dateStr);
        try {
            if (dateFormatType == DateFormatType.DATE || dateFormatType == DateFormatType.DATE_PERIOD) {
                this.dateVal = EdiDateUtils.localDateFromStr(dateStr);
                this.dataType = DataType.DATE;
                this.val = this.dateVal;
                return;
            }
            if (dateFormatType == DateFormatType.DATE_TIME) {
                this.dateTimeVal = EdiDateUtils.localDateTimeFromStr(dateStr);
                this.dataType = DataType.DATE_TIME;
                this.val = this.dateTimeVal;
                return;
            }
            if (dateFormatType == DateFormatType.TIME) {
                this.timeVal = EdiDateUtils.localTimeFromStr(dateStr);
                this.dataType = DataType.TIME;
                this.val = this.timeVal;
            }
        }
        catch (DateTimeParseException parseException) {
            int segNumber = -1;
            int lineNumber = -1;
            String eltName = this.name;
            if (eltValHolder != null) {
                segNumber = eltValHolder.segmentNumber();
                lineNumber = eltValHolder.lineNumber();
                eltName = eltValHolder.eltMeta().getDesignatorNameForLogging();
            }
            String msg = String.format("Element: %s: Error parsing '%s' as '%s', error: %s", eltName, dateStr, dateFormatType.desc(), parseException.getMessage());
            this.isFailedConversion = true;
            if (parsingResults != null) {
                ParsingIssue parsingIssue = new ParsingIssue(segNumber, msg).lineNumber(lineNumber);
                ediParsingIssuesLogger.warn(parsingIssue.toFormattedString());
                parsingResults.addParsingIssue(parsingIssue);
            }
            log.warn(msg);
        }
    }

    public static int compareByName(Elt elt1, Elt elt2) {
        return elt1.friendlyName().compareToIgnoreCase(elt2.friendlyName());
    }

    public static int compareByVal(Elt elt1, Elt elt2) {
        return elt1.valAsStr().compareToIgnoreCase(elt2.valAsStr());
    }

    public String toString() {
        return this.name + ": " + this.valAsStr();
    }

    public String toNameAndIndexString() {
        return this.name + SPECIAL_NAME_SUFFIX_DELIM + this.parentIndex + "-" + this.index;
    }

    public static String toNameAndIndexString(Elt elt) {
        if (elt == null) {
            return null;
        }
        return elt.toNameAndIndexString();
    }

    public JsonNode toJsonNode() {
        if (this.val instanceof Collection) {
            ArrayNode arrayNode = this.nodeFactory.arrayNode();
            for (Object val : (Collection)this.val) {
                if (val == null) continue;
                arrayNode.add(val.toString());
            }
            return arrayNode;
        }
        return switch (this.dataType) {
            case DataType.FLOAT -> this.nodeFactory.numberNode(this.floatVal);
            case DataType.DOUBLE -> this.nodeFactory.numberNode(this.doubleVal);
            case DataType.INT -> this.nodeFactory.numberNode(this.intVal);
            case DataType.BIG_DEC -> this.nodeFactory.numberNode(this.bigDecimalVal);
            case DataType.DATE -> this.nodeFactory.textNode(this.dateVal.format(DateTimeFormatter.ISO_LOCAL_DATE));
            case DataType.DATE_TIME -> this.nodeFactory.textNode(this.dateTimeVal.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            case DataType.QUALIFIER -> this.createQualifierNode();
            default -> this.nodeFactory.textNode(this.valAsStr());
        };
    }

    private JsonNode createQualifierNode() {
        ObjectNode node = this.nodeFactory.objectNode();
        node.set("code", (JsonNode)this.nodeFactory.textNode(this.qualifier.ediValue()));
        if (StringUtils.isNotBlank((CharSequence)this.qualifier.desc())) {
            node.set("desc", (JsonNode)this.nodeFactory.textNode(this.qualifier.desc()));
        }
        return node;
    }

    @Generated
    public Elt() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Elt)) {
            return false;
        }
        Elt other = (Elt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.position() != other.position()) {
            return false;
        }
        if (this.index() != other.index()) {
            return false;
        }
        if (this.parentIndex() != other.parentIndex()) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Elt;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.position();
        result = result * 59 + this.index();
        result = result * 59 + this.parentIndex();
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String ncpdpId() {
        return this.ncpdpId;
    }

    @Generated
    public Elt ncpdpId(String ncpdpId) {
        this.ncpdpId = ncpdpId;
        return this;
    }

    @Generated
    public boolean isDerived() {
        return this.isDerived;
    }

    @Generated
    public Elt isDerived(boolean isDerived) {
        this.isDerived = isDerived;
        return this;
    }

    @Generated
    public String ediDelim() {
        return this.ediDelim;
    }

    @Generated
    public Elt ediDelim(String ediDelim) {
        this.ediDelim = ediDelim;
        return this;
    }

    @Generated
    public int position() {
        return this.position;
    }

    @Generated
    public Elt position(int position) {
        this.position = position;
        return this;
    }

    @Generated
    public int parentPosition() {
        return this.parentPosition;
    }

    @Generated
    public Elt parentPosition(int parentPosition) {
        this.parentPosition = parentPosition;
        return this;
    }

    @Generated
    public String rawEdiString() {
        return this.rawEdiString;
    }

    @Generated
    public Elt rawEdiString(String rawEdiString) {
        this.rawEdiString = rawEdiString;
        return this;
    }

    @Generated
    public boolean isFixedWidth() {
        return this.isFixedWidth;
    }

    @Generated
    public Elt isFixedWidth(boolean isFixedWidth) {
        this.isFixedWidth = isFixedWidth;
        return this;
    }

    @Generated
    public int maxWidth() {
        return this.maxWidth;
    }

    @Generated
    public Elt maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    @Generated
    public int minWidth() {
        return this.minWidth;
    }

    @Generated
    public Elt minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    @Generated
    public DataType dataType() {
        return this.dataType;
    }

    @Generated
    public Elt dataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Generated
    public boolean isCurrency() {
        return this.isCurrency;
    }

    @Generated
    public Elt isCurrency(boolean isCurrency) {
        this.isCurrency = isCurrency;
        return this;
    }

    @Generated
    public Elt index(int index) {
        this.index = index;
        return this;
    }

    @Generated
    public int index() {
        return this.index;
    }

    @Generated
    public Elt parentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
        return this;
    }

    @Generated
    public int parentIndex() {
        return this.parentIndex;
    }

    @Generated
    public Elt parentElement(Elt parentElement) {
        this.parentElement = parentElement;
        return this;
    }

    @Generated
    public Elt parentElement() {
        return this.parentElement;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public Object val() {
        return this.val;
    }

    @Generated
    public EltSet eltSet() {
        return this.eltSet;
    }

    @Generated
    public LocalDate dateVal() {
        return this.dateVal;
    }

    @Generated
    public LocalDateTime dateTimeVal() {
        return this.dateTimeVal;
    }

    @Generated
    public LocalTime timeVal() {
        return this.timeVal;
    }

    @Generated
    public DatePair datePair() {
        return this.datePair;
    }

    @Generated
    public Integer intVal() {
        return this.intVal;
    }

    @Generated
    public Float floatVal() {
        return this.floatVal;
    }

    @Generated
    public Double doubleVal() {
        return this.doubleVal;
    }

    @Generated
    public List<EltSet> eltSets() {
        return this.eltSets;
    }

    @Generated
    public EdiQualifier qualifier() {
        return this.qualifier;
    }

    @Generated
    public CodeEntity codeEntity() {
        return this.codeEntity;
    }

    @Generated
    public boolean isFailedConversion() {
        return this.isFailedConversion;
    }

    @Generated
    public Elt isFailedConversion(boolean isFailedConversion) {
        this.isFailedConversion = isFailedConversion;
        return this;
    }
}

