/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.edi.OwnerIdHolder;
import hdi.edi.edient.EdiEntFactory;
import hdi.edi.edient.EdiEntity;
import hdi.edi.legacyparser.EdiSegment;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.NameUtils;
import hdi.edi.parser.SegmentType;
import hdi.edi.parserhelper.EdiTextRenderer;
import hdi.edi.qualifier.EdiQualifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class EdiSeg {
    private ObjectId objId;
    private ObjectId parentObjId;
    private boolean isParent;
    private String name;
    private String loop;
    private SegmentType type;
    private String stringType;
    private EltSet eltSet;
    private List<EdiSeg> childSegs = new ArrayList<EdiSeg>();
    private EdiSeg parentSeg;
    @Transient
    private EdiSeparators ediSeparators;
    private boolean isArray;
    private boolean isLoopParent;
    private List<String> rawElts = new ArrayList<String>();
    @JsonIgnore
    private int index;
    @JsonIgnore
    private int indexWithinTran;
    @JsonIgnore
    private EdiEntity entity;
    @JsonIgnore
    private OwnerIdHolder ownerIdHolder = new OwnerIdHolder();
    static final EdiEntFactory entityFactory = new EdiEntFactory();
    private Consumer<CodeEntity> codeEntityConsumer;
    static final EdiTextRenderer ediTextRenderer = new EdiTextRenderer().useFriendlyNames(false).buildLoopHierarchy(true);

    public void parentSeg(EdiSeg parentSeg) {
        this.parentSeg = parentSeg;
    }

    public EdiSeg index(int index) {
        this.index = index;
        return this;
    }

    public boolean isClaim() {
        return this.type == SegmentType.CLM;
    }

    public boolean isLoop() {
        return this.type == SegmentType.LOOP;
    }

    public String id() {
        StringBuilder id = new StringBuilder(this.loop + "_" + this.typeAsString() + "_" + this.index);
        EdiSeg parent = this;
        while ((parent = parent.parentSeg) != null) {
            id.append("-").append(parent.id());
        }
        return id.toString();
    }

    public EltSet eltSet() {
        if (this.eltSet == null) {
            return new EltSet(this);
        }
        return this.eltSet;
    }

    public EdiSeg(EdiSeg otherEdiSeg) {
        this.entity = otherEdiSeg.entity;
        this.eltSet = otherEdiSeg.eltSet;
        this.index = otherEdiSeg.index;
        this.indexWithinTran = otherEdiSeg.indexWithinTran;
        this.loop = otherEdiSeg.loop;
        this.name = otherEdiSeg.name;
        this.objId = otherEdiSeg.objId;
        this.rawElts = otherEdiSeg.rawElts;
        this.stringType = otherEdiSeg.stringType;
        this.type = otherEdiSeg.type;
        this.isParent = otherEdiSeg.isParent;
        this.parentObjId = otherEdiSeg.parentObjId;
    }

    public static EdiSeg cloneKeySegInfo(EdiSeg otherEdiSeg) {
        EdiSeg seg = new EdiSeg(otherEdiSeg);
        seg.entity(null);
        seg.eltSet = null;
        if (otherEdiSeg.parentSeg != null) {
            seg.parentSeg = EdiSeg.cloneKeySegInfo(otherEdiSeg.parentSeg);
        }
        return seg;
    }

    public EdiSeg(EdiSegment legacySegment) {
        this(legacySegment, null, false, null);
    }

    public EdiSeg(EdiSegment legacySegment, boolean createLoopHierarchy, EdiParsingResults ediParsingResults) {
        this(legacySegment, null, createLoopHierarchy, ediParsingResults);
    }

    public EdiSeg(EdiSegment legacySeg, EdiSeg parentSeg, boolean createLoopHierarchy, EdiParsingResults ediParsingResults) {
        this.objId = ObjectId.get();
        this.isLoopParent = legacySeg.isLoopParent();
        if (parentSeg != null) {
            this.parentObjId = parentSeg.objId;
        }
        if (ediParsingResults != null) {
            this.indexWithinTran = ediParsingResults.getCurrentIndexAndIncrement();
        }
        this.populateFromLegacySegment(legacySeg, parentSeg, createLoopHierarchy, ediParsingResults);
        if (ediParsingResults != null) {
            ediParsingResults.mapEntities(this);
            this.ownerIdHolder = ediParsingResults.createOwner();
        }
    }

    public EdiSeg(SegmentType type) {
        this.type = type;
    }

    public EdiSeg(String loop, SegmentType type, String name) {
        this.loop = loop;
        this.type = type;
        this.name = NameUtils.cleanName(name);
        this.objId = ObjectId.get();
    }

    public EdiSeg(String segTypeStr, String name) {
        this.stringType = segTypeStr;
        this.name = name;
        this.type = SegmentType.fromTag(segTypeStr);
        this.objId = ObjectId.get();
    }

    public EdiSeg name(String name) {
        this.name = NameUtils.cleanName(name);
        return this;
    }

    public void addChild(EdiSeg seg) {
        this.childSegs.add(seg);
        seg.index = this.childSegs.size() - 1;
    }

    public List<EdiSeg> findChildSegs(SegmentType ... segTypes) {
        ArrayList<EdiSeg> foundSegs = new ArrayList<EdiSeg>();
        for (EdiSeg child : this.childSegs) {
            if (child.isInType(segTypes)) {
                foundSegs.add(child);
            }
            List<EdiSeg> matchedChildren = child.findChildSegs(segTypes);
            foundSegs.addAll(matchedChildren);
        }
        return foundSegs;
    }

    public EdiSeg findFirstChildSeg(SegmentType ... segTypes) {
        List<EdiSeg> segs = this.findChildSegs(segTypes);
        if (!segs.isEmpty()) {
            return segs.get(0);
        }
        return null;
    }

    public boolean isInType(SegmentType ... segTypes) {
        for (SegmentType st : segTypes) {
            if (st != this.type) continue;
            return true;
        }
        return false;
    }

    public boolean isInLoop(String ... loopNames) {
        for (String loopName : loopNames) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.loop, (CharSequence)loopName)) continue;
            return true;
        }
        return false;
    }

    public boolean isParentOf(EdiSeg seg) {
        return seg.parentSeg() != null && seg.parentSeg().indexWithinTran == this.indexWithinTran;
    }

    public boolean isSiblingOf(EdiSeg seg) {
        return this.isSameLoopOf(seg) && seg.parentSeg() != null && this.parentSeg != null && seg.parentSeg().indexWithinTran == this.parentSeg.indexWithinTran;
    }

    public boolean isParentOrSiblingOf(EdiSeg seg) {
        return this.isParentOf(seg) || this.isSiblingOf(seg);
    }

    public boolean isSameLoopOf(EdiSeg seg) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.loop, (CharSequence)seg.loop);
    }

    public boolean isAncestorOf(EdiSeg descSeg) {
        for (EdiSeg curSeg = descSeg; curSeg != null; curSeg = curSeg.parentSeg()) {
            if (!this.isParentOf(curSeg)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameLoop(EdiSeg seg) {
        int theirsLoopInd = -1;
        int myLoopInd = -1000;
        if (seg.parentSeg == this) {
            myLoopInd = this.indexWithinTran;
        } else if (this.parentSeg != null) {
            myLoopInd = this.parentSeg.indexWithinTran;
        }
        if (this.parentSeg == seg) {
            theirsLoopInd = seg.indexWithinTran;
        } else if (seg.parentSeg != null) {
            theirsLoopInd = seg.parentSeg.indexWithinTran;
        }
        return myLoopInd == theirsLoopInd;
    }

    public Object eltVal(String name) {
        return this.eltSet.eltVal(name);
    }

    private void populateFromLegacySegment(EdiSegment legacySegment, EdiSeg parentSeg, boolean buildLoopHierarchy, EdiParsingResults ediParsingResults) {
        this.loop = StringUtils.stripToNull((String)legacySegment.loop());
        this.type = legacySegment.type();
        this.stringType = legacySegment.tag();
        this.parentSeg = parentSeg;
        this.isArray = legacySegment.isArray();
        this.name(NameUtils.cleanSegmentName(legacySegment.name()));
        List<String> legacyRawElts = legacySegment.rawElts();
        if (!legacyRawElts.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)legacySegment.tag(), (CharSequence)legacyRawElts.get(0))) {
            legacyRawElts = legacyRawElts.subList(1, legacyRawElts.size());
        }
        this.rawElts.addAll(legacyRawElts);
        this.populateElements(legacySegment, ediParsingResults);
        if (parentSeg == null) {
            parentSeg = this;
        } else {
            parentSeg.addChild(this);
        }
        this.entity = entityFactory.createEntityForSeg(this, ediParsingResults);
        if (!legacySegment.segments().isEmpty()) {
            if (buildLoopHierarchy) {
                EdiSeg parentSegmentForChildren = this;
                if (parentSeg.type() == SegmentType.LOOP) {
                    parentSegmentForChildren = parentSeg;
                }
                this.groupSegmentsByLoops(parentSegmentForChildren, legacySegment.segments(), ediParsingResults);
            } else {
                for (EdiSegment legacySeg : legacySegment.segments()) {
                    new EdiSeg(legacySeg, this, false, ediParsingResults);
                }
            }
        }
    }

    private void groupSegmentsByLoops(EdiSeg masterParentSeg, List<EdiSegment> legacySegments, EdiParsingResults ediParsingResults) {
        String curLoop = masterParentSeg.loop;
        EdiSeg curParent = masterParentSeg;
        for (EdiSegment legacySeg : legacySegments) {
            if (legacySeg.isSwitchToParent()) {
                curLoop = masterParentSeg.loop;
                curParent = masterParentSeg;
                new EdiSeg(legacySeg, masterParentSeg, false, ediParsingResults);
                continue;
            }
            if (legacySeg.isLoopParent()) {
                curParent = new EdiSeg(legacySeg, masterParentSeg, true, ediParsingResults);
            } else if (!StringUtils.equals((CharSequence)curLoop, (CharSequence)legacySeg.loop())) {
                legacySeg.isLoopParent(true);
                curParent = new EdiSeg(legacySeg, masterParentSeg, true, ediParsingResults);
            } else {
                new EdiSeg(legacySeg, curParent, true, ediParsingResults);
            }
            curLoop = legacySeg.loop();
        }
    }

    private void populateElements(EdiSegment legacySegment, EdiParsingResults parsingResults) {
        this.eltSet = EltSet.fromLegacySegment(this, legacySegment, parsingResults);
    }

    public String typeAsString() {
        if (this.type != null) {
            return this.type.name();
        }
        return this.stringType;
    }

    public String loopTypeName() {
        return StringUtils.joinWith((String)" - ", (Object[])new Object[]{this.loop, this.typeAsString(), NameUtils.capitalize(this.name)});
    }

    public String rawString() {
        EdiSeparators seps = this.getEdiSeparatorsForRendering();
        return StringUtils.join(this.rawElts, (String)seps.elementSeparator());
    }

    public String rawStringWithSegID() {
        EdiSeparators seps = this.getEdiSeparatorsForRendering();
        ArrayList<String> toJoin = new ArrayList<String>();
        toJoin.add(this.typeAsString());
        toJoin.addAll(this.rawElts);
        String eltSep = seps.elementSeparator();
        if (this.isFixedWidth()) {
            eltSep = "";
        }
        return StringUtils.join(toJoin, (String)eltSep) + seps.segmentTerminatorToRender();
    }

    public boolean isFixedWidth() {
        Elt elt = this.eltSet.eltByIndex(0);
        if (elt != null) {
            return elt.isFixedWidth();
        }
        return false;
    }

    public EdiSeparators getEdiSeparatorsForRendering() {
        EdiSeparators seps = this.ediSeparators;
        if (seps == null) {
            seps = EdiSeparators.DEFAULT_EDI_SEPARATORS;
        }
        return seps;
    }

    public String friendlyName() {
        return NameUtils.capitalize(this.name);
    }

    public boolean isUnknown() {
        return StringUtils.isBlank((CharSequence)this.name);
    }

    public boolean containsQualifier(EdiQualifier qualifier) {
        return this.containsQualifier(this.eltSet, qualifier);
    }

    private boolean containsQualifier(EltSet eltSet, EdiQualifier qualifier) {
        if (eltSet != null) {
            for (Elt elt : eltSet.elts()) {
                if (elt.dataType() == DataType.QUALIFIER && elt.qualifier().equals(qualifier)) {
                    return true;
                }
                if (elt.dataType() != DataType.ELT_SET || !this.containsQualifier(elt.eltSet(), qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    public String getQualifierCode() {
        Elt elt;
        if (this.isInType(SegmentType.REF, SegmentType.DTP, SegmentType.AMT, SegmentType.QTY) && (elt = this.eltSet.eltByPosition(1)) != null) {
            if (elt.dataType() == DataType.QUALIFIER) {
                return elt.qualifier().ediValue();
            }
            return elt.stringVal();
        }
        return null;
    }

    private EdiSeg findLeafParent() {
        EdiSeg curLeafParent;
        EdiSeg leafParent = this;
        while ((curLeafParent = this.findLastParent(leafParent)) != null) {
            leafParent = curLeafParent;
        }
        return leafParent;
    }

    private EdiSeg findLastParent(EdiSeg parentSeg) {
        List<EdiSeg> segs = parentSeg.childSegs;
        EdiSeg lastParent = null;
        for (EdiSeg seg : segs) {
            if (seg.childSegs.isEmpty()) continue;
            lastParent = seg;
        }
        return lastParent;
    }

    public Elt eltByName(String name) {
        return this.eltSet.eltByName(name);
    }

    public Elt eltByPosition(int position) {
        return this.eltSet.eltByPosition(position);
    }

    public Object eltValByPosition(int position) {
        Elt elt = this.eltSet.eltByPosition(position);
        if (elt != null) {
            return elt.val();
        }
        return null;
    }

    public String eltStringValByPosition(int position) {
        Elt elt = this.eltSet.eltByPosition(position);
        if (elt != null) {
            return elt.stringVal();
        }
        return null;
    }

    public BigDecimal eltDecimalValByPosition(int position) {
        Elt elt = this.eltSet.eltByPosition(position);
        if (elt != null) {
            return elt.bigDecimalVal();
        }
        return null;
    }

    public Double eltDoubleValByPosition(int position) {
        Elt elt = this.eltSet.eltByPosition(position);
        if (elt != null) {
            return elt.doubleVal();
        }
        return null;
    }

    public LocalDate eltDateValByPosition(int position) {
        Elt elt = this.eltSet.eltByPosition(position);
        if (elt != null) {
            return elt.dateVal();
        }
        return null;
    }

    public String toFormattedString() {
        return ediTextRenderer.renderSegAsString(this, 0);
    }

    public String toFormattedStringWithChildren() {
        return ediTextRenderer.render(this);
    }

    public static String toFormattedStringWithChildren(List<EdiSeg> segs) {
        return ediTextRenderer.render(segs);
    }

    @Generated
    public ObjectId objId() {
        return this.objId;
    }

    @Generated
    public ObjectId parentObjId() {
        return this.parentObjId;
    }

    @Generated
    public boolean isParent() {
        return this.isParent;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String loop() {
        return this.loop;
    }

    @Generated
    public SegmentType type() {
        return this.type;
    }

    @Generated
    public String stringType() {
        return this.stringType;
    }

    @Generated
    public List<EdiSeg> childSegs() {
        return this.childSegs;
    }

    @Generated
    public EdiSeg parentSeg() {
        return this.parentSeg;
    }

    @Generated
    public EdiSeparators ediSeparators() {
        return this.ediSeparators;
    }

    @Generated
    public boolean isArray() {
        return this.isArray;
    }

    @Generated
    public boolean isLoopParent() {
        return this.isLoopParent;
    }

    @Generated
    public List<String> rawElts() {
        return this.rawElts;
    }

    @JsonIgnore
    @Generated
    public int index() {
        return this.index;
    }

    @JsonIgnore
    @Generated
    public int indexWithinTran() {
        return this.indexWithinTran;
    }

    @JsonIgnore
    @Generated
    public EdiEntity entity() {
        return this.entity;
    }

    @JsonIgnore
    @Generated
    public OwnerIdHolder ownerIdHolder() {
        return this.ownerIdHolder;
    }

    @Generated
    public Consumer<CodeEntity> codeEntityConsumer() {
        return this.codeEntityConsumer;
    }

    @Generated
    public String toString() {
        return "EdiSeg(objId=" + String.valueOf(this.objId()) + ", parentObjId=" + String.valueOf(this.parentObjId()) + ", isParent=" + this.isParent() + ", name=" + this.name() + ", loop=" + this.loop() + ", type=" + String.valueOf((Object)this.type()) + ", eltSet=" + String.valueOf(this.eltSet()) + ", isArray=" + this.isArray() + ", isLoopParent=" + this.isLoopParent() + ", index=" + this.index() + ", indexWithinTran=" + this.indexWithinTran() + ", entity=" + String.valueOf(this.entity()) + ", codeEntityConsumer=" + String.valueOf(this.codeEntityConsumer()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdiSeg)) {
            return false;
        }
        EdiSeg other = (EdiSeg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectId this$objId = this.objId();
        ObjectId other$objId = other.objId();
        return !(this$objId == null ? other$objId != null : !this$objId.equals(other$objId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdiSeg;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectId $objId = this.objId();
        result = result * 59 + ($objId == null ? 43 : $objId.hashCode());
        return result;
    }

    @Generated
    public EdiSeg objId(ObjectId objId) {
        this.objId = objId;
        return this;
    }

    @Generated
    public EdiSeg parentObjId(ObjectId parentObjId) {
        this.parentObjId = parentObjId;
        return this;
    }

    @Generated
    public EdiSeg isParent(boolean isParent) {
        this.isParent = isParent;
        return this;
    }

    @Generated
    public EdiSeg loop(String loop) {
        this.loop = loop;
        return this;
    }

    @Generated
    public EdiSeg eltSet(EltSet eltSet) {
        this.eltSet = eltSet;
        return this;
    }

    @Generated
    public EdiSeg childSegs(List<EdiSeg> childSegs) {
        this.childSegs = childSegs;
        return this;
    }

    @Generated
    public EdiSeg ediSeparators(EdiSeparators ediSeparators) {
        this.ediSeparators = ediSeparators;
        return this;
    }

    @Generated
    public EdiSeg isLoopParent(boolean isLoopParent) {
        this.isLoopParent = isLoopParent;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiSeg indexWithinTran(int indexWithinTran) {
        this.indexWithinTran = indexWithinTran;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiSeg entity(EdiEntity entity) {
        this.entity = entity;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiSeg ownerIdHolder(OwnerIdHolder ownerIdHolder) {
        this.ownerIdHolder = ownerIdHolder;
        return this;
    }

    @Generated
    public EdiSeg codeEntityConsumer(Consumer<CodeEntity> codeEntityConsumer) {
        this.codeEntityConsumer = codeEntityConsumer;
        return this;
    }
}

