/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import hdi.edi.openedi.InputStandardType;
import hdi.edi.openedi.LoopSchema;
import hdi.edi.openedi.LoopSegRef;
import hdi.edi.openedi.OpenEdiUtils;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.SegSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSchema {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionSchema.class);
    private final Map<String, SegSchema> segById = new HashMap<String, SegSchema>();
    private final List<LoopSchema> loops = new ArrayList<LoopSchema>();
    private LoopSchema rootLoop;
    private final Map<String, LoopSchema> loopsById = new HashMap<String, LoopSchema>();
    private final Map<String, Integer> loopCountByLoopId = new HashMap<String, Integer>();
    private final Map<String, SchemaComponent> schemaComponents = new HashMap<String, SchemaComponent>();
    private String fileName;

    public LoopSegRef findSeg(String currentLoopId, String segId, String segCode) {
        LoopSchema loop = this.loopsById.get(currentLoopId);
        if (loop == null) {
            log.warn("Did not find loop {}", (Object)currentLoopId);
            return null;
        }
        return loop.findSeg(segId, segCode, new LinkedHashSet<String>());
    }

    public void addSeg(SegSchema seg) {
        if (!this.segById.containsKey(seg.id)) {
            this.segById.put(seg.id(), seg);
        }
    }

    public void addLoop(LoopSchema loop) {
        this.loops.add(loop);
        if (this.loopsById.containsKey(loop.id())) {
            log.warn("Loop with the ID {} was already scanned, we should not have non-unique loop IDs", (Object)loop.id());
        } else {
            this.loopsById.put(loop.id(), loop);
        }
        if (loop.transactionId() != null) {
            this.rootLoop = loop;
        }
    }

    public void addSchemaComponent(SchemaComponent schemaComponent) {
        String key = schemaComponent.schemaName();
        SchemaComponent existingSchemaComp = this.schemaComponents.get(key);
        if (existingSchemaComp != null) {
            log.warn("Component for the name {} already exists in the schema:\n{}", (Object)key, (Object)existingSchemaComp);
        }
        this.schemaComponents.put(key, schemaComponent);
    }

    public SegSchema findFirstSegById(String segId) {
        return this.segById.getOrDefault(segId, null);
    }

    public LoopSchema findLoopById(String id) {
        return this.loopsById.get(id);
    }

    public SchemaComponent findSchemaComponentByRef(String ref) {
        SchemaComponent schemaComponent = null;
        String refSchemaName = OpenEdiUtils.getSchemaNameFromRef(ref);
        if (StringUtils.isNotBlank((CharSequence)refSchemaName)) {
            schemaComponent = this.schemaComponents.get(refSchemaName);
        }
        return schemaComponent;
    }

    public SchemaComponent findSchemaComponentBySchemaName(String schemaName) {
        SchemaComponent schemaComponent = null;
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            schemaComponent = this.schemaComponents.get(schemaName);
        }
        return schemaComponent;
    }

    public boolean matches(String transactionId, String version) {
        if (this.rootLoop == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)transactionId, (CharSequence)this.rootLoop.transactionId()) && (StringUtils.isBlank((CharSequence)version) || StringUtils.isBlank((CharSequence)this.rootLoop.messageVersion()) || StringUtils.equalsIgnoreCase((CharSequence)version, (CharSequence)this.rootLoop.messageVersion()));
    }

    public String transactionId() {
        if (this.rootLoop == null) {
            return null;
        }
        return this.rootLoop.transactionId();
    }

    public InputStandardType standardType() {
        if (this.rootLoop == null) {
            return null;
        }
        return this.rootLoop.standardType();
    }

    @Generated
    public List<LoopSchema> loops() {
        return this.loops;
    }

    @Generated
    public Map<String, Integer> loopCountByLoopId() {
        return this.loopCountByLoopId;
    }

    @Generated
    public TransactionSchema fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }
}

