/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.openedi.CompositeElementSchema;
import hdi.edi.openedi.ElementSchema;
import hdi.edi.openedi.OpenEdiUtils;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.SegSchema;
import hdi.edi.openedi.TransactionSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegOrCompositeElementSchema
extends SchemaComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegOrCompositeElementSchema.class);
    public static final String TYPE_NAME = "type";
    private final List<ElementSchema> elts = new ArrayList<ElementSchema>();
    private final Map<String, ElementSchema> eltById = new LinkedHashMap<String, ElementSchema>();
    private final Set<String> requiredElementSchemaNames = new LinkedHashSet<String>();
    public static final int HL_CODE_POS = 3;

    protected SegOrCompositeElementSchema(String jsonNodeName, JsonNode jsonNode, TransactionSchema schema, String idFieldName) {
        this.id = jsonNode.path(idFieldName).textValue();
        this.name = OpenEdiUtils.fixUpSegmentName(this.id, jsonNodeName);
        this.schemaName = jsonNodeName;
        this.populateRequiredNames(jsonNode);
        this.populateElements(jsonNode, schema);
    }

    protected SegOrCompositeElementSchema(String name) {
        this.name = name;
        this.id = name;
    }

    void addElement(ElementSchema elt) {
        this.elts.add(elt);
        this.eltById.put(elt.elementId(), elt);
    }

    private void populateRequiredNames(JsonNode jsonNode) {
        JsonNode requiredNode = jsonNode.get("required");
        if (requiredNode != null) {
            Iterator enumValuesIter = requiredNode.elements();
            while (enumValuesIter.hasNext()) {
                String enumVal = ((JsonNode)enumValuesIter.next()).asText();
                this.requiredElementSchemaNames.add(enumVal);
            }
        }
    }

    private void populateElements(JsonNode segNode, TransactionSchema schema) {
        int position;
        JsonNode props = segNode.get("properties");
        if (props == null) {
            return;
        }
        Iterator elementNodes = props.fields();
        int n = position = this instanceof CompositeElementSchema ? 0 : 1;
        while (elementNodes.hasNext()) {
            Map.Entry elementNameAndNode = (Map.Entry)elementNodes.next();
            String name = (String)elementNameAndNode.getKey();
            JsonNode elementNode = (JsonNode)elementNameAndNode.getValue();
            if (!ElementSchema.isElement(elementNode)) continue;
            ElementSchema elt = ElementSchema.fromJsonNode(name, elementNode, schema);
            if (this.requiredElementSchemaNames.contains(elt.schemaName())) {
                elt.isRequired(true);
            }
            elt.position(position++);
            this.addElt(elt);
        }
    }

    private void addElt(ElementSchema eltSchema) {
        this.elts.add(eltSchema);
        if (eltSchema.elementId() != null) {
            this.eltById.put(eltSchema.elementId(), eltSchema);
        }
        if (eltSchema.compositeElement() != null) {
            this.eltById.putAll(eltSchema.compositeElement().eltById());
        }
    }

    public Set<String> codes() {
        ElementSchema eltWithCode = this.getRequiredElementWithCode();
        if (eltWithCode != null) {
            return eltWithCode.enumValues();
        }
        return Set.of();
    }

    private ElementSchema getRequiredElementWithCode() {
        ElementSchema firstElt;
        if (this instanceof SegSchema && "HL".equals(this.id)) {
            if (this.elts.size() < 3) {
                log.warn("HL segment with less than {} elements", (Object)3);
                return null;
            }
            return this.elts.get(2);
        }
        if (!this.elts.isEmpty() && (firstElt = this.elts.get(0)).isRequired()) {
            return firstElt;
        }
        return null;
    }

    public ElementSchema findElementByName(String name) {
        for (ElementSchema elt : this.elts) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)elt.name())) continue;
            return elt;
        }
        return null;
    }

    public ElementSchema findElementById(String eltId) {
        return this.eltById.get(eltId);
    }

    public List<String> eltNames() {
        return this.elts.stream().map(ElementSchema::name).toList();
    }

    public List<ElementWithChildrenDictionary> eltsToLegacyElementDictionaries() {
        ArrayList<ElementWithChildrenDictionary> elementDictionaries = new ArrayList<ElementWithChildrenDictionary>();
        for (ElementSchema elt : this.elts) {
            ElementWithChildrenDictionary elementDictionary = elt.toLegacyElementDictionary();
            elementDictionaries.add(elementDictionary);
        }
        return elementDictionaries;
    }

    @Generated
    public List<ElementSchema> elts() {
        return this.elts;
    }

    @Generated
    public Map<String, ElementSchema> eltById() {
        return this.eltById;
    }

    @Generated
    public Set<String> requiredElementSchemaNames() {
        return this.requiredElementSchemaNames;
    }

    @Override
    @Generated
    public String toString() {
        return "SegOrCompositeElementSchema(super=" + super.toString() + ", eltById=" + String.valueOf(this.eltById()) + ", requiredElementSchemaNames=" + String.valueOf(this.requiredElementSchemaNames()) + ")";
    }
}

