/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.openedi.LoopSegRef;
import hdi.edi.openedi.OpenEdiNames;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.TransactionSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenEdiUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenEdiUtils.class);
    public static final Set<String> unbreakableWords = Set.of("i_d", "z_i_p", "e_f_t", "t_p_a", "_u_m_o_", "n_o_s", "b_i_n", "d_u_r_", "p_p_s", "c_o_b");
    public static final Set<String> prepositions = Set.of("for", "or", "of");
    public static final Set<String> preposExclusions = Set.of("indicator", "vendor", "sponsor");

    public static String nodeNameToEdiNameAfterPrefix(String nodeName) {
        String name = StringUtils.substringAfter((String)nodeName, (int)95);
        name = StringUtils.isEmpty((CharSequence)name) ? nodeName : OpenEdiUtils.camelCaseToUnderscore(name);
        return name;
    }

    public static String nodeNameToEdiNameBeforePrefix(String nodeName) {
        String name = StringUtils.substringBefore((String)nodeName, (int)95);
        return OpenEdiUtils.camelCaseToUnderscore(name);
    }

    public static String cutNumericalSuffix(String name) {
        String suffix = StringUtils.substringAfterLast((String)name, (int)95);
        if (StringUtils.isNumeric((CharSequence)suffix)) {
            return StringUtils.substringBeforeLast((String)name, (String)OpenEdiNames.PREFIX_SUFFIX_STRSEP);
        }
        return name;
    }

    public static String fixUpName(String name) {
        for (String ubw : unbreakableWords) {
            if (!name.contains(ubw)) continue;
            String wholeUbw = StringUtils.remove((String)ubw, (char)'_');
            name = name.replace(ubw, wholeUbw);
        }
        name = OpenEdiUtils.prepositionsToWords(name);
        name = StringUtils.replace((String)name, (String)"__", (String)"_");
        return name;
    }

    public static String prepositionsToWords(String name) {
        String[] words = StringUtils.split((String)name, (char)'_');
        ArrayList<String> newWords = new ArrayList<String>();
        int preposCount = 0;
        for (String w : words) {
            String prepos = null;
            if (!preposExclusions.contains(w) && (prepos = OpenEdiUtils.findPreposForWord(w)) != null) {
                String newW = StringUtils.substringBeforeLast((String)w, (String)prepos);
                newWords.add(newW);
                newWords.add(prepos);
                ++preposCount;
            }
            if (prepos != null) continue;
            newWords.add(w);
        }
        String newName = name;
        if (preposCount > 0) {
            newName = StringUtils.joinWith((String)"_", (Object[])newWords.toArray());
        }
        return newName;
    }

    private static String findPreposForWord(String w) {
        for (String prepos : prepositions) {
            if (!StringUtils.endsWith((CharSequence)w, (CharSequence)prepos) || w.length() - prepos.length() <= 2) continue;
            return prepos;
        }
        return null;
    }

    private static String camelCaseToUnderscore(String camelCaseStr) {
        StringBuilder underscore = new StringBuilder(String.valueOf(Character.toLowerCase(camelCaseStr.charAt(0))));
        for (int i = 1; i < camelCaseStr.length(); ++i) {
            char camelCaseChar = camelCaseStr.charAt(i);
            if (Character.isUpperCase(camelCaseChar)) {
                underscore.append('_');
            }
            underscore.append(Character.toLowerCase(camelCaseChar));
        }
        return underscore.toString();
    }

    public static String getSchemaNameFromRef(String ref) {
        String schemaName = StringUtils.substringAfterLast((String)ref, (int)47);
        if (StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = ref;
        }
        return schemaName;
    }

    public static List<LoopSegRef> getRefsFromNode(SchemaComponent parent, JsonNode parentNode, TransactionSchema schema) {
        ArrayList<LoopSegRef> refs = new ArrayList<LoopSegRef>();
        JsonNode props = parentNode.get("properties");
        if (props == null) {
            return refs;
        }
        int i = 0;
        Iterator elementNodes = props.fields();
        while (elementNodes.hasNext()) {
            Map.Entry elementNameAndNode = (Map.Entry)elementNodes.next();
            String name = (String)elementNameAndNode.getKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)"Model", (CharSequence)name)) continue;
            JsonNode loopSegRefNode = (JsonNode)elementNameAndNode.getValue();
            LoopSegRef loopSegRef = LoopSegRef.fromJsonNode(name, loopSegRefNode);
            loopSegRef.parent(parent);
            SchemaComponent schemaComp = schema.findSchemaComponentByRef(loopSegRef.refPath());
            if (schemaComp != null) {
                loopSegRef.child(schemaComp);
                refs.add(loopSegRef);
            } else {
                log.warn("Didn't find schema component for parent {}: {}", (Object)parent.schemaName, (Object)loopSegRef.refPath());
            }
            ++i;
        }
        log.debug("Iterated over {} nodes for the container {}", (Object)i, (Object)parent.schemaName());
        return refs;
    }

    public static String fixUpSegmentName(String segId, String name) {
        name = OpenEdiUtils.nodeNameToEdiNameAfterPrefix(name);
        name = OpenEdiUtils.cutNumericalSuffix(name);
        name = OpenEdiUtils.fixUpName(name);
        if ("ST".equals(segId) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"ST")) {
            name = "transaction_set_header";
        } else if ("SE".equals(segId) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"SE")) {
            name = "transaction_set_trailer";
        }
        return name;
    }
}

