/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import hdi.GeneralException;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.openedi.CompositeElementSchema;
import hdi.edi.openedi.EnumSchema;
import hdi.edi.openedi.GroupSchema;
import hdi.edi.openedi.LoopSchema;
import hdi.edi.openedi.LoopSegRef;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.SchemaComponentFactory;
import hdi.edi.openedi.SegSchema;
import hdi.edi.openedi.TransactionSchema;
import hdi.edi.parser.EdiParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenEdiSchemaReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenEdiSchemaReader.class);
    public static final ObjectMapper OPEN_EDI_SCHEMA_OM = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, true).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new JavaTimeModule());
    private final List<SchemaComponentFactory> componentFactories = List.of(SegSchema::create, LoopSchema::fromJsonNode, EnumSchema::fromJsonNode, GroupSchema::fromJsonNode, CompositeElementSchema::create);

    public TransactionSchema readSchemaFromResource(String transactionId) {
        return this.readSchemaFromResource(transactionId, null);
    }

    public static String extractVersion(String standardAndVersion) {
        int xPos = standardAndVersion.indexOf(88);
        String version = null;
        if (xPos > -1) {
            version = standardAndVersion.substring(xPos);
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransactionSchema readSchemaFromResource(String transactionId, String standardAndVersion) {
        String version;
        Object fileName = StringUtils.toRootLowerCase((String)transactionId);
        if (standardAndVersion != null && (version = OpenEdiSchemaReader.extractVersion(standardAndVersion)) != null) {
            fileName = (String)fileName + version;
        }
        fileName = (String)fileName + ".json";
        String resourcePath = "schemas/" + (String)fileName;
        try (InputStream is = TransactionSchema.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (is == null) {
                log.debug("Didn't find the schema '{}'", (Object)resourcePath);
                TransactionSchema transactionSchema2 = null;
                return transactionSchema2;
            }
            TransactionSchema transactionSchema = this.loadSchema(new FileInfo((String)fileName, is));
            return transactionSchema;
        }
    }

    public TransactionSchema loadSchema(FileInfo schemaFileInfo) {
        log.debug("Loading OpenEDI schema file {}", (Object)schemaFileInfo.name());
        TransactionSchema tranSchema = new TransactionSchema();
        tranSchema.fileName(schemaFileInfo.name());
        try (BufferedReader reader = schemaFileInfo.getContent();){
            JsonNode specTree = OPEN_EDI_SCHEMA_OM.readTree((Reader)reader);
            JsonNode components = specTree.get("components");
            if (components == null) {
                throw new EdiParserException("Didn't find 'components' in json in the open EDI file %s", schemaFileInfo.name());
            }
            JsonNode schemas = components.get("schemas");
            if (schemas == null) {
                throw new EdiParserException("Didn't find 'schemas' under 'components' in json in the file %s", schemaFileInfo.name());
            }
            int i = 0;
            Iterator schemaComponents = schemas.fields();
            while (schemaComponents.hasNext()) {
                SchemaComponentFactory factory;
                Map.Entry schemaComp = (Map.Entry)schemaComponents.next();
                String name = (String)schemaComp.getKey();
                JsonNode jsonNode = (JsonNode)schemaComp.getValue();
                SchemaComponent schemaComponent = null;
                Iterator<SchemaComponentFactory> iterator = this.componentFactories.iterator();
                while (iterator.hasNext() && (schemaComponent = (factory = iterator.next()).create(name, jsonNode, tranSchema)) == null) {
                }
                if (schemaComponent != null) {
                    tranSchema.addSchemaComponent(schemaComponent);
                    if (schemaComponent instanceof LoopSchema) {
                        LoopSchema loop = (LoopSchema)schemaComponent;
                        tranSchema.addLoop(loop);
                    } else if (schemaComponent instanceof SegSchema) {
                        SegSchema seg = (SegSchema)schemaComponent;
                        tranSchema.addSeg(seg);
                    }
                } else {
                    log.warn("Unknown schema component {}", (Object)name);
                }
                ++i;
            }
            this.populateLegacyParentId(tranSchema);
            log.debug("Loaded {} schema components from {}", (Object)i, (Object)schemaFileInfo.name());
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
        return tranSchema;
    }

    private void populateLegacyParentId(TransactionSchema tranSchema) {
        List<LoopSchema> loops = tranSchema.loops();
        for (LoopSchema loop : loops) {
            int segI = 0;
            String parentKey = null;
            String parentLoopId = null;
            for (LoopSegRef segRef : loop.segRefs()) {
                if (segI == 0) {
                    LoopSegRef parentFirstSeg;
                    segRef.isLoopFirst(true);
                    parentKey = segRef.legacyKey();
                    parentLoopId = segRef.parent().id();
                    if (segRef.loop().parentLoop() != null && (parentFirstSeg = segRef.loop().parentLoop().firstSeg()) != null) {
                        segRef.legacyParentKey(parentFirstSeg.legacyKey());
                        segRef.parentSegmentLoopId(parentFirstSeg.loop().id());
                    }
                } else {
                    segRef.legacyParentKey(parentKey);
                    segRef.parentSegmentLoopId(parentLoopId);
                }
                ++segI;
            }
        }
    }
}

