/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import hdi.edi.openedi.OpenEdiSchemaReader;
import hdi.edi.openedi.TransactionSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenEdiSchemaHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenEdiSchemaHolder.class);
    private final Map<String, TransactionSchema> transactionSchemasByTranId = new ConcurrentHashMap<String, TransactionSchema>();
    private final Map<String, TransactionSchema> transactionSchemasByTranIdAndVersion = new ConcurrentHashMap<String, TransactionSchema>();
    private final OpenEdiSchemaReader openEdiSchemaReader = new OpenEdiSchemaReader();

    public void addTransactionSchema(TransactionSchema transactionSchema) {
    }

    public TransactionSchema getSchema(String transactionId) {
        return this.getSchema(transactionId, null);
    }

    public TransactionSchema getSchema(String transactionId, String version) {
        TransactionSchema transactionSchema = null;
        if (StringUtils.isNotBlank((CharSequence)version)) {
            transactionSchema = this.transactionSchemasByTranIdAndVersion.get(transactionId + version);
        }
        if (transactionSchema == null) {
            transactionSchema = this.transactionSchemasByTranId.get(transactionId);
        }
        if (transactionSchema == null) {
            transactionSchema = this.openEdiSchemaReader.readSchemaFromResource(transactionId, version);
            if (transactionSchema == null) {
                transactionSchema = this.openEdiSchemaReader.readSchemaFromResource(transactionId);
            }
            if (transactionSchema != null) {
                this.transactionSchemasByTranId.put(transactionId, transactionSchema);
                if (StringUtils.isNotBlank((CharSequence)version)) {
                    this.transactionSchemasByTranIdAndVersion.put(transactionId + version, transactionSchema);
                }
            }
        }
        if (transactionSchema == null) {
            log.debug("Did not find OpenEDI schema for transactionId: {} Version: {} ", (Object)transactionId, (Object)version);
        }
        return transactionSchema;
    }
}

