/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.legacyparser.SegmentDictionary;
import hdi.edi.openedi.LoopSchema;
import hdi.edi.openedi.OpenEdiNames;
import hdi.edi.openedi.OpenEdiUtils;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.SegSchema;
import hdi.edi.parser.EdiParserException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopSegRef
extends SchemaComponent
implements OpenEdiNames {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoopSegRef.class);
    private SchemaComponent parent;
    private SchemaComponent child;
    private String refPath;
    private boolean isArray;
    private String legacyParentKey;
    private String parentSegmentLoopId;
    private boolean isLoopFirst;

    public LoopSegRef(LoopSegRef otherRef) {
        super(otherRef);
        this.parent = otherRef.parent;
        this.child = otherRef.child;
        this.refPath = otherRef.refPath;
        this.isArray = otherRef.isArray;
        this.legacyParentKey = otherRef.legacyParentKey;
        this.parentSegmentLoopId = otherRef.parentSegmentLoopId;
        this.isLoopFirst = otherRef.isLoopFirst;
    }

    public SegSchema seg() {
        return (SegSchema)this.child;
    }

    public LoopSchema loop() {
        if (this.parent != null) {
            return (LoopSchema)this.parent;
        }
        return null;
    }

    public static LoopSegRef fromJsonNode(String name, JsonNode jsonNode) {
        LoopSegRef loopSegRef = new LoopSegRef();
        loopSegRef.schemaName = name;
        loopSegRef.name = OpenEdiUtils.fixUpSegmentName(null, name);
        JsonNode refNode = jsonNode.get("$ref");
        if (refNode == null) {
            JsonNode type;
            JsonNode itemsNode = jsonNode.get("items");
            if (itemsNode != null) {
                refNode = itemsNode.get("$ref");
                loopSegRef.isArray = true;
            }
            if ((type = jsonNode.get("type")) == null || !StringUtils.equalsIgnoreCase((CharSequence)type.asText(), (CharSequence)"array")) {
                log.warn("Fount items without array type: {}", (Object)loopSegRef);
            }
        }
        if (refNode == null) {
            throw new EdiParserException("Didn't find reference field %s inside the node '%s'", "$ref", name);
        }
        loopSegRef.refPath = refNode.asText();
        return loopSegRef;
    }

    public SegmentDictionary toLegacySegmentDictionary() {
        String tag = this.seg().id();
        String loop = this.parent().id();
        SegmentDictionary segDict = new SegmentDictionary(tag, null, loop, this.name);
        List<ElementWithChildrenDictionary> eltDicts = this.seg().eltsToLegacyElementDictionaries();
        segDict.setElements(eltDicts);
        segDict.setParent(this.legacyParentKey);
        return segDict;
    }

    public String legacyKey() {
        String code = "";
        if (!this.seg().codes().isEmpty()) {
            code = this.seg().codes().iterator().next();
        }
        return this.seg().id() + "_" + code + "_" + this.parent.id();
    }

    @Generated
    public SchemaComponent parent() {
        return this.parent;
    }

    @Generated
    public SchemaComponent child() {
        return this.child;
    }

    @Generated
    public String refPath() {
        return this.refPath;
    }

    @Generated
    public boolean isArray() {
        return this.isArray;
    }

    @Generated
    public String legacyParentKey() {
        return this.legacyParentKey;
    }

    @Generated
    public String parentSegmentLoopId() {
        return this.parentSegmentLoopId;
    }

    @Generated
    public boolean isLoopFirst() {
        return this.isLoopFirst;
    }

    @Override
    @Generated
    public String toString() {
        return "LoopSegRef(super=" + super.toString() + ", child=" + String.valueOf(this.child()) + ", refPath=" + this.refPath() + ", isArray=" + this.isArray() + ", legacyParentKey=" + this.legacyParentKey() + ", parentSegmentLoopId=" + this.parentSegmentLoopId() + ", isLoopFirst=" + this.isLoopFirst() + ")";
    }

    @Generated
    public LoopSegRef() {
    }

    @Generated
    public LoopSegRef parent(SchemaComponent parent) {
        this.parent = parent;
        return this;
    }

    @Generated
    public LoopSegRef child(SchemaComponent child) {
        this.child = child;
        return this;
    }

    @Generated
    public LoopSegRef legacyParentKey(String legacyParentKey) {
        this.legacyParentKey = legacyParentKey;
        return this;
    }

    @Generated
    public LoopSegRef parentSegmentLoopId(String parentSegmentLoopId) {
        this.parentSegmentLoopId = parentSegmentLoopId;
        return this;
    }

    @Generated
    public LoopSegRef isLoopFirst(boolean isLoopFirst) {
        this.isLoopFirst = isLoopFirst;
        return this;
    }
}

