/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.openedi.GroupSchema;
import hdi.edi.openedi.InputStandardType;
import hdi.edi.openedi.LoopSegRef;
import hdi.edi.openedi.OpenEdiNames;
import hdi.edi.openedi.OpenEdiUtils;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.SegSchema;
import hdi.edi.openedi.TransactionSchema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopSchema
extends SchemaComponent
implements OpenEdiNames {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoopSchema.class);
    public static final String LOOP_ID = "x-openedi-loop-id";
    public static final String TRAN_LOOP_ID = "x-openedi-message-id";
    public static final String VERSION_FIELD_NAME = "x-openedi-message-version";
    public static final String STANDARD_FIELD_NAME = "x-openedi-message-standard";
    private String messageVersion;
    private String transactionId;
    private InputStandardType standardType;
    private final List<LoopSchema> childLoops = new ArrayList<LoopSchema>();
    private final List<LoopSegRef> segRefs = new ArrayList<LoopSegRef>();
    private final Map<String, List<LoopSegRef>> segRefsBySegId = new LinkedHashMap<String, List<LoopSegRef>>();
    private LoopSchema parentLoop;
    private boolean isArray;
    private final List<LoopSegRef> loopRefs = new ArrayList<LoopSegRef>();

    public LoopSegRef findSeg(String segId, String segCode, Set<String> visitedLoopIds) {
        if (visitedLoopIds.contains(this.id())) {
            return null;
        }
        LoopSegRef segRef = this.findSegInLoop(this, segId, segCode);
        visitedLoopIds.add(this.id());
        if (segRef != null) {
            return segRef;
        }
        for (LoopSchema childLoop : this.childLoops) {
            if (visitedLoopIds.contains(childLoop.id()) || (segRef = childLoop.findSeg(segId, segCode, visitedLoopIds)) == null) continue;
            return segRef;
        }
        if (this.parentLoop != null && !visitedLoopIds.contains(this.parentLoop.id())) {
            segRef = this.parentLoop.findSeg(segId, segCode, visitedLoopIds);
        }
        return segRef;
    }

    private LoopSegRef findSegInLoop(LoopSchema loop, String segId, String segCode) {
        List<LoopSegRef> segs = loop.segRefsBySegId.get(segId);
        if (segs == null || segs.isEmpty()) {
            return null;
        }
        LoopSegRef firstSegRef = segs.get(0);
        Set<String> codes = firstSegRef.seg().codes();
        if (codes.isEmpty()) {
            if (segs.size() > 1) {
                log.warn("Found multiple segments {} in loop {}. Expected one.", (Object)segId, (Object)this.name);
            }
            return firstSegRef;
        }
        if (StringUtils.isBlank((CharSequence)segCode)) {
            log.warn("The code to locate segment {} in loop {} was not provided. Returning the first occurred segment of this type.", (Object)segId, (Object)this.name);
            return firstSegRef;
        }
        for (LoopSegRef segRef : segs) {
            if (!segRef.seg().codes().contains(segCode)) continue;
            return segRef;
        }
        return null;
    }

    public static LoopSchema fromJsonNode(String name, JsonNode jsonNode, TransactionSchema schema) {
        if (!LoopSchema.isLoop(jsonNode)) {
            return null;
        }
        LoopSchema loopSchema = new LoopSchema();
        JsonNode loopIdNode = jsonNode.get(LOOP_ID);
        if (loopIdNode != null) {
            loopSchema.id = loopIdNode.textValue();
        } else {
            JsonNode tranIdNode = jsonNode.path(TRAN_LOOP_ID);
            loopSchema.messageVersion = jsonNode.path(VERSION_FIELD_NAME).textValue();
            loopSchema.transactionId = tranIdNode.textValue();
            loopSchema.id = "0000";
            String standardId = jsonNode.path(STANDARD_FIELD_NAME).textValue();
            loopSchema.standardType = InputStandardType.fromOpenEdiId(standardId);
        }
        loopSchema.id = LoopSchema.makeLoopIdUnique(loopSchema.id, schema);
        loopSchema.name = OpenEdiUtils.nodeNameToEdiNameAfterPrefix(name);
        loopSchema.schemaName = name;
        loopSchema.populateRefs(jsonNode, schema);
        return loopSchema;
    }

    private static String makeLoopIdUnique(String loopId, TransactionSchema schema) {
        Map<String, Integer> loopCounts = schema.loopCountByLoopId();
        Integer count = loopCounts.get(loopId);
        if (count == null) {
            loopCounts.put((String)loopId, 1);
        } else {
            count = count + 1;
            loopCounts.put((String)loopId, count);
            log.debug("Loop ID {} is defined multiple times. Adding suffix {} to make the id unique", loopId, (Object)count);
            loopId = (String)loopId + "-" + count;
        }
        return loopId;
    }

    private void populateRefs(JsonNode loopNode, TransactionSchema schema) {
        List<LoopSegRef> refs = OpenEdiUtils.getRefsFromNode(this, loopNode, schema);
        this.processRefs(refs);
    }

    private void processRefs(List<LoopSegRef> refs) {
        for (LoopSegRef ref : refs) {
            SchemaComponent child = ref.child();
            if (child instanceof LoopSchema) {
                LoopSchema loop = (LoopSchema)child;
                LoopSegRef clonedRef = new LoopSegRef(ref);
                clonedRef.parent(this);
                this.loopRefs.add(clonedRef);
                loop.parentLoop = this;
                loop.isArray = ref.isArray();
                this.childLoops.add(loop);
                continue;
            }
            if (child instanceof SegSchema) {
                SegSchema seg = (SegSchema)child;
                List segs = this.segRefsBySegId.computeIfAbsent(seg.id(), k -> new ArrayList());
                LoopSegRef clonedRef = new LoopSegRef(ref);
                clonedRef.parent(this);
                segs.add(clonedRef);
                this.segRefs.add(clonedRef);
                continue;
            }
            if (child instanceof GroupSchema) {
                GroupSchema segGroup = (GroupSchema)child;
                this.processRefs(segGroup.refs());
                continue;
            }
            log.warn("Don't know how to handle schema component of type {}", (Object)child.getClass().getName());
        }
    }

    private static boolean isLoop(JsonNode jsonNode) {
        return jsonNode.has(LOOP_ID) || jsonNode.has(TRAN_LOOP_ID);
    }

    public LoopSegRef firstSeg() {
        if (this.segRefs.isEmpty()) {
            return null;
        }
        return this.segRefs.get(0);
    }

    @Generated
    public String messageVersion() {
        return this.messageVersion;
    }

    @Generated
    public String transactionId() {
        return this.transactionId;
    }

    @Generated
    public InputStandardType standardType() {
        return this.standardType;
    }

    @Generated
    public List<LoopSchema> childLoops() {
        return this.childLoops;
    }

    @Generated
    public List<LoopSegRef> segRefs() {
        return this.segRefs;
    }

    @Generated
    public Map<String, List<LoopSegRef>> segRefsBySegId() {
        return this.segRefsBySegId;
    }

    @Generated
    public LoopSchema parentLoop() {
        return this.parentLoop;
    }

    @Generated
    public boolean isArray() {
        return this.isArray;
    }

    @Generated
    public List<LoopSegRef> loopRefs() {
        return this.loopRefs;
    }

    @Override
    @Generated
    public String toString() {
        return "LoopSchema(super=" + super.toString() + ", messageVersion=" + this.messageVersion() + ", transactionId=" + this.transactionId() + ", standardType=" + String.valueOf((Object)this.standardType()) + ", childLoops=" + String.valueOf(this.childLoops()) + ", segRefs=" + String.valueOf(this.segRefs()) + ", isArray=" + this.isArray() + ")";
    }
}

