/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.openedi.LoopSegRef;
import hdi.edi.openedi.OpenEdiUtils;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.TransactionSchema;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupSchema
extends SchemaComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupSchema.class);
    public static final String GROUP_TYPE_NAME = "x-openedi-group-type";
    private List<LoopSegRef> refs;
    private String groupType;

    public static GroupSchema fromJsonNode(String name, JsonNode jsonNode, TransactionSchema schema) {
        if (!GroupSchema.isGroup(jsonNode)) {
            return null;
        }
        GroupSchema segGroupSchema = new GroupSchema();
        segGroupSchema.name = name;
        segGroupSchema.schemaName = name;
        segGroupSchema.groupType = jsonNode.path(GROUP_TYPE_NAME).asText();
        segGroupSchema.populateRefs(jsonNode, schema);
        return segGroupSchema;
    }

    private void populateRefs(JsonNode loopNode, TransactionSchema schema) {
        this.refs = OpenEdiUtils.getRefsFromNode(this, loopNode, schema);
    }

    private static boolean isGroup(JsonNode jsonNode) {
        return jsonNode.has(GROUP_TYPE_NAME);
    }

    @Generated
    public List<LoopSegRef> refs() {
        return this.refs;
    }

    @Generated
    public String groupType() {
        return this.groupType;
    }

    @Override
    @Generated
    public String toString() {
        return "GroupSchema(super=" + super.toString() + ", refs=" + String.valueOf(this.refs()) + ", groupType=" + this.groupType() + ")";
    }
}

