/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.objmapper;

import hdi.edi.objmapper.EdiMapperException;
import hdi.edi.parser.SegmentType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.Generated;

public class MappingDescriptor {
    private final String eltName;
    private final Class<?> entityClass;
    private SegmentType segType;
    private AccessibleObject accessibleObject;
    private boolean isSetterNotFound;

    public Method setter() {
        AccessibleObject accessibleObject = this.accessibleObject;
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            return method;
        }
        return null;
    }

    public Field field() {
        AccessibleObject accessibleObject = this.accessibleObject;
        if (accessibleObject instanceof Field) {
            Field field = (Field)accessibleObject;
            return field;
        }
        return null;
    }

    public Class<?> accessibleObjectType() {
        Field fld = this.field();
        if (fld != null) {
            return fld.getType();
        }
        Method setter = this.setter();
        if (setter != null) {
            Class<?>[] paramTypes = setter.getParameterTypes();
            if (paramTypes.length < 1) {
                throw new EdiMapperException("Method %s is not setter", this.setter());
            }
            return setter.getParameterTypes()[0];
        }
        return null;
    }

    public String accessibleObjectName() {
        AccessibleObject accessibleObject = this.accessibleObject;
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            return method.getName();
        }
        accessibleObject = this.accessibleObject;
        if (accessibleObject instanceof Field) {
            Field field = (Field)accessibleObject;
            return field.getName();
        }
        return null;
    }

    public String className() {
        return this.entityClass.getName();
    }

    public boolean canBePopulated() {
        return this.accessibleObject != null;
    }

    public String toSummaryString() {
        return "element '" + this.eltName + "' mapped to field: '" + this.accessibleObjectName() + "' of '" + this.className() + "'. Segment type: " + String.valueOf((Object)this.segType);
    }

    @Generated
    public String eltName() {
        return this.eltName;
    }

    @Generated
    public Class<?> entityClass() {
        return this.entityClass;
    }

    @Generated
    public SegmentType segType() {
        return this.segType;
    }

    @Generated
    public AccessibleObject accessibleObject() {
        return this.accessibleObject;
    }

    @Generated
    public boolean isSetterNotFound() {
        return this.isSetterNotFound;
    }

    @Generated
    public MappingDescriptor(String eltName, Class<?> entityClass) {
        this.eltName = eltName;
        this.entityClass = entityClass;
    }

    @Generated
    public String toString() {
        return "MappingDescriptor(eltName=" + this.eltName() + ", segType=" + String.valueOf((Object)this.segType()) + ", isSetterNotFound=" + this.isSetterNotFound() + ")";
    }

    @Generated
    public MappingDescriptor segType(SegmentType segType) {
        this.segType = segType;
        return this;
    }

    @Generated
    public MappingDescriptor accessibleObject(AccessibleObject accessibleObject) {
        this.accessibleObject = accessibleObject;
        return this;
    }

    @Generated
    public MappingDescriptor isSetterNotFound(boolean isSetterNotFound) {
        this.isSetterNotFound = isSetterNotFound;
        return this;
    }
}

