/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.objmapper;

import hdi.edi.objmapper.EdiMapperException;
import hdi.edi.objmapper.MappingDescriptor;
import hdi.edi.objmapper.ParentHolder;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.objmapper.annotations.EdiEntity;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.EdiQualifierEnt;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.AnnotationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.text.CaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiObjectMapper<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiObjectMapper.class);
    private Map<String, MappingDescriptor> eltMappings = new ConcurrentHashMap<String, MappingDescriptor>();
    public static DateTimeFormatter EDI_HHMM_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    public static DateTimeFormatter EDI_HHMM_TIME_FORMAT = DateTimeFormatter.ofPattern("HHmm");
    public static DateTimeFormatter EDI_HHMMSS_TIME_FORMAT = DateTimeFormatter.ofPattern("HHmmss");

    public void populateFromLoop(T obj, EdiSeg seg) {
        this.populate(obj, seg);
        if (seg.childSegs() != null && !seg.childSegs().isEmpty()) {
            for (EdiSeg childSeg : seg.childSegs()) {
                this.populate(obj, childSeg);
            }
        }
    }

    public void populate(T obj, EdiSeg seg) {
        if (seg == null) {
            return;
        }
        this.populateObject(obj, seg.eltSet());
    }

    public void populateObject(Object obj, EltSet eltSet) {
        this.populateObject(obj, eltSet.parentSeg(), eltSet.elts());
    }

    private String getEltKey(Class<?> clazz, EdiSeg seg, Elt elt) {
        return StringUtils.joinWith((String)"-", (Object[])new Object[]{clazz.getName(), seg.loop(), seg.typeAsString(), seg.name(), elt.name(), elt.position()});
    }

    public void populateObject(Object obj, EdiSeg parentSeg, List<Elt> elts) {
        for (Elt elt : elts) {
            String eltName = elt.name();
            if (elt.isSimple()) {
                String eltKey = this.getEltKey(obj.getClass(), parentSeg, elt);
                MappingDescriptor mapDesc = this.eltMappings.get(eltKey);
                if (mapDesc == null) {
                    AccessibleObject ao;
                    log.debug("No cached access object for {}, creating new one", (Object)eltKey);
                    mapDesc = new MappingDescriptor(eltName, obj.getClass());
                    if (parentSeg != null) {
                        mapDesc.segType(parentSeg.type());
                    }
                    if ((ao = this.findAccessibleObjectForElt(obj.getClass(), eltName, elt.position(), parentSeg)) != null) {
                        log.debug("Found {} for {}", (Object)ao, (Object)eltName);
                        mapDesc.accessibleObject(ao);
                    }
                    this.eltMappings.put(eltKey, mapDesc);
                }
                if (mapDesc.canBePopulated()) {
                    this.populateSimpleField(mapDesc, obj, elt);
                    continue;
                }
                String msg = "Wasn't able to find mapping for {} on {}";
                String nm = obj.getClass().getName();
                log.debug(msg, (Object)elt, (Object)nm);
                continue;
            }
            if (elt.dataType() == DataType.ELT_SET) {
                this.populateNested(parentSeg, obj, elt, List.of(elt.eltSet()));
                continue;
            }
            throw new EdiMapperException("Don't know how to map type " + String.valueOf((Object)elt.dataType()), new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean populateNested(EdiSeg seg, Object parentObj, Elt parentElt, List<EltSet> eltSets) {
        Class<?> entClazz;
        if (eltSets.isEmpty()) {
            log.error("Empty elt set for {}", (Object)parentElt.name());
            return false;
        }
        String eltKey = this.getEltKey(parentObj.getClass(), seg, parentElt);
        String parentEltName = parentElt.name();
        MappingDescriptor mapDesc = this.eltMappings.get(eltKey);
        if (mapDesc == null) {
            AccessibleObject ao = this.findAccessibleObjectForElt(parentObj.getClass(), parentEltName, parentElt.position(), seg);
            if (ao == null) {
                log.debug("Unable to find property on {} to match '{}' element, segment {} (should be mapped to a child entity)", new Object[]{parentObj.getClass().getName(), parentEltName, seg.type()});
                this.eltMappings.put(eltKey, new MappingDescriptor(parentEltName, parentObj.getClass()));
                return false;
            }
            if (!(ao instanceof Field)) throw new EdiMapperException("Accessible object mapped to parent element %s must be of type Field", parentEltName);
            Field field = (Field)ao;
            Field f = field;
            entClazz = f.getType();
            EdiEntity entAnn = f.getAnnotation(EdiEntity.class);
            if (entAnn != null) {
                entClazz = entAnn.value();
            }
            mapDesc = new MappingDescriptor(parentEltName, entClazz).accessibleObject(f);
            this.eltMappings.put(eltKey, mapDesc);
        } else if (!mapDesc.canBePopulated()) {
            return false;
        }
        entClazz = mapDesc.entityClass();
        if (Collection.class.isAssignableFrom(mapDesc.accessibleObjectType())) {
            if (entClazz.equals(mapDesc.accessibleObjectType())) {
                throw new EdiMapperException("Field %s must have EdiEntity annotation so we can map nested entities", mapDesc.accessibleObjectName());
            }
            ArrayList<Object> nestedObjs = new ArrayList<Object>();
            for (EltSet eltSet : eltSets) {
                Object o = this.createObject(entClazz);
                this.populateObject(o, eltSet);
                nestedObjs.add(o);
            }
            this.populateFieldWithValue(mapDesc, parentObj, nestedObjs);
            return true;
        }
        if (eltSets.size() > 1) {
            log.warn("Attempt to map an array to a single entity {} for {}", (Object)entClazz.getName(), (Object)parentEltName);
        }
        EltSet es = eltSets.get(0);
        Object o = this.createObject(entClazz);
        this.populateObject(o, es);
        this.populateFieldWithValue(mapDesc, parentObj, o);
        return true;
    }

    private void populateSimpleField(MappingDescriptor mappingDescriptor, Object entity, Elt elt) {
        Object valToSet = elt.val();
        Class<Object> fType = mappingDescriptor.accessibleObjectType();
        try {
            if (fType.isAssignableFrom(String.class)) {
                if (valToSet instanceof EdiQualifier) {
                    EdiQualifier ediQualifier = (EdiQualifier)valToSet;
                    valToSet = ediQualifier.ediValue();
                } else if (valToSet == null) {
                    log.warn("Elt {} val is null", (Object)elt.toNameAndIndexString());
                } else {
                    valToSet = valToSet.toString();
                }
            } else if (fType.isAssignableFrom(Elt.class)) {
                valToSet = elt;
            } else if (elt.isFailedConversion()) {
                valToSet = null;
            } else if (fType.isAssignableFrom(LocalDate.class)) {
                valToSet = this.localDateFromVal(valToSet, mappingDescriptor);
            } else if (fType.isAssignableFrom(LocalDateTime.class)) {
                valToSet = this.localDateTimeFromVal(valToSet, mappingDescriptor);
            } else if (fType.isAssignableFrom(LocalTime.class)) {
                valToSet = this.timeFromVal(valToSet, mappingDescriptor);
            } else if (fType.isAssignableFrom(Date.class)) {
                valToSet = this.dateFromVal(valToSet, mappingDescriptor);
            } else if (fType.isAssignableFrom(BigDecimal.class)) {
                valToSet = this.bigDecFromVal(valToSet);
            } else if (fType.isAssignableFrom(Integer.class)) {
                valToSet = this.intFromVal(valToSet);
            }
            if (EdiQualifier.class.isAssignableFrom(fType) && (!(valToSet instanceof EdiQualifier) || valToSet instanceof EdiQualifierEnt)) {
                log.warn("Unable to decode value '{}' for {}", valToSet, (Object)mappingDescriptor.toSummaryString());
                valToSet = null;
            }
            this.populateFieldWithValue(mappingDescriptor, entity, valToSet);
        }
        catch (IllegalArgumentException | DateTimeParseException pe) {
            log.warn("Error converting '{}' from {} into field '{}.{}': {} ", new Object[]{valToSet, mappingDescriptor.eltName(), mappingDescriptor.className(), mappingDescriptor.accessibleObjectName(), pe.getMessage()});
        }
    }

    private void populateFieldWithValue(MappingDescriptor mappingDescriptor, Object entity, Object val) {
        AccessibleObject accessibleObject = mappingDescriptor.accessibleObject();
        if (accessibleObject instanceof Field) {
            Field field = (Field)accessibleObject;
            if (val != null && !mappingDescriptor.isSetterNotFound()) {
                log.debug("No setter in cache for {}", (Object)field.getName());
                Method setter = MethodUtils.getMatchingMethod(entity.getClass(), (String)field.getName(), (Class[])new Class[]{val.getClass()});
                if (setter != null) {
                    mappingDescriptor.accessibleObject(setter);
                    accessibleObject = setter;
                } else {
                    log.debug("No setter found for {} in {}", (Object)field.getName(), (Object)mappingDescriptor.toSummaryString());
                    mappingDescriptor.isSetterNotFound(true);
                }
            }
        }
        if (accessibleObject instanceof Method) {
            Method setter = (Method)accessibleObject;
            log.debug("Populating {} with {}", (Object)setter.getName(), val);
            setter.invoke(entity, val);
        } else if (accessibleObject instanceof Field) {
            Field field = (Field)accessibleObject;
            if (Collection.class.isAssignableFrom(field.getType())) {
                this.populateCollectionField(mappingDescriptor, entity, val);
            } else {
                FieldUtils.writeField((Field)field, (Object)entity, (Object)val, (boolean)true);
            }
        } else {
            log.warn("The accessible object for {} is not field or method. Val: {}", (Object)mappingDescriptor.eltName(), val);
        }
        if (val instanceof ParentHolder) {
            ((ParentHolder)val).setParent(entity);
        }
    }

    private void populateCollectionField(MappingDescriptor mappingDescriptor, Object entity, Object val) {
        Object currentFieldVal = FieldUtils.readField((Field)mappingDescriptor.field(), (Object)entity, (boolean)true);
        if (currentFieldVal instanceof Collection) {
            Collection currentColl = (Collection)currentFieldVal;
            if (val instanceof Collection) {
                currentColl.addAll((Collection)val);
            } else {
                currentColl.add(val);
            }
        } else {
            FieldUtils.writeField((Field)mappingDescriptor.field(), (Object)entity, (Object)val, (boolean)true);
        }
    }

    private LocalDate localDateFromVal(Object val, MappingDescriptor mappingDesc) {
        LocalDate dt = null;
        if (val instanceof LocalDate) {
            LocalDate localDate;
            dt = localDate = (LocalDate)val;
        } else if (val instanceof String) {
            String s = (String)val;
            s = StringUtils.strip((String)s);
            try {
                dt = LocalDate.parse(s, DateTimeFormatter.BASIC_ISO_DATE);
            }
            catch (DateTimeParseException parseException) {
                log.warn("Error parsing string '{}' as date for field '{}.{}', setting it to null: {} ", new Object[]{s, mappingDesc.className(), mappingDesc.accessibleObjectName(), parseException.getMessage()});
            }
        }
        return dt;
    }

    private LocalDateTime localDateTimeFromVal(Object obj, MappingDescriptor mappingDesc) {
        LocalDateTime dt;
        block6: {
            dt = null;
            if (obj instanceof LocalDateTime) {
                dt = (LocalDateTime)obj;
            }
            if (obj instanceof LocalDate) {
                LocalDate localDate = (LocalDate)obj;
                dt = localDate.atStartOfDay();
            } else if (obj instanceof String) {
                try {
                    dt = LocalDateTime.parse((String)obj, EDI_HHMM_DATE_TIME_FORMAT);
                }
                catch (DateTimeParseException parseException) {
                    LocalDate d = this.localDateFromVal(obj, mappingDesc);
                    if (d == null) break block6;
                    dt = d.atStartOfDay();
                }
            }
        }
        return dt;
    }

    private LocalTime timeFromVal(Object obj, MappingDescriptor mappingDesc) {
        if (obj == null) {
            return null;
        }
        LocalTime dt = null;
        if (obj instanceof LocalTime) {
            dt = (LocalTime)obj;
        } else if (obj instanceof String) {
            String timeS = StringUtils.strip((String)((String)obj));
            DateTimeFormatter formatter = timeS.length() >= EDI_HHMMSS_TIME_FORMAT.toString().length() ? EDI_HHMMSS_TIME_FORMAT : EDI_HHMM_TIME_FORMAT;
            try {
                dt = LocalTime.parse(timeS, formatter);
            }
            catch (DateTimeParseException parseException) {
                log.warn("Error parsing string '{}' as time for field '{}.{}', setting it to null: {} ", new Object[]{timeS, mappingDesc.className(), mappingDesc.accessibleObjectName(), parseException.getMessage()});
            }
        }
        return dt;
    }

    private Date dateFromVal(Object obj, MappingDescriptor mappingDesc) {
        LocalDate dt = this.localDateFromVal(obj, mappingDesc);
        return Date.from(dt.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private BigDecimal bigDecFromVal(Object val) {
        BigDecimal bigDecVal = !(val instanceof BigDecimal) ? new BigDecimal(val.toString()) : (BigDecimal)val;
        if (bigDecVal.scale() <= 2) {
            bigDecVal = bigDecVal.setScale(2, RoundingMode.HALF_EVEN);
        }
        return bigDecVal;
    }

    private Integer intFromVal(Object val) {
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof LocalTime) {
            LocalTime time = (LocalTime)val;
            return time.getHour();
        }
        BigDecimal bigDecVal = !(val instanceof BigDecimal) ? new BigDecimal(val.toString()) : (BigDecimal)val;
        bigDecVal = bigDecVal.setScale(0, RoundingMode.HALF_EVEN);
        return bigDecVal.intValue();
    }

    private Object createObject(Class<?> clazz) {
        Constructor constr = ConstructorUtils.getAccessibleConstructor(clazz, (Class[])new Class[0]);
        if (constr == null) {
            throw new EdiMapperException("Class %s does not have a no-arg constructor, unable to create", clazz.getName());
        }
        Object o = ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[0]);
        return o;
    }

    private AccessibleObject findAccessibleObjectForElt(Class<?> clazz, String name, int eltPos, EdiSeg seg) {
        AccessibleObject f = this.findByAnnotation(clazz, name, eltPos, seg);
        if (f == null) {
            name = CaseUtils.toCamelCase((String)name, (boolean)false, (char[])new char[]{'_'});
            f = this.findByAnnotation(clazz, name, eltPos, seg);
        }
        if (f == null) {
            f = this.findFieldByEnding(clazz, name);
        }
        return f;
    }

    private Field findFieldByEnding(Class<?> clazz, String name) {
        List<Field> fields = FieldUtils.getAllFieldsList(clazz);
        List<String> names = (fields = this.filterStaticAndExcludeAnnotated(fields)).stream().map(Field::getName).collect(Collectors.toList());
        int i = this.findMatchBySuffix(names, name);
        if (i >= 0) {
            return fields.get(i);
        }
        return null;
    }

    private List<Field> filterStaticAndExcludeAnnotated(List<Field> fields) {
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        for (Field f : fields) {
            EdiElt.Exclude excludeAnnotation;
            if (this.isStaticOrFinal(f) || (excludeAnnotation = f.getAnnotation(EdiElt.Exclude.class)) != null) continue;
            filteredFields.add(f);
        }
        return filteredFields;
    }

    private boolean isStaticOrFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers);
    }

    private AccessibleObject findByAnnotation(Class<?> clazz, String name, int pos, EdiSeg seg) {
        int i;
        List fields = FieldUtils.getFieldsListWithAnnotation(clazz, EdiElt.class);
        List methods = MethodUtils.getMethodsListWithAnnotation(clazz, EdiElt.class);
        ArrayList accessibleObjects = new ArrayList(fields);
        accessibleObjects.addAll(methods);
        ArrayList<String> annNames = new ArrayList<String>();
        ArrayList<AccessibleObject> candidateFields = new ArrayList<AccessibleObject>();
        for (AccessibleObject accessibleObject : accessibleObjects) {
            String[] annotationEltNames;
            String segType;
            EdiElt ediEltAnnotation = accessibleObject.getAnnotation(EdiElt.class);
            if (ediEltAnnotation == null || !StringUtils.isBlank((CharSequence)(segType = ediEltAnnotation.seg())) && (seg == null || !StringUtils.equalsIgnoreCase((CharSequence)segType, (CharSequence)seg.typeAsString()))) continue;
            if (StringUtils.isNotBlank((CharSequence)ediEltAnnotation.qualifier()) && ediEltAnnotation.pos() <= 0) {
                throw new IllegalStateException("Annotation " + AnnotationUtils.toString((Annotation)ediEltAnnotation) + " must have position defined if there a qualifier defined");
            }
            if (ediEltAnnotation.pos() > 0 && ediEltAnnotation.pos() == pos && StringUtils.isBlank((CharSequence)ediEltAnnotation.qualifier())) {
                return accessibleObject;
            }
            if (ediEltAnnotation.pos() == pos && seg != null && StringUtils.equalsIgnoreCase((CharSequence)ediEltAnnotation.qualifier(), (CharSequence)seg.getQualifierCode())) {
                return accessibleObject;
            }
            for (String eltName : annotationEltNames = ediEltAnnotation.value()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)eltName)) {
                    return accessibleObject;
                }
                if (!StringUtils.isNotBlank((CharSequence)eltName)) continue;
                annNames.add(eltName);
                candidateFields.add(accessibleObject);
            }
        }
        if (!annNames.isEmpty() && (i = this.findMatchBySuffix(annNames, name)) >= 0) {
            return (AccessibleObject)candidateFields.get(i);
        }
        return null;
    }

    private int findMatchBySuffix(List<String> candidates, String toFind) {
        int i = 0;
        int indexOfMatch = toFind.length() + 1;
        int foundNameI = -1;
        for (String potentialName : candidates) {
            int ind;
            if (StringUtils.equalsIgnoreCase((CharSequence)toFind, (CharSequence)potentialName)) {
                return i;
            }
            if (StringUtils.isNotBlank((CharSequence)potentialName) && StringUtils.endsWithIgnoreCase((CharSequence)toFind, (CharSequence)potentialName) && (ind = StringUtils.lastIndexOfIgnoreCase((CharSequence)toFind, (CharSequence)potentialName)) < indexOfMatch) {
                indexOfMatch = ind;
                foundNameI = i;
            }
            ++i;
        }
        return foundNameI;
    }

    public List<T> mapRepeating(Collection<String> repeatingEltNames, EltSet eltSet, Supplier<T> factory) {
        List<List<Elt>> eltRows = eltSet.getRepeating(repeatingEltNames);
        ArrayList<T> objs = new ArrayList<T>();
        for (List<Elt> row : eltRows) {
            T objToPopulate = factory.get();
            this.populateObject(objToPopulate, eltSet.parentSeg(), row);
            objs.add(objToPopulate);
        }
        return objs;
    }

    @Generated
    public EdiObjectMapper() {
    }

    @Generated
    public Map<String, MappingDescriptor> eltMappings() {
        return this.eltMappings;
    }

    @Generated
    public EdiObjectMapper<T> eltMappings(Map<String, MappingDescriptor> eltMappings) {
        this.eltMappings = eltMappings;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdiObjectMapper)) {
            return false;
        }
        EdiObjectMapper other = (EdiObjectMapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, MappingDescriptor> this$eltMappings = this.eltMappings();
        Map<String, MappingDescriptor> other$eltMappings = other.eltMappings();
        return !(this$eltMappings == null ? other$eltMappings != null : !((Object)this$eltMappings).equals(other$eltMappings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdiObjectMapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, MappingDescriptor> $eltMappings = this.eltMappings();
        result = result * 59 + ($eltMappings == null ? 43 : ((Object)$eltMappings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdiObjectMapper(eltMappings=" + String.valueOf(this.eltMappings()) + ")";
    }
}

