/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import hdi.edi.legacyparser.EdiDataType;
import hdi.edi.parser.NameUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ElementDictionary
implements Comparable<ElementDictionary> {
    private EdiDataType ediDataType;
    private String ediId;
    private int index = -1;
    private String designator = "";
    private String jsonName = "";
    private boolean required = false;
    private String missingError = "";
    private String dataType = "string";
    private boolean nullable = true;
    private boolean isArray = false;
    private int length = -1;
    private int precision = 0;
    private int scale = 0;
    private String format = "";

    public ElementDictionary() {
    }

    public ElementDictionary(int index, String designator, String jsonName, boolean required, String missingError) {
        this.index = index;
        this.designator = designator;
        this.jsonName = NameUtils.cleanName(jsonName);
        this.required = required;
        this.missingError = missingError;
    }

    public ElementDictionary(int index, String designator, String jsonName, boolean required, String missingError, String dataType, boolean nullable, int length, int scale, int precision, String format) {
        this.index = index;
        this.designator = designator;
        this.jsonName = NameUtils.cleanName(jsonName);
        this.required = required;
        this.missingError = missingError;
        this.dataType = dataType;
        this.nullable = nullable;
        this.length = length;
        this.scale = scale;
        this.precision = precision;
        this.format = format;
    }

    public ElementDictionary(ElementDictionary anotherEltDict) {
        this(anotherEltDict.index, anotherEltDict.designator, anotherEltDict.jsonName, anotherEltDict.required, anotherEltDict.missingError, anotherEltDict.dataType, anotherEltDict.nullable, anotherEltDict.length, anotherEltDict.scale, anotherEltDict.precision, anotherEltDict.format);
        this.ediDataType = anotherEltDict.ediDataType;
        this.ediId = anotherEltDict.ediId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getDesignator() {
        return this.designator;
    }

    public void setDesignator(String designator) {
        this.designator = designator;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getMissingError() {
        return this.missingError;
    }

    public void setMissingError(String missingError) {
        this.missingError = missingError;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.ediDataType = switch (dataType) {
            case "string" -> EdiDataType.STRING;
            case "date" -> EdiDataType.DATE;
            case "time" -> EdiDataType.TIME;
            case "numeric" -> EdiDataType.NUMERIC;
            case "decimal" -> EdiDataType.DECIMAL;
            default -> null;
        };
    }

    public EdiDataType ediDataType() {
        if (this.ediDataType == EdiDataType.STRING && StringUtils.equalsIgnoreCase((CharSequence)"DTP03", (CharSequence)this.designator) && StringUtils.equalsIgnoreCase((CharSequence)"CCYYMMDD", (CharSequence)this.format)) {
            return EdiDataType.DATE;
        }
        return this.ediDataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public int compareTo(ElementDictionary that) {
        return this.getJsonName().compareTo(that.getJsonName());
    }

    public String getDesignatorNameForLogging() {
        Object s = "";
        if (StringUtils.isNotBlank((CharSequence)this.designator)) {
            s = (String)s + this.designator;
        }
        if (StringUtils.isNotBlank((CharSequence)this.jsonName)) {
            Object eltName = StringUtils.replace((String)NameUtils.cleanName(this.jsonName), (String)"_", (String)" ");
            eltName = StringUtils.isNotBlank((CharSequence)s) ? " (" + (String)eltName + ")" : "'" + (String)eltName + "'";
            s = (String)s + (String)eltName;
        }
        return s;
    }

    @Generated
    public String toString() {
        return "ElementDictionary(ediDataType=" + String.valueOf(this.ediDataType()) + ", ediId=" + this.ediId() + ", index=" + this.index + ", designator=" + this.designator + ", jsonName=" + this.jsonName + ", required=" + this.required + ", missingError=" + this.missingError + ", dataType=" + this.dataType + ", nullable=" + this.nullable + ", isArray=" + this.isArray() + ", length=" + this.length + ", precision=" + this.precision + ", scale=" + this.scale + ", format=" + this.format + ")";
    }

    @Generated
    public ElementDictionary ediDataType(EdiDataType ediDataType) {
        this.ediDataType = ediDataType;
        return this;
    }

    @Generated
    public String ediId() {
        return this.ediId;
    }

    @Generated
    public ElementDictionary ediId(String ediId) {
        this.ediId = ediId;
        return this;
    }

    @Generated
    public ElementDictionary jsonName(String jsonName) {
        this.jsonName = jsonName;
        return this;
    }

    @Generated
    public boolean isArray() {
        return this.isArray;
    }

    @Generated
    public ElementDictionary isArray(boolean isArray) {
        this.isArray = isArray;
        return this;
    }

    @Generated
    public ElementDictionary length(int length) {
        this.length = length;
        return this;
    }

    @Generated
    public ElementDictionary scale(int scale) {
        this.scale = scale;
        return this;
    }
}

