/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import hdi.edi.legacyparser.EltValHolder;
import hdi.edi.parser.SegmentType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class EdiSegment {
    private SegmentType type;
    @JsonProperty(value="loop")
    private String loop = "";
    @JsonProperty(value="tag")
    private String tag = "";
    @JsonProperty(value="qualifier")
    private String qualifier = "";
    @JsonProperty(value="name")
    private String name = "";
    @JsonProperty(value="description")
    private String description = "";
    @JsonIgnore
    private boolean isMapped = false;
    @JsonIgnore
    private LocalDateTime functionalGroupCreationGSDateAndTime;
    private List<String> rawElts = new ArrayList<String>();
    @JsonIgnore
    EdiSegment parent = null;
    @JsonProperty(value="elements")
    Map<String, Object> elements = new LinkedHashMap<String, Object>();
    @JsonProperty(value="multiElements")
    Map<String, List<Object>> multiElements = new LinkedHashMap<String, List<Object>>();
    @JsonProperty(value="segments")
    List<EdiSegment> segments = new ArrayList<EdiSegment>();
    private List<EltValHolder> eltHolders = new ArrayList<EltValHolder>();
    private boolean isArray;
    private boolean isLoopParent;

    public String hashTag() {
        return this.tag + "__" + this.loop;
    }

    public boolean isLoopParent() {
        return this.isLoopParent || !this.segments.isEmpty() || this.isTypeOneOf(SegmentType.SVC, SegmentType.CLP, SegmentType.CLM, SegmentType.LX);
    }

    public boolean isSwitchToParent() {
        return this.isTypeOneOf(SegmentType.PLB, SegmentType.SE);
    }

    public EdiSegment tag(String tag) {
        this.tag = StringUtils.upperCase((String)tag);
        this.type = SegmentType.fromTag(tag);
        return this;
    }

    public boolean isControlSegment() {
        return this.type != null && this.type.isControlSegment();
    }

    public boolean isTypeOneOf(SegmentType ... segmentTypes) {
        return this.type != null && this.type.isOneOf(segmentTypes);
    }

    public String getRawElt(int i) {
        if (i >= this.rawElts.size()) {
            return null;
        }
        return this.rawElts.get(i);
    }

    public EdiSegment findChildSegment(SegmentType type) {
        return this.findChildSegment(type.name());
    }

    public EdiSegment findChildSegment(String tag) {
        for (EdiSegment seg : this.segments) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)seg.tag, (CharSequence)tag)) continue;
            return seg;
        }
        return null;
    }

    public EdiSegment addElt(String key, Object val) {
        this.elements.put(key, val);
        return this;
    }

    public EdiSegment addListElt(String key, List<Object> vals) {
        List values = this.multiElements.computeIfAbsent(key, k -> new LinkedList());
        values.addAll(vals);
        return this;
    }

    public String toStringWithElts() {
        Object s = StringUtils.joinWith((String)" | ", (Object[])new Object[]{this.tag, this.loop, this.name});
        if (!this.elements.isEmpty()) {
            s = (String)s + ":\n" + this.elements.toString();
        }
        return s;
    }

    public String toString() {
        return "Seg ID:" + this.tag + " Loop:" + this.loop + " Qualifier:" + this.qualifier + " Name:" + this.name + " Segments:" + this.segments.size() + " Elements:" + this.elements.size();
    }

    @Generated
    public EdiSegment() {
    }

    @Generated
    public SegmentType type() {
        return this.type;
    }

    @JsonProperty(value="loop")
    @Generated
    public String loop() {
        return this.loop;
    }

    @JsonProperty(value="tag")
    @Generated
    public String tag() {
        return this.tag;
    }

    @JsonProperty(value="qualifier")
    @Generated
    public String qualifier() {
        return this.qualifier;
    }

    @JsonProperty(value="name")
    @Generated
    public String name() {
        return this.name;
    }

    @JsonProperty(value="description")
    @Generated
    public String description() {
        return this.description;
    }

    @JsonIgnore
    @Generated
    public boolean isMapped() {
        return this.isMapped;
    }

    @JsonIgnore
    @Generated
    public LocalDateTime functionalGroupCreationGSDateAndTime() {
        return this.functionalGroupCreationGSDateAndTime;
    }

    @Generated
    public List<String> rawElts() {
        return this.rawElts;
    }

    @JsonIgnore
    @Generated
    public EdiSegment parent() {
        return this.parent;
    }

    @JsonProperty(value="elements")
    @Generated
    public Map<String, Object> elements() {
        return this.elements;
    }

    @JsonProperty(value="multiElements")
    @Generated
    public Map<String, List<Object>> multiElements() {
        return this.multiElements;
    }

    @JsonProperty(value="segments")
    @Generated
    public List<EdiSegment> segments() {
        return this.segments;
    }

    @Generated
    public List<EltValHolder> eltHolders() {
        return this.eltHolders;
    }

    @Generated
    public boolean isArray() {
        return this.isArray;
    }

    @Generated
    public EdiSegment type(SegmentType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="loop")
    @Generated
    public EdiSegment loop(String loop) {
        this.loop = loop;
        return this;
    }

    @JsonProperty(value="qualifier")
    @Generated
    public EdiSegment qualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @JsonProperty(value="name")
    @Generated
    public EdiSegment name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="description")
    @Generated
    public EdiSegment description(String description) {
        this.description = description;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiSegment isMapped(boolean isMapped) {
        this.isMapped = isMapped;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiSegment functionalGroupCreationGSDateAndTime(LocalDateTime functionalGroupCreationGSDateAndTime) {
        this.functionalGroupCreationGSDateAndTime = functionalGroupCreationGSDateAndTime;
        return this;
    }

    @Generated
    public EdiSegment rawElts(List<String> rawElts) {
        this.rawElts = rawElts;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiSegment parent(EdiSegment parent) {
        this.parent = parent;
        return this;
    }

    @JsonProperty(value="elements")
    @Generated
    public EdiSegment elements(Map<String, Object> elements) {
        this.elements = elements;
        return this;
    }

    @JsonProperty(value="multiElements")
    @Generated
    public EdiSegment multiElements(Map<String, List<Object>> multiElements) {
        this.multiElements = multiElements;
        return this;
    }

    @JsonProperty(value="segments")
    @Generated
    public EdiSegment segments(List<EdiSegment> segments) {
        this.segments = segments;
        return this;
    }

    @Generated
    public EdiSegment eltHolders(List<EltValHolder> eltHolders) {
        this.eltHolders = eltHolders;
        return this;
    }

    @Generated
    public EdiSegment isArray(boolean isArray) {
        this.isArray = isArray;
        return this;
    }

    @Generated
    public EdiSegment isLoopParent(boolean isLoopParent) {
        this.isLoopParent = isLoopParent;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdiSegment)) {
            return false;
        }
        EdiSegment other = (EdiSegment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$loop = this.loop();
        String other$loop = other.loop();
        if (this$loop == null ? other$loop != null : !this$loop.equals(other$loop)) {
            return false;
        }
        String this$tag = this.tag();
        String other$tag = other.tag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.description();
        String other$description = other.description();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdiSegment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $loop = this.loop();
        result = result * 59 + ($loop == null ? 43 : $loop.hashCode());
        String $tag = this.tag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.description();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

