/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import com.fasterxml.jackson.databind.ObjectMapper;
import hdi.edi.legacyparser.CleanPath;
import hdi.edi.legacyparser.ElementDictionary;
import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.legacyparser.SegmentDictionary;
import hdi.edi.objmapper.EdiMapperException;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.TransactionType;
import hdi.util.JacksonUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiDictionary {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiDictionary.class);
    private String title = "EDI Parser Dictionary";
    private String version = "1.1";
    private Map<String, SegmentDictionary> profDictionary = new LinkedHashMap<String, SegmentDictionary>();
    private Map<String, SegmentDictionary> instDictionary = new LinkedHashMap<String, SegmentDictionary>();
    private Map<String, SegmentDictionary> dentDictionary = new LinkedHashMap<String, SegmentDictionary>();
    private Map<String, SegmentDictionary> payDictionary = new LinkedHashMap<String, SegmentDictionary>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, SegmentDictionary> getProfDictionary() {
        return this.profDictionary;
    }

    public void setProfDictionary(Map<String, SegmentDictionary> profDictionary) {
        this.profDictionary = profDictionary;
    }

    public Map<String, SegmentDictionary> getInstDictionary() {
        return this.instDictionary;
    }

    public void setInstDictionary(Map<String, SegmentDictionary> instDictionary) {
        this.instDictionary = instDictionary;
    }

    public Map<String, SegmentDictionary> getDentDictionary() {
        return this.dentDictionary;
    }

    public void setDentDictionary(Map<String, SegmentDictionary> dentDictionary) {
        this.dentDictionary = dentDictionary;
    }

    public Map<String, SegmentDictionary> getDictionary(TransactionType type) {
        if (type == TransactionType.PROF) {
            return this.getProfDictionary();
        }
        if (type == TransactionType.INST) {
            return this.getInstDictionary();
        }
        if (type == TransactionType.DENTAL) {
            return this.getDentDictionary();
        }
        if (type == TransactionType.PAYMENT) {
            return this.getPayDictionary();
        }
        throw new EdiMapperException("Unknown claim type %s", type.name());
    }

    public static void main(String[] args) {
        log.info("EDI Dictionary Import");
        Locale.setDefault(Locale.ENGLISH);
        if (args.length > 0) {
            if (args[0].toLowerCase(Locale.ENGLISH).compareTo("--help") == 0 || args[0].toLowerCase(Locale.ENGLISH).compareTo("-h") == 0) {
                EdiDictionary.writeHelp();
                System.exit(0);
            }
            if (args[0].toLowerCase(Locale.ENGLISH).compareTo("--importreplace") == 0 || args[0].toLowerCase(Locale.ENGLISH).compareTo("-ir") == 0 || args[0].toLowerCase(Locale.ENGLISH).compareTo("-importadd") == 0 || args[0].toLowerCase(Locale.ENGLISH).compareTo("-ia") == 0) {
                boolean replceSegments;
                String importTypeSwitch = "";
                String csvImportFile = "";
                Object importedDictionaryFile = "";
                boolean bl = replceSegments = args[0].toLowerCase(Locale.ENGLISH).compareTo("--importreplace") == 0 || args[0].toLowerCase(Locale.ENGLISH).compareTo("-ir") == 0;
                if (args.length > 1) {
                    if (args[1].length() > 1) {
                        importTypeSwitch = args[1].substring(1, args[1].length()).toLowerCase(Locale.ENGLISH);
                    }
                    if (importTypeSwitch.length() == 0 || !importTypeSwitch.equals("p") && !importTypeSwitch.equals("i") && !importTypeSwitch.equals("d") && !importTypeSwitch.equals("835")) {
                        log.error("ERROR: Incorrect dictionary type option, should be <-P|-p|-I|-i|-D|-d|-835>.");
                        log.info("You supplied: " + importTypeSwitch);
                        log.info("See help below for more info:");
                        EdiDictionary.writeHelp();
                        System.exit(11);
                    }
                } else {
                    log.error("ERROR: Dictionary type to import was not specified.");
                    System.exit(12);
                }
                if (args.length > 2) {
                    csvImportFile = args[2];
                } else {
                    log.error("ERROR: CSV claimfile for import was not specified.");
                    System.exit(12);
                }
                importedDictionaryFile = args.length > 3 ? args[3] : csvImportFile + ".json";
                log.info("Importing CSV claimfile: " + csvImportFile);
                log.info("Importing dictionary type: " + importTypeSwitch);
                log.info("Output dictionary claimfile: " + (String)importedDictionaryFile);
                log.info("You specified to " + (replceSegments ? "REPLACE old segments with newer ones." : "add new segments, leaving existing ones as-is."));
                log.info("Dictionary type: " + importTypeSwitch);
                TransactionType csvDictType = TransactionType.UNKNOWN;
                if (importTypeSwitch.equals("p")) {
                    csvDictType = TransactionType.PROF;
                    log.info("Will import Professional (837P) dictionary");
                } else if (importTypeSwitch.equals("i")) {
                    csvDictType = TransactionType.INST;
                    log.info("Will import Institutional (837I) dictionary");
                } else if (importTypeSwitch.equals("835")) {
                    csvDictType = TransactionType.PAYMENT;
                    log.info("Will import Payment (835) dictionary");
                } else {
                    csvDictType = TransactionType.DENTAL;
                    log.info("Will import Dental (837D) dictionary");
                }
                EdiDictionary dictImport = null;
                int importedSegments = 0;
                File fdimp = new File(CleanPath.cleanFilePath((String)importedDictionaryFile));
                if (fdimp.exists()) {
                    try {
                        dictImport = EdiDictionary.load((String)importedDictionaryFile);
                    }
                    catch (Exception ex) {
                        log.error("ERROR importing dictionary from CSV: " + ex.toString());
                        System.exit(13);
                    }
                    if (dictImport == null) {
                        log.error("ERROR: Could not load dictionary claimfile: " + (String)importedDictionaryFile);
                        System.exit(17);
                    }
                } else {
                    dictImport = new EdiDictionary();
                }
                try {
                    importedSegments = dictImport.importCSV(csvImportFile, csvDictType, replceSegments);
                }
                catch (Exception ex) {
                    log.error("ERROR importing dictionary from CSV: " + ex.toString());
                    System.exit(13);
                }
                if (importedSegments > 0) {
                    if (!fdimp.renameTo(new File(CleanPath.cleanFilePath((String)importedDictionaryFile + "." + new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date()) + ".bak")))) {
                        log.info("Creating backup of old dictionary failed, replacing dictionary claimfile");
                    }
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(CleanPath.cleanFilePath((String)importedDictionaryFile)), (Object)dictImport);
                    }
                    catch (IOException ex) {
                        log.error("ERROR serializing dictionary: " + ex.toString());
                        System.exit(14);
                    }
                    log.info("Imported " + importedSegments + " segments from CSV into dictionary.");
                } else {
                    log.info("No segments imported, changes were not saved.");
                }
                System.exit(0);
            }
        }
    }

    public static void writeHelp() {
        log.info("usage (help): edidictionary <--help|-h>");
        log.info("usage (import dictionary): edidictionary <--importreplace|-ir|--importadd|-ia> <-P|-p|-I|-i|-D|-d|-835> <dictionary_import_file.csv> [dictionary_file.json]");
        log.info("\t-importreplace|-ir\tImport dictionary from CSV, replacing existing segments");
        log.info("\t-importadd|-ia\tImport dictionary from CSV, only adding new segments");
        log.info("\t-P|-p\tImport 837P dictionary");
        log.info("\t-I|-i\tImport 837I dictionary");
        log.info("\t-D|-d\tImport 837D dictionary");
        log.info("\t-835\tImport 835 dictionary");
    }

    public int importCSV(String csvFileLoc, TransactionType invType, boolean replaceSegments) throws IOException {
        int segAdded = 0;
        int segReplaced = 0;
        int linesRead = 0;
        String tag = "";
        String code = "";
        String loop = "";
        boolean isLineLevel = false;
        int segRepeat = 1;
        String description = "";
        SegmentDictionary segNew = null;
        int index = -1;
        boolean nullable = true;
        int elLength = -1;
        int precision = 0;
        int scale = 0;
        ElementWithChildrenDictionary el = null;
        Locale.setDefault(Locale.ENGLISH);
        ArrayList<SegmentDictionary> dupElementsList = new ArrayList<SegmentDictionary>();
        ArrayList<CallSite> segIdList = new ArrayList<CallSite>();
        BufferedWriter wlog = null;
        try {
            wlog = new BufferedWriter(new FileWriter(CleanPath.cleanFilePath(csvFileLoc + ".log")));
            Scanner scan = new Scanner(new File(CleanPath.cleanFilePath(csvFileLoc)));
            scan.useDelimiter(Pattern.compile("\r\n"));
            while (scan.hasNext()) {
                String csvRow = scan.next();
                if (++linesRead == 1) continue;
                String[] cells = csvRow.trim().split("\\,", -1);
                if (cells.length < 17) {
                    wlog.write("Row contains less than 17 elements, row=" + csvRow);
                    wlog.newLine();
                    wlog.flush();
                    continue;
                }
                if (cells[10].toLowerCase(Locale.ENGLISH).equals("y")) {
                    segNew = null;
                    wlog.write(linesRead + ",SEGMENT,");
                    String parent = cells[0].trim().toUpperCase(Locale.ENGLISH);
                    tag = cells[1].trim().toUpperCase(Locale.ENGLISH);
                    code = cells[9].trim().toUpperCase(Locale.ENGLISH);
                    loop = cells[6].trim().toUpperCase(Locale.ENGLISH);
                    description = cells[2].trim();
                    String segJsonName = cells[2].trim().toLowerCase(Locale.ENGLISH).replace(' ', '_').replace('/', '_').replace('-', '_');
                    boolean isHeader = tag.toUpperCase(Locale.ENGLISH).equals("ISA") || tag.toUpperCase(Locale.ENGLISH).equals("GS");
                    boolean segRequired = cells[5].trim().toUpperCase(Locale.ENGLISH).equals("R");
                    if (loop.length() < 2 || tag.length() == 0 || segJsonName.length() == 0) {
                        wlog.write("Error: Incorrect parameters: tag=" + tag + " code=" + code + " loop=" + loop + " JSON name=" + segJsonName);
                        wlog.newLine();
                        continue;
                    }
                    try {
                        int loopNumber = Integer.parseInt(loop.substring(0, 2));
                        isLineLevel = loopNumber >= 24;
                    }
                    catch (NumberFormatException e) {
                        wlog.write("Warning: Can't identify line level from loop=" + loop + ",");
                    }
                    String segRepeatStr = cells[7].trim();
                    if (segRepeatStr.equals(">1")) {
                        segRepeat = -1;
                    } else if (segRepeatStr.length() == 0) {
                        wlog.write("Warning= Segment repeat value is missing,");
                    } else {
                        try {
                            segRepeat = Integer.parseInt(segRepeatStr);
                        }
                        catch (NumberFormatException e) {
                            wlog.write("Warning: Can't identify segment repeat from value=" + segRepeatStr + ",");
                            segRepeat = 1;
                        }
                    }
                    segNew = new SegmentDictionary(parent, tag, code, loop, segJsonName, isLineLevel, isHeader, segRepeat, segRequired);
                    segNew.setDescription(description);
                    SegmentDictionary segOld = this.getDictionary(invType).get(tag + "_" + code + "_" + loop);
                    if (segOld == null && (code == null ? "" : code).length() == 0) {
                        segOld = this.getDictionary(invType).get(tag + "__" + loop);
                    }
                    if (segOld != null) {
                        if (replaceSegments) {
                            wlog.write("REPLACE,");
                            this.getDictionary(invType).put(segOld.hashTag(), segNew);
                            ++segReplaced;
                        } else {
                            wlog.write("SKIP,");
                        }
                    } else {
                        wlog.write("ADD,");
                        this.getDictionary(invType).put(segNew.hashTag(), segNew);
                        ++segAdded;
                    }
                    wlog.write(tag + "," + code + "," + loop + "," + segJsonName + ",isLineLevel=" + isLineLevel + ",isHeader=" + isHeader + ",repeat=" + segRepeat + ",");
                    String segId = tag + "_" + code + "_" + loop;
                    segIdList.add((CallSite)((Object)segId));
                } else {
                    int desIndex;
                    String indexStr = cells[14].trim();
                    String designator = cells[1].trim().toUpperCase(Locale.ENGLISH);
                    String elJsonName = cells[2].trim().toLowerCase(Locale.ENGLISH).replace(' ', '_').replace('/', '_').replace('-', '_');
                    boolean elRequired = cells[15].trim().toLowerCase(Locale.ENGLISH).equals("y");
                    String missingError = cells[16].trim();
                    String format = cells[13].trim();
                    boolean isSubElement = false;
                    if (designator.length() > 2 && (desIndex = designator.indexOf(45)) > -1 && designator.length() > desIndex) {
                        isSubElement = true;
                        wlog.write(linesRead + ",Sub-element,");
                        String subElIndex = designator.substring(desIndex + 1);
                        try {
                            index = Integer.parseInt(subElIndex);
                            --index;
                        }
                        catch (NumberFormatException e) {
                            wlog.write("Error: Index value incorrect=" + subElIndex + "," + designator + "," + elJsonName + ",Skipping sub-element");
                            wlog.newLine();
                            continue;
                        }
                    }
                    if (!isSubElement) {
                        el = null;
                        wlog.write(linesRead + ",Element,");
                        try {
                            index = Integer.parseInt(indexStr);
                        }
                        catch (NumberFormatException e) {
                            wlog.write("Error: Index value incorrect=" + indexStr + "," + designator + "," + elJsonName + ",Skipping " + (isSubElement ? "Sub-elemnt" : "Element"));
                            wlog.newLine();
                            continue;
                        }
                        String desigIndexStr = designator.replaceAll("[^0-9.]", "");
                        try {
                            int desigIndex = Integer.parseInt(desigIndexStr);
                            if (desigIndex != index && desigIndex - 100 != index && desigIndex - 200 != index && desigIndex - 300 != index && desigIndex - 400 != index && desigIndex - 500 != index) {
                                wlog.write("Warning: Index value doesn't mtch designator index value=" + desigIndex + ",");
                            }
                        }
                        catch (NumberFormatException e) {
                            wlog.write("Warning: Designator index value incorrect=" + desigIndexStr + " Aborting designator index verification,");
                        }
                    }
                    if (index < 0 || designator.length() == 0 || elJsonName.length() == 0) {
                        wlog.write("Error: Incorrect parameters: index=" + index + " Designator=" + designator + " ColumnName=" + elJsonName + " Skipping element.");
                        wlog.newLine();
                        continue;
                    }
                    String dataTypeCell = cells[3].trim();
                    if (dataTypeCell.startsWith("N") && dataTypeCell.length() > 1) {
                        String scaleString = dataTypeCell.substring(1);
                        try {
                            scale = Integer.parseInt(scaleString);
                        }
                        catch (NumberFormatException ex) {
                            wlog.write("Could not parse scale from type: " + dataTypeCell + " Element: " + tag + "_" + code + "_" + loop);
                        }
                        dataTypeCell = "N";
                    }
                    String dataType = switch (dataTypeCell) {
                        case "AN" -> "string";
                        case "DT" -> "date";
                        case "TM" -> "time";
                        case "ID" -> "string";
                        case "N" -> "numeric";
                        case "R" -> "decimal";
                        default -> "string";
                    };
                    String strLength = cells[8].trim();
                    try {
                        if (strLength.length() > 0) {
                            elLength = Integer.parseInt(strLength);
                        }
                    }
                    catch (NumberFormatException e) {
                        wlog.write("Warning> Incorrect max length=" + strLength + ",");
                    }
                    wlog.write(index + "," + designator + "," + elJsonName + "," + dataType + "," + format + "," + elRequired + "," + missingError);
                    if (isSubElement) {
                        if (el == null) {
                            wlog.write("Error: Element is missing - skipping this sub-element");
                            wlog.newLine();
                            continue;
                        }
                        ElementDictionary subElement = new ElementDictionary(index, designator, elJsonName, elRequired, missingError, dataType, nullable, elLength, scale, precision, format);
                        el.subElements.add(subElement);
                    } else {
                        if (segNew == null) {
                            wlog.write("Error: Segment is missing - skipping this element");
                            wlog.newLine();
                            continue;
                        }
                        el = new ElementWithChildrenDictionary(index, designator, elJsonName, elRequired, missingError, dataType, nullable, elLength, scale, precision, format);
                        segNew.elements.add(el);
                        SegmentDictionary dupEl = new SegmentDictionary();
                        dupEl.setTag(segNew.getTag());
                        dupEl.setCode(segNew.getCode());
                        dupEl.setLoop(segNew.getLoop());
                        dupEl.setJsonName(el.getJsonName());
                        dupElementsList.add(dupEl);
                    }
                }
                wlog.newLine();
                wlog.flush();
            }
            if (segIdList.size() > 1) {
                wlog.newLine();
                wlog.write("Duplicates in segment IDs:");
                wlog.newLine();
                int dupSegFound = 0;
                Collections.sort(segIdList);
                for (int i = 1; i < segIdList.size(); ++i) {
                    if (!((String)segIdList.get(i)).trim().toLowerCase(Locale.ENGLISH).equals(((String)segIdList.get(i - 1)).trim().toLowerCase(Locale.ENGLISH))) continue;
                    wlog.write((String)segIdList.get(i));
                    wlog.newLine();
                    ++dupSegFound;
                }
                wlog.write("Duplicate segment IDs found=" + dupSegFound);
                wlog.newLine();
            }
            if (dupElementsList.size() > 1) {
                wlog.newLine();
                wlog.write("Duplicates in JSON names of the elements:");
                wlog.newLine();
                int dupFound = 0;
                Collections.sort(dupElementsList);
                for (int i = 1; i < dupElementsList.size(); ++i) {
                    String elPrev;
                    if (!((SegmentDictionary)dupElementsList.get(i)).getJsonName().trim().toLowerCase(Locale.ENGLISH).equals(((SegmentDictionary)dupElementsList.get(i - 1)).getJsonName().trim().toLowerCase(Locale.ENGLISH))) continue;
                    String elNext = ((SegmentDictionary)dupElementsList.get(i)).getLoop().substring(0, 2);
                    if (!elNext.equals(elPrev = ((SegmentDictionary)dupElementsList.get(i - 1)).getLoop().substring(0, 2))) {
                        wlog.write("  Should be OK: ");
                    }
                    wlog.write(((SegmentDictionary)dupElementsList.get(i)).getJsonName() + "  (" + ((SegmentDictionary)dupElementsList.get(i)).getTag() + "," + ((SegmentDictionary)dupElementsList.get(i)).getCode() + "," + ((SegmentDictionary)dupElementsList.get(i)).getLoop() + ") prev: " + ((SegmentDictionary)dupElementsList.get(i - 1)).getJsonName() + "(" + ((SegmentDictionary)dupElementsList.get(i - 1)).getTag() + "," + ((SegmentDictionary)dupElementsList.get(i - 1)).getCode() + "," + ((SegmentDictionary)dupElementsList.get(i - 1)).getLoop() + ")");
                    wlog.newLine();
                    ++dupFound;
                }
                wlog.write("Duplicate JSON names found=" + dupFound);
                wlog.newLine();
            }
            wlog.close();
        }
        catch (FileNotFoundException fnfex) {
            throw fnfex;
        }
        finally {
            if (wlog != null) {
                try {
                    wlog.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return segAdded + segReplaced;
    }

    public static EdiDictionary load(String dictFile) throws IOException {
        EdiDictionary dict = (EdiDictionary)JacksonUtils.DEFAULT_MAPPER.readValue(new File(CleanPath.cleanFilePath(dictFile)), EdiDictionary.class);
        if (dict == null) {
            log.error("The dictionary is empty: " + dictFile);
        } else {
            log.info("Dictionary loaded, version: " + dict.getVersion());
            log.info("837P dictionary elements: " + dict.getProfDictionary().size());
            log.info("837I dictionary elements: " + dict.getInstDictionary().size());
            log.info("837D dictionary elements: " + dict.getDentDictionary().size());
        }
        return dict;
    }

    public static EdiDictionary loadFromResource(String dictFile) {
        EdiDictionary dict;
        try (InputStream dictResInp = EdiDictionary.class.getResourceAsStream(dictFile);){
            if (dictResInp == null) {
                throw new IOException("Dictionary resource was not found: " + dictFile);
            }
            dict = (EdiDictionary)JacksonUtils.DEFAULT_MAPPER.readValue(dictResInp, EdiDictionary.class);
        }
        if (dict == null) {
            throw new EdiParserException("Dictionary %s is empty", dictFile);
        }
        return dict;
    }

    public Map<String, SegmentDictionary> getPayDictionary() {
        return this.payDictionary;
    }

    public void setPayDictionary(Map<String, SegmentDictionary> payDictionary) {
        this.payDictionary = payDictionary;
    }
}

