/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.ediwriter;

import hdi.codeent.CodeEntity;
import hdi.edi.EdiTransaction;
import hdi.edi.dict.DictField;
import hdi.edi.dict.DictMgr;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.ediwriter.EltCreator;
import hdi.edi.parser.DatePair;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltDesignator;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.ContactNumber;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PatientSubscriber;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjToSegMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjToSegMapper.class);

    public List<EdiSeg> createSegsFromContainedObjects(TransactionType tranType, Object obj, SegmentType ... segTypes) {
        List<DictField> dfs = DictMgr.getDictFields(obj.getClass(), tranType, segTypes);
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        for (DictField df : dfs) {
            if (df.objType() == null || df.objType() == ObjType.NONE) continue;
            Field field = df.field();
            Object val = FieldUtils.readField((Field)df.field(), (Object)obj, (boolean)true);
            if (val == null) continue;
            SegmentType segType = df.designator().segType();
            if (field.getType() == List.class) {
                List list = (List)val;
                if (list.isEmpty()) continue;
                Object firstItem = list.get(0);
                if (firstItem instanceof CodeEntity) {
                    List codeEntities = (List)val;
                    if (tranType == TransactionType.INST) {
                        List<EdiSeg> codeEntSegs = this.createCodeEntSegsForBySubType(tranType, segType, codeEntities);
                        segs.addAll(codeEntSegs);
                        continue;
                    }
                    EdiSeg seg = this.createCodeEntSeg(tranType, segType, codeEntities);
                    segs.add(seg);
                    continue;
                }
                List<EdiSeg> segsFromList = this.createSegs(tranType, segType, list);
                segs.addAll(segsFromList);
                continue;
            }
            if (!(val instanceof CodeEntity)) continue;
            CodeEntity codeEntity = (CodeEntity)val;
            EdiSeg seg = this.createCodeEntSeg(tranType, segType, List.of(codeEntity));
            segs.add(seg);
        }
        return segs;
    }

    public List<EdiSeg> createCodeEntSegsForBySubType(TransactionType tranType, SegmentType segType, List<CodeEntity> codeEnts) {
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        if (codeEnts == null || codeEnts.isEmpty()) {
            return segs;
        }
        ArrayList codeEntsBySubType = new ArrayList();
        EdiQualifier curSubType = null;
        ArrayList<CodeEntity> codeEntsForSeg = new ArrayList<CodeEntity>();
        for (CodeEntity codeEntity : codeEnts) {
            EdiQualifier subType = codeEntity.subType();
            if (curSubType == null || !curSubType.ediValue().equals(subType.ediValue())) {
                codeEntsForSeg = new ArrayList();
                codeEntsBySubType.add(codeEntsForSeg);
            }
            codeEntsForSeg.add(codeEntity);
            curSubType = subType;
        }
        for (List list : codeEntsBySubType) {
            EdiSeg seg = this.createCodeEntSeg(tranType, segType, list);
            segs.add(seg);
        }
        return segs;
    }

    public EdiSeg createCodeEntSeg(TransactionType tranType, SegmentType segType, List<CodeEntity> codeEnts) {
        if (codeEnts == null || codeEnts.isEmpty()) {
            return null;
        }
        EdiSeg seg = new EdiSeg(segType);
        EltSet eltSet = new EltSet(seg);
        seg.eltSet(eltSet);
        int pos = 1;
        for (CodeEntity obj : codeEnts) {
            Elt codeEntElt = this.createCodeEntElt(tranType, segType, obj, pos);
            eltSet.add(codeEntElt);
            ++pos;
        }
        return seg;
    }

    private Elt createCodeEntElt(TransactionType tranType, SegmentType segType, CodeEntity codeEnt, int pos) {
        if (segType == SegmentType.SV2 && pos == 1) {
            return EltCreator.createElt("code", codeEnt.code(), pos);
        }
        EltSet codeEntEltSet = new EltSet();
        codeEntEltSet.add(EltCreator.createElt("qualifier", codeEnt.subType().ediValue(), 1));
        codeEntEltSet.add(EltCreator.createElt("code", codeEnt.code(), 2));
        List<DictField> dfs = DictMgr.getDictFields(codeEnt.getClass(), tranType, segType);
        EltSet objEltSet = this.createEltSet(tranType, segType, dfs, codeEnt);
        codeEntEltSet.elts().addAll(objEltSet.elts());
        if (codeEnt.modifierCodes() != null && !codeEnt.modifierCodes().isEmpty()) {
            int modifierPos = 3;
            for (String modifierCode : codeEnt.modifierCodes()) {
                codeEntEltSet.add(EltCreator.createElt("modifier_code", modifierCode, modifierPos));
                ++modifierPos;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)codeEnt.descFromClaim())) {
            codeEntEltSet.add(EltCreator.createElt("description", codeEnt.descFromClaim(), 7));
        }
        Elt codeEntElt = Elt.fromEltSet(codeEnt.subType().name().toLowerCase(), codeEntEltSet);
        codeEntElt.position(pos);
        return codeEntElt;
    }

    public List<EdiSeg> createOrgPersonSegs(TransactionType tranType, SegmentType nameSegType, Collection<OrgOrPerson> orgOrPersonList) {
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        if (orgOrPersonList == null) {
            return segs;
        }
        for (OrgOrPerson orgOrPerson : orgOrPersonList) {
            segs.addAll(this.createOrgPersonSegs(tranType, nameSegType, orgOrPerson));
        }
        return segs;
    }

    public List<EdiSeg> createTransactionSegs(EdiTransaction ediTran) {
        TransactionType tranType = ediTran.transactionType();
        List<EdiSeg> segs = this.createSegs(tranType, ediTran, SegmentType.ST, SegmentType.BHT);
        if (ediTran.sender() != null) {
            this.mapOrgPersonSegs(segs, ediTran.transactionType(), SegmentType.NM1, ediTran.sender());
        }
        if (ediTran.receiver() != null) {
            this.mapOrgPersonSegs(segs, ediTran.transactionType(), SegmentType.NM1, ediTran.receiver());
        }
        return segs;
    }

    public List<EdiSeg> createPatSubSegs(TransactionType tranType, PatientSubscriber patSub) {
        EdiSeg patSeg;
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        if (patSub.person().entityRole() != EntityRole.PATIENT) {
            EdiSeg sbrSeg = this.createSeg(tranType, SegmentType.SBR, patSub);
            segs.add(sbrSeg);
        }
        if ((patSeg = this.createSeg(tranType, SegmentType.PAT, patSub)) != null) {
            if (patSub.person().entityRole() != EntityRole.PATIENT) {
                patSeg.eltSet().removeEltByPosition(1);
            }
            if (patSub.weight() != null) {
                Elt unitElt = EltCreator.createElt("unit", "01", 7);
                patSeg.eltSet().add(unitElt);
            }
            if (!patSeg.eltSet().elts().isEmpty()) {
                segs.add(patSeg);
            }
        }
        List<EdiSeg> nmSegs = this.createOrgPersonSegs(tranType, SegmentType.NM1, patSub.person());
        segs.addAll(nmSegs);
        if (patSub.payer() != null) {
            List<EdiSeg> payerSegs = this.createOrgPersonSegs(tranType, SegmentType.NM1, patSub.payer());
            segs.addAll(payerSegs);
        }
        return segs;
    }

    public void mapOrgPersonSegs(List<EdiSeg> segs, TransactionType tranType, SegmentType nameSegType, OrgOrPerson orgOrPerson) {
        List<EdiSeg> segsToAdd = this.createOrgPersonSegs(tranType, nameSegType, orgOrPerson);
        segs.addAll(segsToAdd);
    }

    public List<EdiSeg> createOrgPersonSegs(TransactionType tranType, SegmentType nameSegType, OrgOrPerson orgOrPerson) {
        EdiSeg dmgSeg;
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        segs.add(this.createSeg(nameSegType, orgOrPerson));
        if (orgOrPerson.address() != null) {
            segs.addAll(this.createSegs(tranType, orgOrPerson.address(), SegmentType.N3, SegmentType.N4));
        }
        if ((dmgSeg = this.createSeg(TransactionType.MEMBER_COVERAGE, SegmentType.DMG, orgOrPerson)) != null) {
            segs.add(dmgSeg);
        }
        if (orgOrPerson.taxId() != null) {
            EdiSeg taxIdSeg = this.createSegFromValues(SegmentType.REF, orgOrPerson.taxIdType().ediValue(), orgOrPerson.taxId());
            segs.add(taxIdSeg);
        }
        List<EdiSeg> refSegs = this.createSegsFromContainedObjects(tranType, orgOrPerson, SegmentType.REF);
        segs.addAll(refSegs);
        this.mapPerSegs(segs, orgOrPerson.contacts());
        return segs;
    }

    public void mapPerSegs(List<EdiSeg> segs, List<ContactInfo> contacts) {
        if (contacts == null || contacts.isEmpty()) {
            return;
        }
        ArrayList<EdiSeg> segsToAdd = new ArrayList<EdiSeg>();
        for (ContactInfo contact : contacts) {
            EdiSeg seg = this.createSeg(SegmentType.PER, contact);
            int pos = 3;
            for (ContactNumber cn : contact.contactNumbers()) {
                Elt typeElt = EltCreator.createElt("type", cn.type().ediValue(), pos);
                seg.eltSet().add(typeElt);
                Elt numberElt = EltCreator.createElt("number", cn.number(), pos + 1);
                seg.eltSet().add(numberElt);
                pos += 2;
            }
            segsToAdd.add(seg);
        }
        segs.addAll(segsToAdd);
    }

    public void mapQualifierBasedSegs(List<EdiSeg> segs, TransactionType tranType, SegmentType segType, Object obj) {
        List<EdiSeg> segsToAdd = this.createQualifierBasedSegs(tranType, segType, obj);
        segs.addAll(segsToAdd);
    }

    public List<EdiSeg> createQualifierBasedSegs(TransactionType tranType, SegmentType segType, Object obj) {
        List<DictField> dfs = DictMgr.getDictFields(obj.getClass(), tranType, segType);
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        HashSet<String> relateFields = new HashSet<String>();
        for (DictField df : dfs) {
            if (df.isDerived() || df.ignoreForEdiGen() || relateFields.contains(df.field().getName())) continue;
            EdiQualifier q = df.activeQualifier();
            if (q != null) {
                EdiSeg seg = this.createQualifierBasedSeg(segType, df, obj);
                if (seg == null) continue;
                segs.add(seg);
                if (!StringUtils.isNotBlank((CharSequence)df.relatedFieldName())) continue;
                relateFields.add(df.relatedFieldName());
                continue;
            }
            log.warn("No active qualifier for field: {}", (Object)df);
        }
        return segs;
    }

    private EdiSeg createQualifierBasedSeg(SegmentType segType, DictField df, Object obj) {
        Elt formatQualifierElt;
        EdiSeg seg = new EdiSeg(segType);
        EltSet eltSet = new EltSet(seg);
        Elt valElt = this.createElt(null, segType, df, obj);
        if (valElt == null) {
            return null;
        }
        String name = df.field().getName() + "-qualifier";
        Elt qualifierElt = EltCreator.createElt(name, df.activeQualifier().ediValue(), 1);
        eltSet.add(qualifierElt);
        if (valElt.position() > 2 && (formatQualifierElt = this.createFormatQualifier(df, valElt)) != null) {
            eltSet.add(formatQualifierElt);
        }
        eltSet.add(valElt);
        seg.eltSet(eltSet);
        return seg;
    }

    private Elt createFormatQualifier(DictField df, Elt valElt) {
        Elt formatQualifierElt = null;
        EdiQualifier formatQualifier = valElt.dataType().formatQualifier();
        if (formatQualifier != null) {
            String name = df.field().getName() + "-format-qualifier";
            formatQualifierElt = EltCreator.createElt(name, formatQualifier.ediValue(), valElt.position() - 1);
        } else {
            log.warn("No formatQualifier for type: {}", (Object)valElt.dataType());
        }
        return formatQualifierElt;
    }

    public EdiSeg createSeg(SegmentType segType, Object obj) {
        return this.createSeg(null, segType, obj);
    }

    public List<EdiSeg> createSegs(TransactionType tranType, Object obj, SegmentType ... segTypes) {
        if (obj == null) {
            return Collections.emptyList();
        }
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        for (SegmentType segType : segTypes) {
            EdiSeg seg = this.createSeg(tranType, segType, obj);
            if (seg == null) continue;
            segs.add(seg);
        }
        return segs;
    }

    public void mapSegs(List<EdiSeg> segs, TransactionType tranType, SegmentType segType, List<?> items) {
        List<EdiSeg> segsToAdd = this.createSegs(tranType, segType, items);
        segs.addAll(segsToAdd);
    }

    public List<EdiSeg> createSegs(TransactionType tranType, SegmentType segType, List<?> items) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        for (Object item : items) {
            EdiSeg seg = this.createSeg(tranType, segType, item);
            segs.add(seg);
        }
        return segs;
    }

    public void mapSeg(List<EdiSeg> segs, TransactionType tranType, SegmentType segType, Object obj) {
        EdiSeg seg = this.createSeg(tranType, segType, obj);
        if (seg != null) {
            segs.add(seg);
        }
    }

    public EdiSeg createSeg(TransactionType tranType, SegmentType segType, Object obj) {
        List<DictField> dfs = DictMgr.getDictFields(obj.getClass(), tranType, segType);
        EdiSeg seg = new EdiSeg(segType);
        EltSet eltSet = this.createEltSet(tranType, segType, dfs, obj);
        if (eltSet.elts().isEmpty()) {
            return null;
        }
        eltSet.parentSeg(seg);
        seg.eltSet(eltSet);
        return seg;
    }

    public EdiSeg createSegFromValues(SegmentType segType, String ... vals) {
        EdiSeg seg = new EdiSeg(segType);
        seg.eltSet(new EltSet(seg));
        int pos = 1;
        for (String val : vals) {
            seg.eltSet().add(EltCreator.createElt("value", val, pos++));
        }
        return seg;
    }

    private EltSet createEltSet(TransactionType tranType, SegmentType segType, List<DictField> dfs, Object obj) {
        EltSet eltSet = new EltSet();
        HashSet<String> relateFields = new HashSet<String>();
        for (DictField df : dfs) {
            Elt elt;
            if (df.ignoreForEdiGen()) continue;
            if (!relateFields.contains(df.field().getName()) && (elt = this.createElt(tranType, segType, df, obj)) != null) {
                this.addImpliedQualifier(df, elt, eltSet);
                eltSet.add(elt);
            }
            if (!StringUtils.isNotBlank((CharSequence)df.relatedFieldName())) continue;
            relateFields.add(df.relatedFieldName());
        }
        return eltSet;
    }

    private EltSet createEltSetFromSimpleList(DictField df, Collection<?> vals) {
        EltSet eltSet = new EltSet();
        int pos = 1;
        for (Object val : vals) {
            Elt elt = Elt.fromSimpleVal(df.field().getName(), val);
            elt.parentPosition(df.designator().pos());
            elt.position(pos++);
            eltSet.add(elt);
        }
        return eltSet;
    }

    private void addImpliedQualifier(DictField df, Elt elt, EltSet eltSet) {
        String desStr = df.designator().str();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)desStr, (CharSequence[])new CharSequence[]{"DTP03", "DMG02", "PAT06", "HI01-4"})) {
            Elt formatQualifierElt = this.createFormatQualifier(df, elt);
            if (formatQualifierElt != null) {
                eltSet.add(formatQualifierElt);
            }
        } else if (desStr.equals("PWK06")) {
            Elt qElt = EltCreator.createElt("identification_code_qualifier", "AC", elt.position() - 1);
            eltSet.add(qElt);
        }
    }

    private Elt createElt(TransactionType tranType, SegmentType segType, DictField dictField, Object obj) {
        Object val = FieldUtils.readField((Field)dictField.field(), (Object)obj, (boolean)true);
        if (val == null) {
            return null;
        }
        EltDesignator designator = dictField.designator();
        if (val instanceof CodeEntity) {
            CodeEntity codeEntity = (CodeEntity)val;
            return this.createCodeEntElt(tranType, segType, codeEntity, designator.pos());
        }
        if (val instanceof Collection) {
            Collection vals = (Collection)val;
            EltSet eltSet = this.createEltSetFromSimpleList(dictField, vals);
            return Elt.fromEltSet(dictField.field().getName(), eltSet).position(designator.pos());
        }
        if (val instanceof LocalDate) {
            Object secondVal;
            LocalDate date = (LocalDate)val;
            if (StringUtils.isNotBlank((CharSequence)dictField.relatedFieldName()) && (secondVal = FieldUtils.readField((Object)obj, (String)dictField.relatedFieldName(), (boolean)true)) instanceof LocalDate) {
                LocalDate secondDate = (LocalDate)secondVal;
                val = new DatePair(date, secondDate);
            }
        }
        if (val instanceof EdiQualifier) {
            EdiQualifier ediQualifier = (EdiQualifier)val;
            val = ediQualifier.ediValue();
        }
        Elt elt = Elt.fromSimpleVal(dictField.field().getName(), val);
        int pos = designator.pos();
        if (designator.subPos() > 0) {
            elt.parentPosition(pos);
            pos = designator.subPos();
        }
        elt.position(pos);
        elt.minWidth(dictField.minWidth());
        elt.maxWidth(dictField.maxWidth());
        return elt;
    }
}

