/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.ediwriter;

import hdi.edi.ediwriter.EltCreator;
import hdi.edi.ediwriter.ObjToSegMapper;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.ClaimOrPayment;
import hdi.model.ServiceLine;
import hdi.model.claim.Claim;
import java.util.ArrayList;
import java.util.List;

public class ClaimToSegMapper {
    private final ObjToSegMapper objToSegMapper = new ObjToSegMapper();
    public static final String DEFAULT_NOTE_QUALIFIER = "ADD";

    List<EdiSeg> mapClaimOnly(TransactionType tranType, Claim claim) {
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        EdiSeg clmSeg = this.createClmClp(tranType, SegmentType.CLM, claim);
        segs.add(clmSeg);
        List<EdiSeg> dateSegs = this.objToSegMapper.createQualifierBasedSegs(tranType, SegmentType.DTP, claim);
        segs.addAll(dateSegs);
        if (tranType == TransactionType.INST) {
            this.objToSegMapper.mapSeg(segs, tranType, SegmentType.CL1, claim);
        }
        this.objToSegMapper.mapSegs(segs, tranType, SegmentType.PWK, claim.attachments());
        this.objToSegMapper.mapQualifierBasedSegs(segs, tranType, SegmentType.AMT, claim);
        this.objToSegMapper.mapQualifierBasedSegs(segs, tranType, SegmentType.REF, claim);
        this.mapClaimNotes(segs, tranType, claim);
        List<EdiSeg> hiSegs = this.objToSegMapper.createSegsFromContainedObjects(tranType, claim, SegmentType.HI);
        segs.addAll(hiSegs);
        List<EdiSeg> providerSegs = this.objToSegMapper.createOrgPersonSegs(tranType, SegmentType.NM1, claim.providers());
        segs.addAll(providerSegs);
        return segs;
    }

    List<EdiSeg> mapLine(TransactionType tranType, ServiceLine serviceLine) {
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>(this.objToSegMapper.createSegs(tranType, serviceLine, SegmentType.SV1, SegmentType.SV2, SegmentType.SV3));
        List<EdiSeg> pwkSegs = this.objToSegMapper.createSegs(tranType, SegmentType.PWK, serviceLine.attachments());
        segs.addAll(pwkSegs);
        List<EdiSeg> dateSegs = this.objToSegMapper.createQualifierBasedSegs(tranType, SegmentType.DTP, serviceLine);
        segs.addAll(dateSegs);
        List<EdiSeg> qtySegs = this.objToSegMapper.createQualifierBasedSegs(tranType, SegmentType.QTY, serviceLine);
        segs.addAll(qtySegs);
        List<EdiSeg> refSegs = this.objToSegMapper.createQualifierBasedSegs(tranType, SegmentType.REF, serviceLine);
        segs.addAll(refSegs);
        List<EdiSeg> amtSegs = this.objToSegMapper.createQualifierBasedSegs(tranType, SegmentType.AMT, serviceLine);
        segs.addAll(amtSegs);
        this.mapLineNotes(segs, serviceLine);
        List<EdiSeg> providerSegs = this.objToSegMapper.createOrgPersonSegs(tranType, SegmentType.NM1, serviceLine.providers());
        segs.addAll(providerSegs);
        return segs;
    }

    void mapClaimNotes(List<EdiSeg> segs, TransactionType tranType, Claim claim) {
        String qualifier = tranType == TransactionType.INST ? "DGN" : DEFAULT_NOTE_QUALIFIER;
        this.mapQualifierSeg(segs, SegmentType.NTE, qualifier, claim.claimNote());
        this.mapQualifierSeg(segs, SegmentType.NTE, DEFAULT_NOTE_QUALIFIER, claim.billingNote());
    }

    private void mapLineNotes(List<EdiSeg> segs, ServiceLine serviceLine) {
        this.mapQualifierSeg(segs, SegmentType.NTE, DEFAULT_NOTE_QUALIFIER, serviceLine.lineNote());
        this.mapQualifierSeg(segs, SegmentType.NTE, "TPO", serviceLine.thirdPartyNote());
    }

    public void mapQualifierSeg(List<EdiSeg> segs, SegmentType segType, String qualifier, String val) {
        if (val != null) {
            EdiSeg seg = this.objToSegMapper.createSegFromValues(segType, qualifier, val);
            segs.add(seg);
        }
    }

    EdiSeg createClmClp(TransactionType transactionType, SegmentType segType, ClaimOrPayment claimOrPayment) {
        EdiSeg seg = this.objToSegMapper.createSeg(transactionType, segType, claimOrPayment);
        int pos = 1;
        Elt facilityCodeElt = null;
        Elt frequencyCodeElt = null;
        if (claimOrPayment.facilityCode() != null) {
            facilityCodeElt = EltCreator.createElt("facility_code", claimOrPayment.facilityCode().code(), pos++);
        }
        if (claimOrPayment.frequencyCode() != null) {
            frequencyCodeElt = EltCreator.createElt("frequency_code", claimOrPayment.frequencyCode().code(), pos++);
        }
        if (transactionType.isClaim()) {
            EltSet tobEltSet = new EltSet();
            if (facilityCodeElt != null) {
                tobEltSet.add(facilityCodeElt);
                String qualifier = transactionType == TransactionType.INST ? "A" : "B";
                tobEltSet.add(EltCreator.createElt("facility_code_qualifier", qualifier, 2));
            }
            if (frequencyCodeElt != null) {
                tobEltSet.add(frequencyCodeElt);
                frequencyCodeElt.position(3);
            }
            seg.eltSet().add(Elt.fromEltSet("tob", tobEltSet).position(5));
        } else if (transactionType == TransactionType.PAYMENT) {
            if (facilityCodeElt != null) {
                facilityCodeElt.position(8);
                seg.eltSet().add(facilityCodeElt);
            }
            if (frequencyCodeElt != null) {
                frequencyCodeElt.position(9);
                seg.eltSet().add(frequencyCodeElt);
            }
        }
        return seg;
    }
}

