/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.dict.openapi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import hdi.edi.dict.DictField;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.openapi.OpenApiDataType;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonPropertyOrder(value={"description", "type", "format", "items"})
public class OpenApiProp {
    @JsonIgnore
    private String name;
    @JsonIgnore
    private OpenApiDataType type;
    private Boolean isRequired;
    @JsonIgnore
    private boolean arrayFlag = false;
    @JsonIgnore
    private String refObjName;
    @JsonIgnore
    private String desc;
    private String defaultValue;
    @JsonIgnore
    private String ediStr;

    public OpenApiProp(ObjType refObjType) {
        this.refObjName = refObjType.typeName();
        this.type = OpenApiDataType.OBJECT;
    }

    @JsonGetter(value="type")
    public String getTypeForSerialization() {
        if (this.type != OpenApiDataType.OBJECT) {
            return this.type.str();
        }
        return null;
    }

    public String getDescription() {
        Object descStr = "";
        if (StringUtils.isNotBlank((CharSequence)this.desc)) {
            descStr = (String)descStr + this.desc;
        }
        if (StringUtils.isNotBlank((CharSequence)this.ediStr)) {
            if (StringUtils.isNotBlank((CharSequence)descStr)) {
                descStr = (String)descStr + ". ";
            }
            descStr = (String)descStr + "EDI: " + this.ediStr;
        }
        return StringUtils.stripToNull((String)descStr);
    }

    @JsonGetter(value="items")
    public Map<String, String> getItemsForArray() {
        if (this.type == OpenApiDataType.ARRAY) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (ObjType.STRING.typeName().equals(this.refObjName)) {
                map.put("type", ObjType.STRING.name().toLowerCase());
            } else if (ObjType.INTEGER.typeName().equals(this.refObjName)) {
                map.put("type", "integer");
                map.put("format", "int32");
            } else {
                map.put("$ref", OpenApiProp.getObjectRef(this.refObjName));
            }
            return map;
        }
        return null;
    }

    private static String getObjectRef(String objectName) {
        return "./" + objectName + ".yaml";
    }

    @JsonGetter(value="format")
    public String getFormatForSerialization() {
        return this.type.format();
    }

    @JsonGetter(value="$ref")
    public String getRef() {
        if (this.type != OpenApiDataType.OBJECT) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.refObjName)) {
            throw new IllegalStateException("RefObjName is null or empty but the type is Object.Name: " + this.name);
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.refObjName, (CharSequence)"None")) {
            throw new IllegalStateException("RefObjName is None: " + this.name);
        }
        return OpenApiProp.getObjectRef(this.refObjName);
    }

    public static OpenApiProp fromDicField(DictField dictField) {
        OpenApiProp prop = new OpenApiProp();
        prop.name = dictField.name();
        prop.desc = StringUtils.stripToNull((String)dictField.getDescriptionStr());
        prop.type = dictField.type().openApiDataType();
        if (prop.type == OpenApiDataType.OBJECT && dictField.objType() == ObjType.STRING) {
            prop.type = OpenApiDataType.STRING;
        } else if (dictField.objType() != null) {
            prop.refObjName = dictField.objType().typeName();
        }
        prop.ediStr = dictField.getEdiStr();
        return prop;
    }

    @JsonIgnore
    @Generated
    public String name() {
        return this.name;
    }

    @JsonIgnore
    @Generated
    public OpenApiDataType type() {
        return this.type;
    }

    @Generated
    public Boolean isRequired() {
        return this.isRequired;
    }

    @JsonIgnore
    @Generated
    public boolean arrayFlag() {
        return this.arrayFlag;
    }

    @JsonIgnore
    @Generated
    public String refObjName() {
        return this.refObjName;
    }

    @JsonIgnore
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public String defaultValue() {
        return this.defaultValue;
    }

    @JsonIgnore
    @Generated
    public String ediStr() {
        return this.ediStr;
    }

    @Generated
    public String toString() {
        return "OpenApiProp(name=" + this.name() + ", type=" + String.valueOf((Object)this.type()) + ", isRequired=" + this.isRequired() + ", arrayFlag=" + this.arrayFlag() + ", refObjName=" + this.refObjName() + ", desc=" + this.desc() + ", defaultValue=" + this.defaultValue() + ", ediStr=" + this.ediStr() + ")";
    }

    @Generated
    public OpenApiProp() {
    }
}

