/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.dict;

import hdi.edi.dict.VariantType;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EltDesignator;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DictField {
    private TransactionType transactionType;
    private String name;
    private DataType type;
    private int minWidth = -1;
    private int maxWidth = -1;
    private ObjType objType;
    private String typeName;
    private String desc;
    private String loop;
    private List<EdiAndQualifier> ediAndQualifiers = new ArrayList<EdiAndQualifier>();
    private boolean isDerived = false;
    private String codeLookupQuery;
    private Field field;
    private EltDesignator designator;
    private EdiQualifier activeQualifier;
    private String relatedFieldName;
    private boolean ignoreForEdiGen;
    private boolean isRequired;
    private List<TransactionType> allowedTransactionTypes = List.of();
    private List<VariantType> variantTypes = List.of();
    private static Map<TransactionType, String> ediExcludes = new HashMap<TransactionType, String>();
    public static List<String> HEADERS = List.of("Name", "Description", "Type", "EDI Element");

    public void addEdiAndQualifier(String edi, EdiQualifier qualifier) {
        if (StringUtils.isNotBlank((CharSequence)edi) || qualifier != null) {
            this.ediAndQualifiers.add(new EdiAndQualifier(edi, qualifier));
        }
    }

    private boolean isExcludedForTransaction(String edi) {
        String seg = StringUtils.left((String)edi, (int)3);
        String excludes = ediExcludes.get((Object)this.transactionType);
        return excludes != null && StringUtils.containsIgnoreCase((CharSequence)excludes, (CharSequence)seg);
    }

    public String codeLookupQuery() {
        if (StringUtils.isNotBlank((CharSequence)this.codeLookupQuery)) {
            return this.codeLookupQuery;
        }
        if (this.objType != ObjType.NONE && this.objType.codeType() != null) {
            return "type=" + this.objType.codeType().name();
        }
        return null;
    }

    public String toDictRow() {
        StringBuilder buf = new StringBuilder();
        DictField.appendToRow(buf, this.name, "name");
        DictField.appendToRow(buf, this.getDescriptionStr(), "desc");
        DictField.appendToRow(buf, this.typeDesc(), "type");
        DictField.appendToRow(buf, this.getEdiStr(), "edi");
        return DictField.wrapInRowTags(buf.toString());
    }

    public String getEdiStr() {
        return this.getEdiStr(false);
    }

    public String getEdiStr(boolean isSingleLine) {
        StringBuilder ediStrBuf = new StringBuilder();
        for (EdiAndQualifier ediAndQualifier : this.ediAndQualifiers) {
            if (!ediStrBuf.isEmpty()) {
                ediStrBuf.append(", ");
            }
            ediStrBuf.append(ediAndQualifier.toString());
        }
        if (ediStrBuf.isEmpty() && this.objType != ObjType.NONE) {
            ediStrBuf.append(this.objType.edi());
        }
        if (StringUtils.isNotBlank((CharSequence)this.loop)) {
            if (!ediStrBuf.isEmpty()) {
                ediStrBuf.append(isSingleLine ? "; " : "<br/>");
            }
            ediStrBuf.append("Loop: ").append(this.loop);
        }
        return ediStrBuf.toString();
    }

    private static void appendToRow(StringBuilder buf, Object value, String className) {
        DictField.appendToRowWithTags(buf, value, "<td>", "</td>", className);
    }

    private static void appendToRowWithTags(StringBuilder buf, Object value, String openTag, String closeTag, String className) {
        if (className != null) {
            openTag = StringUtils.replace((String)openTag, (String)">", (String)(" class='" + className + "'>"));
        }
        buf.append(openTag);
        if (value != null) {
            buf.append(value);
        }
        buf.append(closeTag);
    }

    public static String genTableHeader() {
        StringBuilder buf = new StringBuilder();
        for (String header : HEADERS) {
            DictField.appendToRowWithTags(buf, header, "<th>", "</th>", null);
        }
        return DictField.wrapInRowTags(buf.toString());
    }

    public static String wrapInRowTags(String row) {
        return "<tr>" + row + "</tr>\n";
    }

    public String typeDesc() {
        Object desc = "";
        if (this.type == DataType.STR) {
            desc = "String";
        } else if (this.type == DataType.INT) {
            desc = "Integer";
        } else if (this.type == DataType.BIG_DEC) {
            desc = "Number";
        } else if (this.type == DataType.DATE) {
            desc = "Date";
        } else if (this.type == DataType.DATE_TIME) {
            desc = "Date and Time";
        } else if (this.type == DataType.TIME) {
            desc = "Time";
        } else if (this.type == DataType.LIST) {
            desc = "List";
        } else if (this.type != null) {
            desc = StringUtils.capitalize((String)this.type.name().toLowerCase());
        }
        String typeName = this.typeName;
        String link = null;
        if (this.objType != ObjType.NONE) {
            typeName = this.objType.typeName();
            link = this.objType.link();
        }
        if (StringUtils.isNotBlank((CharSequence)typeName)) {
            Object typeNameStr = typeName;
            if (StringUtils.isNotBlank(link)) {
                typeNameStr = "<a href='" + link + "'>" + typeName + "</a>";
            }
            desc = this.type == DataType.LIST ? (String)desc + " of " + (String)typeNameStr : typeNameStr;
        }
        if (this.isRequired) {
            desc = (String)desc + "<br/>Required";
        }
        return desc;
    }

    public static String createDescriptionFromName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        String spaced = name.replaceAll("([a-z])([A-Z])", "$1 $2").toLowerCase();
        return StringUtils.capitalize((String)spaced);
    }

    public String getDescriptionStr() {
        String codeLookupUrl;
        Object descStr = this.desc;
        if (StringUtils.isBlank((CharSequence)descStr)) {
            descStr = DictField.createDescriptionFromName(this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)(codeLookupUrl = this.createCodeLookupUrl()))) {
            descStr = (String)descStr + "<br/>" + codeLookupUrl;
        }
        return descStr;
    }

    private String createCodeLookupUrl() {
        String query = this.codeLookupQuery();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return "<a href='https://datainsight.health/code-lookup/?" + query + "' target='_blank'>View codes and descriptions</a>";
        }
        return null;
    }

    public boolean setDesignatorAndQualifierIfMatches(SegmentType segType) {
        for (EdiAndQualifier eq : this.ediAndQualifiers) {
            EltDesignator designator = EltDesignator.fromString(eq.edi);
            if (segType != designator.segType()) continue;
            this.designator = designator;
            this.activeQualifier = eq.qualifier;
            return true;
        }
        return false;
    }

    public int pos() {
        return this.designator != null ? this.designator.pos() : -1;
    }

    public int subPos() {
        return this.designator != null ? this.designator.subPos() : -1;
    }

    public boolean isAllowedForTranType(TransactionType tranType) {
        return this.allowedTransactionTypes.isEmpty() || this.allowedTransactionTypes.contains((Object)tranType) || this.allowedTransactionTypes.contains((Object)TransactionType.ALL);
    }

    public boolean isAllowedForVariantType(VariantType variantType) {
        return this.variantTypes.contains((Object)VariantType.NONE) || this.variantTypes.isEmpty() || variantType != null && this.variantTypes.contains((Object)variantType);
    }

    @Generated
    public DictField() {
    }

    @Generated
    public TransactionType transactionType() {
        return this.transactionType;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public DataType type() {
        return this.type;
    }

    @Generated
    public int minWidth() {
        return this.minWidth;
    }

    @Generated
    public int maxWidth() {
        return this.maxWidth;
    }

    @Generated
    public ObjType objType() {
        return this.objType;
    }

    @Generated
    public String typeName() {
        return this.typeName;
    }

    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public String loop() {
        return this.loop;
    }

    @Generated
    public List<EdiAndQualifier> ediAndQualifiers() {
        return this.ediAndQualifiers;
    }

    @Generated
    public boolean isDerived() {
        return this.isDerived;
    }

    @Generated
    public Field field() {
        return this.field;
    }

    @Generated
    public EltDesignator designator() {
        return this.designator;
    }

    @Generated
    public EdiQualifier activeQualifier() {
        return this.activeQualifier;
    }

    @Generated
    public String relatedFieldName() {
        return this.relatedFieldName;
    }

    @Generated
    public boolean ignoreForEdiGen() {
        return this.ignoreForEdiGen;
    }

    @Generated
    public boolean isRequired() {
        return this.isRequired;
    }

    @Generated
    public List<TransactionType> allowedTransactionTypes() {
        return this.allowedTransactionTypes;
    }

    @Generated
    public List<VariantType> variantTypes() {
        return this.variantTypes;
    }

    @Generated
    public DictField transactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Generated
    public DictField name(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public DictField type(DataType type) {
        this.type = type;
        return this;
    }

    @Generated
    public DictField minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    @Generated
    public DictField maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    @Generated
    public DictField objType(ObjType objType) {
        this.objType = objType;
        return this;
    }

    @Generated
    public DictField typeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    @Generated
    public DictField desc(String desc) {
        this.desc = desc;
        return this;
    }

    @Generated
    public DictField loop(String loop) {
        this.loop = loop;
        return this;
    }

    @Generated
    public DictField ediAndQualifiers(List<EdiAndQualifier> ediAndQualifiers) {
        this.ediAndQualifiers = ediAndQualifiers;
        return this;
    }

    @Generated
    public DictField isDerived(boolean isDerived) {
        this.isDerived = isDerived;
        return this;
    }

    @Generated
    public DictField codeLookupQuery(String codeLookupQuery) {
        this.codeLookupQuery = codeLookupQuery;
        return this;
    }

    @Generated
    public DictField field(Field field) {
        this.field = field;
        return this;
    }

    @Generated
    public DictField designator(EltDesignator designator) {
        this.designator = designator;
        return this;
    }

    @Generated
    public DictField activeQualifier(EdiQualifier activeQualifier) {
        this.activeQualifier = activeQualifier;
        return this;
    }

    @Generated
    public DictField relatedFieldName(String relatedFieldName) {
        this.relatedFieldName = relatedFieldName;
        return this;
    }

    @Generated
    public DictField ignoreForEdiGen(boolean ignoreForEdiGen) {
        this.ignoreForEdiGen = ignoreForEdiGen;
        return this;
    }

    @Generated
    public DictField isRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @Generated
    public DictField allowedTransactionTypes(List<TransactionType> allowedTransactionTypes) {
        this.allowedTransactionTypes = allowedTransactionTypes;
        return this;
    }

    @Generated
    public DictField variantTypes(List<VariantType> variantTypes) {
        this.variantTypes = variantTypes;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictField)) {
            return false;
        }
        DictField other = (DictField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.minWidth() != other.minWidth()) {
            return false;
        }
        if (this.maxWidth() != other.maxWidth()) {
            return false;
        }
        if (this.isDerived() != other.isDerived()) {
            return false;
        }
        if (this.ignoreForEdiGen() != other.ignoreForEdiGen()) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        TransactionType this$transactionType = this.transactionType();
        TransactionType other$transactionType = other.transactionType();
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DataType this$type = this.type();
        DataType other$type = other.type();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ObjType this$objType = this.objType();
        ObjType other$objType = other.objType();
        if (this$objType == null ? other$objType != null : !((Object)((Object)this$objType)).equals((Object)other$objType)) {
            return false;
        }
        String this$typeName = this.typeName();
        String other$typeName = other.typeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$desc = this.desc();
        String other$desc = other.desc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$loop = this.loop();
        String other$loop = other.loop();
        if (this$loop == null ? other$loop != null : !this$loop.equals(other$loop)) {
            return false;
        }
        List<EdiAndQualifier> this$ediAndQualifiers = this.ediAndQualifiers();
        List<EdiAndQualifier> other$ediAndQualifiers = other.ediAndQualifiers();
        if (this$ediAndQualifiers == null ? other$ediAndQualifiers != null : !((Object)this$ediAndQualifiers).equals(other$ediAndQualifiers)) {
            return false;
        }
        String this$codeLookupQuery = this.codeLookupQuery();
        String other$codeLookupQuery = other.codeLookupQuery();
        if (this$codeLookupQuery == null ? other$codeLookupQuery != null : !this$codeLookupQuery.equals(other$codeLookupQuery)) {
            return false;
        }
        Field this$field = this.field();
        Field other$field = other.field();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        EltDesignator this$designator = this.designator();
        EltDesignator other$designator = other.designator();
        if (this$designator == null ? other$designator != null : !this$designator.equals(other$designator)) {
            return false;
        }
        EdiQualifier this$activeQualifier = this.activeQualifier();
        EdiQualifier other$activeQualifier = other.activeQualifier();
        if (this$activeQualifier == null ? other$activeQualifier != null : !this$activeQualifier.equals(other$activeQualifier)) {
            return false;
        }
        String this$relatedFieldName = this.relatedFieldName();
        String other$relatedFieldName = other.relatedFieldName();
        if (this$relatedFieldName == null ? other$relatedFieldName != null : !this$relatedFieldName.equals(other$relatedFieldName)) {
            return false;
        }
        List<TransactionType> this$allowedTransactionTypes = this.allowedTransactionTypes();
        List<TransactionType> other$allowedTransactionTypes = other.allowedTransactionTypes();
        if (this$allowedTransactionTypes == null ? other$allowedTransactionTypes != null : !((Object)this$allowedTransactionTypes).equals(other$allowedTransactionTypes)) {
            return false;
        }
        List<VariantType> this$variantTypes = this.variantTypes();
        List<VariantType> other$variantTypes = other.variantTypes();
        return !(this$variantTypes == null ? other$variantTypes != null : !((Object)this$variantTypes).equals(other$variantTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DictField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.minWidth();
        result = result * 59 + this.maxWidth();
        result = result * 59 + (this.isDerived() ? 79 : 97);
        result = result * 59 + (this.ignoreForEdiGen() ? 79 : 97);
        result = result * 59 + (this.isRequired() ? 79 : 97);
        TransactionType $transactionType = this.transactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DataType $type = this.type();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ObjType $objType = this.objType();
        result = result * 59 + ($objType == null ? 43 : ((Object)((Object)$objType)).hashCode());
        String $typeName = this.typeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $desc = this.desc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $loop = this.loop();
        result = result * 59 + ($loop == null ? 43 : $loop.hashCode());
        List<EdiAndQualifier> $ediAndQualifiers = this.ediAndQualifiers();
        result = result * 59 + ($ediAndQualifiers == null ? 43 : ((Object)$ediAndQualifiers).hashCode());
        String $codeLookupQuery = this.codeLookupQuery();
        result = result * 59 + ($codeLookupQuery == null ? 43 : $codeLookupQuery.hashCode());
        Field $field = this.field();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        EltDesignator $designator = this.designator();
        result = result * 59 + ($designator == null ? 43 : $designator.hashCode());
        EdiQualifier $activeQualifier = this.activeQualifier();
        result = result * 59 + ($activeQualifier == null ? 43 : $activeQualifier.hashCode());
        String $relatedFieldName = this.relatedFieldName();
        result = result * 59 + ($relatedFieldName == null ? 43 : $relatedFieldName.hashCode());
        List<TransactionType> $allowedTransactionTypes = this.allowedTransactionTypes();
        result = result * 59 + ($allowedTransactionTypes == null ? 43 : ((Object)$allowedTransactionTypes).hashCode());
        List<VariantType> $variantTypes = this.variantTypes();
        result = result * 59 + ($variantTypes == null ? 43 : ((Object)$variantTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DictField(transactionType=" + String.valueOf((Object)this.transactionType()) + ", name=" + this.name() + ", type=" + String.valueOf((Object)this.type()) + ", minWidth=" + this.minWidth() + ", maxWidth=" + this.maxWidth() + ", objType=" + String.valueOf((Object)this.objType()) + ", typeName=" + this.typeName() + ", desc=" + this.desc() + ", loop=" + this.loop() + ", ediAndQualifiers=" + String.valueOf(this.ediAndQualifiers()) + ", isDerived=" + this.isDerived() + ", codeLookupQuery=" + this.codeLookupQuery() + ", field=" + String.valueOf(this.field()) + ", designator=" + String.valueOf(this.designator()) + ", activeQualifier=" + String.valueOf(this.activeQualifier()) + ", relatedFieldName=" + this.relatedFieldName() + ", ignoreForEdiGen=" + this.ignoreForEdiGen() + ", isRequired=" + this.isRequired() + ", allowedTransactionTypes=" + String.valueOf(this.allowedTransactionTypes()) + ", variantTypes=" + String.valueOf(this.variantTypes()) + ")";
    }

    public record EdiAndQualifier(String edi, EdiQualifier qualifier) {
        @Override
        @NotNull
        public String toString() {
            Object s = "";
            if (StringUtils.isNotBlank((CharSequence)this.edi)) {
                s = (String)s + this.edi;
            }
            if (this.qualifier != null) {
                s = (String)s + " *" + this.qualifier.ediValue();
            }
            return s;
        }
    }
}

