/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.csv.CsvUtils;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.model.Amount;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.ServiceLine;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.payment.Adjustment;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2110"}, seg={"SVC"})
public class PaymentLineCsv {
    @Prop(refType={ReferenceType.PROVIDER_CONTROL_NUMBER}, desc={"Line item control number from 837"})
    private String controlNumber;
    @Prop(edi={"SVC01"}, desc={"Adjudicated procedure code"}, objType=ObjType.PROCEDURE, procType={ProcType.HCPCS, ProcType.ADA, ProcType.ABC, ProcType.HIEC}, codeLookupQuery="type=procedure")
    private CodeEntity procedure;
    @Prop(edi={"SVC01", "SVC04"}, desc={"Adjudicated revenue code"}, objType=ObjType.REV_CODE, ubType={UbCodeType.REVENUE_CODE})
    private String revenueCode;
    @Prop(edi={"SVC01"}, desc={"Adjudicated drug code (NDC)"}, codeLookupQuery="type=drug")
    private String drugCode;
    @Prop(edi={"SVC02"})
    private BigDecimal chargeAmount;
    @Prop(masterClass=ServiceLine.class)
    private BigDecimal paidAmount;
    @Prop(edi={"SVC05"})
    private BigDecimal unitCount;
    @Prop(masterClass=ServiceLine.class)
    private CodeEntity originalProcedure;
    @Prop(masterClass=ServiceLine.class)
    private String originalRevenueCode;
    @Prop(masterClass=ServiceLine.class, fieldName="originalDrug")
    private String originalDrugCode;
    @Prop(edi={"SVC07"})
    private BigDecimal originalUnitCount;
    @Prop(dateType={DateType.SERVICE, DateType.SERVICE_PERIOD_START}, desc={"Service period start date"})
    private LocalDate serviceDateFrom;
    @Prop(dateType={DateType.SERVICE_PERIOD_END}, desc={"Service period end date. If not provided in EDI (single day), it is set to 'serviceDateFrom' "})
    private LocalDate serviceDateTo;
    @Prop(isDerived=true, desc={"Sum total of all adjustments for this service line"})
    private BigDecimal totalAdjAmount;
    @Prop(desc={"Line adjustments"}, edi={"CAS"}, objType=ObjType.ADJUSTMENT)
    private List<Adjustment> adjs;
    @Prop(masterClass=ServiceLine.class)
    private List<Reference> serviceIds;
    @Prop(refType={ReferenceType.HEALTHCARE_POLICY_IDENTIFICATION})
    private String healthcarePolicyId;
    @Prop(masterClass=ServiceLine.class)
    private List<Reference> renderingProviderIds;
    @Prop(isDerived=true, desc={"Allowed amount -- this is one of the amounts from the list of supplemental amounts"})
    private BigDecimal allowedAmount;
    @Prop(masterClass=ServiceLine.class, fieldName="supplementalAmounts")
    private List<Amount> supplementalAmts;
    @Prop(masterClass=ServiceLine.class, fieldName="supplementalQuantities")
    private List<Quantity> supplementalQties;
    @Prop(masterClass=ServiceLine.class)
    private List<String> remarkCodes;

    public PaymentLineCsv() {
        this(new ServiceLine());
    }

    public PaymentLineCsv(ServiceLine line) {
        this.chargeAmount = line.chargeAmount();
        this.paidAmount = line.paidAmount();
        this.unitCount = line.unitCount();
        this.originalUnitCount = line.originalUnitCount();
        this.serviceDateFrom = line.serviceDateFrom();
        this.serviceDateTo = line.serviceDateTo();
        this.healthcarePolicyId = line.healthcarePolicyId();
        this.procedure = CsvUtils.prepCodeEnt(line.procedure(), PrimaryCodeType.PROCEDURE);
        this.drugCode = CsvUtils.codeFromCodeEnt(line.drug());
        this.revenueCode = CsvUtils.codeFromCodeEnt(line.revenueCode());
        this.originalProcedure = CsvUtils.prepCodeEnt(line.originalProcedure(), PrimaryCodeType.PROCEDURE);
        this.originalDrugCode = CsvUtils.codeFromCodeEnt(line.originalDrug());
        this.originalRevenueCode = CsvUtils.codeFromCodeEnt(line.originalRevenueCode());
        this.totalAdjAmount = line.getTotalAdjustmentAmount();
        this.allowedAmount = line.getAllowedAmount();
        this.adjs = CsvUtils.prepList(line.adjustments(), new Adjustment());
        this.controlNumber = line.sourceLineId();
        this.serviceIds = CsvUtils.prepList(line.serviceIds(), new Reference());
        this.renderingProviderIds = CsvUtils.prepList(line.renderingProviderIds(), new Reference());
        this.supplementalAmts = CsvUtils.prepList(line.supplementalAmounts(), new Amount());
        this.supplementalQties = CsvUtils.prepList(line.supplementalQuantities(), new Quantity());
        this.remarkCodes = CsvUtils.prepList(line.remarkCodes(), null);
    }

    @Generated
    public String toString() {
        return "PaymentLineCsv(controlNumber=" + this.controlNumber + ", procedure=" + String.valueOf(this.procedure) + ", revenueCode=" + this.revenueCode + ", drugCode=" + this.drugCode + ", chargeAmount=" + String.valueOf(this.chargeAmount) + ", paidAmount=" + String.valueOf(this.paidAmount) + ", unitCount=" + String.valueOf(this.unitCount) + ", originalProcedure=" + String.valueOf(this.originalProcedure) + ", originalRevenueCode=" + this.originalRevenueCode + ", originalDrugCode=" + this.originalDrugCode + ", originalUnitCount=" + String.valueOf(this.originalUnitCount) + ", serviceDateFrom=" + String.valueOf(this.serviceDateFrom) + ", serviceDateTo=" + String.valueOf(this.serviceDateTo) + ", totalAdjAmount=" + String.valueOf(this.totalAdjAmount) + ", adjs=" + String.valueOf(this.adjs) + ", serviceIds=" + String.valueOf(this.serviceIds) + ", healthcarePolicyId=" + this.healthcarePolicyId + ", renderingProviderIds=" + String.valueOf(this.renderingProviderIds) + ", allowedAmount=" + String.valueOf(this.allowedAmount) + ", supplementalAmts=" + String.valueOf(this.supplementalAmts) + ", supplementalQties=" + String.valueOf(this.supplementalQties) + ", remarkCodes=" + String.valueOf(this.remarkCodes) + ")";
    }
}

