/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.csv.CsvUtils;
import hdi.edi.csv.PaymentLineCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.parser.TransactionType;
import hdi.model.Amount;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.ServiceLine;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.DateType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.Adjustment;
import hdi.model.payment.ClaimStatus;
import hdi.model.payment.Payment;
import hdi.model.payment.PaymentMethodType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2100"}, seg={"CLP"}, csvExample={"835/835-all-fields"}, interactiveExample={"payments/comprehensive/"})
public class PaymentCsv {
    @Prop(isDerived=true, desc={"Unique payment identifier assigned by the converter"})
    private String id;
    @Prop(edi={"ST01"}, desc={"Transaction set identifier code"})
    private final String transactionType = TransactionType.PAYMENT.ediCode();
    @Prop(isDerived=true, desc={"Converted X12 EDI file name"})
    private String fileName;
    @Prop(edi={"ST02"}, desc={"Transaction set control number"})
    private String transactionControlNumber;
    @Prop(desc={"Identifier used to track a claim from creation by the health care provider through payment"}, edi={"CLP01"})
    private String patientControlNumber;
    @Prop(masterClass=PaymentCsv.class)
    private ClaimStatus claimStatus;
    @Prop(edi={"CLP03"})
    private BigDecimal chargeAmount;
    @Prop(edi={"CLP04"})
    private BigDecimal paymentAmount;
    @Prop(edi={"CLP05"})
    private BigDecimal patientResponsibilityAmount;
    @Prop(edi={"CLP06"})
    private String claimFilingIndicatorCode;
    @Prop(edi={"CLP07"})
    private String payerControlNumber;
    @Prop(edi={"CLP08"}, objType=ObjType.FACILITY, desc={"Place of service code (professional/dental) or UB facility code (institutional) from the original claim"})
    private CodeEntity facility;
    @Prop(edi={"CLP09"}, codeLookupQuery="type=frequency_code")
    private String frequencyTypeCode;
    @Prop(edi={"CLP11"}, desc={"Diagnosis-related group code. Institutional claims only."})
    private String drgCode;
    @Prop(edi={"CLP12"}, desc={"Adjudicated DRG weight. Institutional claims only."})
    private BigDecimal drgWeight;
    @Prop(edi={"CLP13"}, desc={"Adjudicated discharge fraction. Institutional claims only. This is a percentage expressed as decimal."})
    private BigDecimal dischargeFraction;
    @Prop(edi={"BPR02"})
    private BigDecimal totalPaymentAmount;
    @Prop(edi={"BPR03"})
    private String creditOrDebitFlagCode;
    @Prop(edi={"BPR04"})
    private PaymentMethodType paymentMethodType;
    @Prop(edi={"BPR15"})
    private String receiverAccountNumber;
    @Prop(edi={"BPR16"})
    private LocalDate paymentDate;
    @Prop(edi={"TRN02"})
    private String checkOrEftTraceNumber;
    @Prop(edi={"TRN03"}, desc={"Payer identifier. This must be a '1' followed by the payer EIN. This field is also copied to the payerIdentifier field if it wasn't provided in N104."})
    private String payerEin;
    @Prop(dateType={DateType.PRODUCTION})
    private LocalDate productionDate;
    @Prop(isDerived=true, desc={"Sum total of all adjustments from all service lines"})
    private BigDecimal totalAdjAmount;
    @Prop(desc={"Claim adjustments"}, edi={"CAS"}, objType=ObjType.ADJUSTMENT)
    private final List<Adjustment> adjs;
    @Prop(edi={"N1"}, entityRole=EntityRole.PAYER, objType=ObjType.PARTY)
    private final OrgOrPerson payer;
    @Prop(edi={"N1"}, entityRole=EntityRole.PAYEE, objType=ObjType.PARTY)
    private final OrgOrPerson payee;
    @Prop(entityRole=EntityRole.PATIENT, objType=ObjType.PARTY_ID_NAME, desc={"The insured (subscriber) or patient from the original claim"})
    private OrgOrPerson patient;
    @Prop(entityRole=EntityRole.SUBSCRIBER, objType=ObjType.PARTY_ID_NAME, desc={"The insured (subscriber) from the original claim if the insured is different from the patient"})
    private OrgOrPerson subscriber;
    @Prop(entityRole=EntityRole.CORRECTED_INSURED, objType=ObjType.PARTY_ID_NAME)
    private OrgOrPerson correctedPatient;
    @Prop(entityRole=EntityRole.SERVICE_PROVIDER, objType=ObjType.PARTY_ID_NAME)
    private final OrgOrPerson serviceProvider;
    @Prop(entityRole=EntityRole.CROSSOVER_CARRIER, objType=ObjType.PARTY_ID_NAME)
    private final OrgOrPerson crossoverCarrier;
    @Prop(entityRole=EntityRole.PAYER, desc={"Corrected priority payer, meaning that current payer believes that another payer has priority for making a payment"}, objType=ObjType.PARTY_ID_NAME)
    private final OrgOrPerson correctedPayer;
    @Prop(entityRole=EntityRole.OTHER_SUBSCRIBER, objType=ObjType.PARTY_ID_NAME)
    private final OrgOrPerson otherSubscriber;
    @Prop(desc={"Other claim-related identifications"}, edi={"REF"}, objType=ObjType.REFERENCE)
    private List<Reference> otherClaimRelatedIds;
    @Prop(isDerived=true, desc={"The earliest service date from service lines"})
    private LocalDate serviceDateFrom;
    @Prop(isDerived=true, desc={"The latest service date from service lines"})
    private LocalDate serviceDateTo;
    @Prop(dateType={DateType.STATEMENT_PERIOD_START})
    private LocalDate statementDateFrom;
    @Prop(dateType={DateType.STATEMENT_PERIOD_END})
    private LocalDate statementDateTo;
    @Prop(dateType={DateType.EXPIRATION})
    private LocalDate coverageExpirationDate;
    @Prop(dateType={DateType.RECEIVED})
    private LocalDate claimReceivedDate;
    @Prop(amtType=AmountType.COVERAGE_AMOUNT, desc={"Coverage amount from the list of supplemental amounts"})
    private BigDecimal coverageAmount;
    @Prop(desc={"Supplemental claim/payment amounts, such as coverage amount, discount amount, etc."}, edi={"AMT"}, objType=ObjType.AMOUNT)
    private final List<Amount> supplementalAmts;
    @Prop(desc={"Supplemental claim/payment quantities"}, edi={"QTY"}, objType=ObjType.QUANTITY)
    private final List<Quantity> supplementalQties;
    @Prop(desc={"Service payment information"}, loop={"835:2110", "837:2400"}, objType=ObjType.PAYMENT_LINE_CSV)
    private List<PaymentLineCsv> lines;

    public PaymentCsv() {
        this(new Payment());
    }

    public PaymentCsv(Payment payment) {
        if (payment.transaction().fileInfo() != null) {
            this.fileName = payment.transaction().fileInfo().name();
        }
        this.transactionControlNumber = payment.transaction().controlNumber();
        this.payerControlNumber = payment.payerControlNumber();
        this.claimStatus = payment.claimStatus();
        BigDecimal number = this.chargeAmount = payment.chargeAmount();
        this.paymentAmount = payment.paymentAmount();
        this.patientResponsibilityAmount = payment.patientResponsibilityAmount();
        this.claimFilingIndicatorCode = payment.claimFilingIndicatorCode();
        this.patientControlNumber = payment.patientControlNumber();
        this.frequencyTypeCode = CsvUtils.codeFromCodeEnt(payment.frequencyCode());
        this.facility = CsvUtils.prepCodeEnt(payment.facilityCode(), PrimaryCodeType.FACILITY_TYPE);
        this.drgCode = CsvUtils.codeFromCodeEnt(payment.drg());
        this.drgWeight = payment.drgWeight();
        this.dischargeFraction = payment.dischargeFraction();
        this.totalPaymentAmount = payment.transaction().totalPaymentAmount();
        this.creditOrDebitFlagCode = payment.transaction().creditOrDebitFlagCode();
        this.paymentMethodType = payment.transaction().paymentMethodType();
        this.receiverAccountNumber = payment.transaction().receiverAccountNumber();
        this.paymentDate = payment.transaction().paymentDate();
        this.checkOrEftTraceNumber = payment.transaction().checkOrEftTraceNumber();
        this.payerEin = payment.transaction().payerIdentifier();
        this.productionDate = payment.transaction().productionDate();
        this.payer = CsvUtils.prepOrgOrPerson(payment.payer(), EntityRole.PAYER);
        this.payee = CsvUtils.prepOrgOrPerson(payment.payee(), EntityRole.PAYEE);
        this.serviceProvider = CsvUtils.prepOrgOrPerson(payment.serviceProvider(), EntityRole.RENDERING);
        this.crossoverCarrier = CsvUtils.prepOrgOrPerson(payment.crossoverCarrier(), EntityRole.CROSSOVER_CARRIER);
        this.correctedPayer = CsvUtils.prepOrgOrPerson(payment.correctedPayer(), EntityRole.PAYER);
        this.otherSubscriber = CsvUtils.prepOrgOrPerson(payment.otherSubscriber(), EntityRole.OTHER_SUBSCRIBER);
        this.patient = this.prepOptionalPatSub(payment.patient(), EntityRole.PATIENT);
        this.subscriber = this.prepOptionalPatSub(payment.subscriber(), EntityRole.SUBSCRIBER);
        this.correctedPatient = CsvUtils.prepOrgOrPerson(payment.correctedInsured(), EntityRole.CORRECTED_INSURED);
        this.lines = this.prepLines(payment.lines());
        this.otherClaimRelatedIds = CsvUtils.prepReferenceList(this.otherClaimRelatedIds);
        this.serviceDateFrom = payment.serviceDateFrom();
        this.serviceDateTo = payment.serviceDateTo();
        this.statementDateFrom = payment.statementDateFrom();
        this.statementDateTo = payment.statementDateTo();
        this.coverageExpirationDate = payment.coverageExpirationDate();
        this.claimReceivedDate = payment.claimReceivedDate();
        this.coverageAmount = payment.getCoverageAmount();
        this.supplementalAmts = CsvUtils.prepList(payment.supplementalAmounts(), new Amount());
        this.supplementalQties = CsvUtils.prepList(payment.supplementalQuantities(), new Quantity());
        this.totalAdjAmount = payment.getTotalAdjustmentAmount();
        this.adjs = CsvUtils.prepList(payment.adjustments(), new Adjustment());
    }

    private List<PaymentLineCsv> prepLines(List<ServiceLine> serviceLines) {
        List<PaymentLineCsv> lines;
        if (serviceLines == null || serviceLines.isEmpty()) {
            lines = CsvUtils.prepList(null, new PaymentLineCsv());
        } else {
            lines = new ArrayList<PaymentLineCsv>();
            for (ServiceLine serviceLine : serviceLines) {
                PaymentLineCsv lineCsv = new PaymentLineCsv(serviceLine);
                lines.add(lineCsv);
            }
        }
        return lines;
    }

    private OrgOrPerson prepOptionalPatSub(PatientSubscriber patientSubscriber, EntityRole entityRole) {
        OrgOrPerson person = patientSubscriber == null || patientSubscriber.person() == null ? new OrgOrPerson() : patientSubscriber.person();
        return person;
    }

    @Generated
    public PaymentCsv id(String id) {
        this.id = id;
        return this;
    }
}

