/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineColumnCounter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineColumnCounter.class);
    private String delim = ",";

    /*
     * Enabled aggressive exception aggregation
     */
    public Counts count(File inputFile) {
        try (FileReader fileReader = new FileReader(inputFile);){
            Counts counts;
            try (BufferedReader bufFileReader = new BufferedReader(fileReader);){
                counts = this.count(bufFileReader, inputFile.getName());
            }
            return counts;
        }
    }

    public Counts count(String s) {
        return this.count(new BufferedReader(new StringReader(s)), "String input");
    }

    public Counts count(BufferedReader reader, String name) {
        String inputLine;
        int lineCounter = 0;
        ArrayList<ColCount> colCounts = new ArrayList<ColCount>();
        while ((inputLine = reader.readLine()) != null) {
            int numberOfColumns = StringUtils.countMatches((CharSequence)inputLine, (CharSequence)this.delim) + 1;
            colCounts.add(new ColCount(lineCounter, numberOfColumns));
            ++lineCounter;
        }
        log.debug("Finished counting lines in the file {}. Number of lines: {}", (Object)name, (Object)lineCounter);
        return new Counts(lineCounter, colCounts);
    }

    @Generated
    public LineColumnCounter delim(String delim) {
        this.delim = delim;
        return this;
    }

    public record Counts(int lineCount, List<ColCount> colCounts) {
        public boolean isColCountDifferent() {
            boolean isFailed;
            int minNumberOfCols = -1;
            int maxNumberOfCols = -1;
            for (ColCount colCount : this.colCounts) {
                if (colCount.columnCount < minNumberOfCols || minNumberOfCols < 0) {
                    minNumberOfCols = colCount.columnCount;
                }
                if (colCount.columnCount <= maxNumberOfCols) continue;
                maxNumberOfCols = colCount.columnCount;
            }
            boolean bl = isFailed = minNumberOfCols != maxNumberOfCols;
            if (isFailed) {
                System.err.println("Different column counts encountered. Min: " + minNumberOfCols + " Max: " + maxNumberOfCols);
                for (ColCount colCount : this.colCounts) {
                    System.err.println(colCount);
                }
            }
            return isFailed;
        }

        public int colCount() {
            if (this.colCounts.isEmpty()) {
                throw new IllegalStateException("The file is blank");
            }
            return this.colCounts.get((int)0).columnCount;
        }
    }

    public record ColCount(int lineNumber, int columnCount) {
    }
}

