/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.CsvConversionException;
import hdi.edi.csv.CsvConversionResults;
import hdi.edi.csv.ListConversionMeta;
import hdi.edi.csv.ListConversionSchema;
import hdi.edi.csv.ListConversionStrategy;
import hdi.edi.csv.ObjectConversionSchema;
import hdi.edi.csv.PathContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class JsonToCsvConverter {
    private boolean isMetadataMode;
    private final ConversionSchema conversionSchema;

    public CsvConversionResults createHeaders(ObjectNode rootNode) {
        return this.convertValues(rootNode, new PathContext(), true);
    }

    public CsvConversionResults convertJson(ObjectNode rootNode) {
        return this.convertValues(rootNode, new PathContext(), false);
    }

    private CsvConversionResults convertValues(ObjectNode rootNode, PathContext pathContext, boolean isHeaderMode) {
        CsvConversionResults results = new CsvConversionResults();
        this.convertJsonObj(results, results.rootValues(), this.conversionSchema.getListMeta("Main"), pathContext, null, null, rootNode, isHeaderMode);
        return results;
    }

    private void convertJsonObj(CsvConversionResults results, List<Object> values, ListConversionMeta listMeta, PathContext pathContext, String path, String nodeKey, ObjectNode parentObjectNode, boolean isHeaderMode) {
        ObjectConversionSchema objectSchema = this.conversionSchema.getObjectSchema(listMeta.name(), nodeKey);
        if (nodeKey != null) {
            pathContext = pathContext.appendToPath(nodeKey);
        }
        Iterator fields = parentObjectNode.fields();
        while (fields.hasNext()) {
            Map.Entry keyAndNode = (Map.Entry)fields.next();
            String fieldName = (String)keyAndNode.getKey();
            if (!objectSchema.isFieldIncluded(fieldName) || objectSchema.isFieldExcluded(fieldName)) continue;
            this.convertNode(results, values, listMeta, pathContext, path, fieldName, fieldName, (JsonNode)keyAndNode.getValue(), isHeaderMode);
        }
    }

    private void convertNode(CsvConversionResults results, List<Object> values, ListConversionMeta listMeta, PathContext pathContext, String parentPath, String nodePath, String nodeKey, JsonNode node, boolean isHeaderMode) {
        String path = this.appendToPath(parentPath, nodePath);
        if (!listMeta.isExcluded(path, isHeaderMode)) {
            if (node instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)node;
                this.convertJsonObj(results, values, listMeta, pathContext, path, nodeKey, objectNode, isHeaderMode);
            } else if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                this.convertJsonArray(results, values, listMeta, pathContext, path, nodeKey, arrayNode, isHeaderMode);
            } else if (listMeta.isIncluded(path, isHeaderMode)) {
                pathContext = pathContext.appendToPath(nodePath);
                pathContext.path(path);
                Object val = isHeaderMode ? path : this.extractValue(node);
                if (listMeta.isRepeatedFirst(path, isHeaderMode)) {
                    results.addRepeatedField(listMeta.name(), val);
                }
                if (isHeaderMode && this.isMetadataMode) {
                    val = pathContext;
                }
                values.add(val);
            }
        }
    }

    private Object extractValue(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        Object val = node.isNumber() ? node.numberValue() : node.asText();
        return val;
    }

    private void convertJsonArray(CsvConversionResults results, List<Object> parentValues, ListConversionMeta parentListMeta, PathContext pathContext, String path, String nodeKey, ArrayNode arrayNode, boolean isHeaderMode) {
        ListConversionSchema listSchema = this.conversionSchema.getListSchema(path);
        Iterator iter = arrayNode.elements();
        pathContext = pathContext.appendToPath(nodeKey);
        nodeKey = this.depluralize(nodeKey);
        if (listSchema.strategy() == ListConversionStrategy.ROWS) {
            this.convertArrayAsRows(results, parentListMeta, pathContext, path, nodeKey, isHeaderMode, iter);
        } else {
            String listPrefix = this.getListPrefixAndSetIfNull(path);
            int nColGroupRepeat = listSchema.numberOfColumnRepeats();
            JsonNode nodeForHeader = null;
            if (isHeaderMode) {
                nodeForHeader = (JsonNode)iter.next();
            }
            List<Object> values = parentValues;
            for (int i = 0; i < nColGroupRepeat; ++i) {
                String colIndex;
                String string = colIndex = nColGroupRepeat > 1 ? Integer.toString(i + 1) : "";
                if (nodeForHeader != null) {
                    this.convertNode(results, values, parentListMeta, pathContext, listPrefix, colIndex, nodeKey, nodeForHeader, true);
                    this.conversionSchema.headerJsonForLists().put(listPrefix, nodeForHeader);
                    continue;
                }
                JsonNode emptyObject = this.conversionSchema.headerJsonForLists().get(listPrefix);
                if (emptyObject == null) {
                    throw new CsvConversionException("List '%s' was not included in the header, don't know how to convert items from this list.", path);
                }
                JsonNode objToConvert = iter.hasNext() ? (JsonNode)iter.next() : emptyObject;
                this.convertNode(results, values, parentListMeta, pathContext, listPrefix, colIndex, nodeKey, objToConvert, isHeaderMode);
            }
        }
    }

    private void convertArrayAsRows(CsvConversionResults results, ListConversionMeta parentListMeta, PathContext pathContext, String path, String nodeKey, boolean isHeaderMode, Iterator<JsonNode> arrayIter) {
        int rowI = 0;
        while (arrayIter.hasNext()) {
            results.clearRepeatedValues(path);
            ArrayList<Object> values = new ArrayList<Object>();
            String listPrefix = this.getListPrefixAndSetIfNull(path);
            this.convertNode(results, values, this.conversionSchema.getListMeta(path), pathContext, listPrefix, "", nodeKey, arrayIter.next(), isHeaderMode);
            List<Object> repeatedValues = this.getRepeatedValuesForList(parentListMeta, results, rowI);
            ArrayList<Object> valuesWithParentVals = new ArrayList<Object>(repeatedValues);
            valuesWithParentVals.addAll(values);
            results.add(path, valuesWithParentVals);
            if (isHeaderMode) break;
            ++rowI;
        }
    }

    private String getListPrefixAndSetIfNull(String listName) {
        ListConversionMeta listMeta = this.conversionSchema.getListMeta(listName);
        String listPrefix = listMeta.prefix();
        if (listPrefix == null) {
            listPrefix = this.depluralize(listName);
            listMeta.prefix(listPrefix);
        }
        return listPrefix;
    }

    private List<Object> getRepeatedValuesForList(ListConversionMeta parentListMeta, CsvConversionResults results, int iRow) {
        List<Object> repeatedValues = results.getRepeatedValues(parentListMeta.name());
        if (iRow > 0) {
            int i = 0;
            ArrayList<Object> allRowsRepeatedValues = new ArrayList<Object>();
            for (Object val : repeatedValues) {
                if (parentListMeta.isRepeatedAllRows(i)) {
                    allRowsRepeatedValues.add(val);
                } else {
                    allRowsRepeatedValues.add(null);
                }
                ++i;
            }
            repeatedValues = allRowsRepeatedValues;
        }
        return repeatedValues;
    }

    private void addNullValues(List<Object> results, int n) {
        for (int i = 0; i < n; ++i) {
            results.add(null);
        }
    }

    private String appendToPath(String path, String key) {
        key = this.adjustKey((String)path, key);
        path = StringUtils.isNotBlank((CharSequence)path) ? (String)path + this.conversionSchema.pathDelimiter() : "";
        return (String)path + StringUtils.capitalize((String)key);
    }

    private String adjustKey(String prefix, String key) {
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Person")) {
            key = "";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"LastNameOrOrgName")) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])new CharSequence[]{"Subscriber", "OtherSubscriber", "Patient", "CorrectedPatient", "member", "IncorrectMember", "custodialParent"}) || StringUtils.startsWithAny((CharSequence)prefix, (CharSequence[])new CharSequence[]{"ResponsiblePerson"})) {
                key = "lastName";
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])new CharSequence[]{"Payer", "CorrectedPayer", "CrossoverCarrier", "ServiceFacility", "LineServiceFacility", "SubscriberPayer", "OtherSubscriberPayer", "Sponsor", "Insurer", "School"}) || StringUtils.startsWithAny((CharSequence)prefix, (CharSequence[])new CharSequence[]{"Tpa", "School"}) || StringUtils.containsIgnoreCase((CharSequence)prefix, (CharSequence)"HealthCoverageCob") && StringUtils.containsIgnoreCase((CharSequence)prefix, (CharSequence)"Insurer")) {
                key = "Name";
            }
        }
        return key;
    }

    private String depluralize(String name) {
        if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"uantities")) {
            name = StringUtils.replace((String)name, (String)"uantities", (String)"uantity");
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"Qties")) {
            name = StringUtils.replace((String)name, (String)"Qties", (String)"Qty");
        } else if (StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"Disabilitie"})) {
            name = StringUtils.replace((String)name, (String)"Disabilitie", (String)"Disability");
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"Categories")) {
            name = StringUtils.replace((String)name, (String)"Categories", (String)"Category");
        }
        if (StringUtils.endsWith((CharSequence)name, (CharSequence)"s")) {
            name = StringUtils.left((String)name, (int)(name.length() - 1));
        }
        return name;
    }

    @Generated
    public boolean isMetadataMode() {
        return this.isMetadataMode;
    }

    @Generated
    public ConversionSchema conversionSchema() {
        return this.conversionSchema;
    }

    @Generated
    public JsonToCsvConverter(ConversionSchema conversionSchema) {
        this.conversionSchema = conversionSchema;
    }

    @Generated
    public JsonToCsvConverter isMetadataMode(boolean isMetadataMode) {
        this.isMetadataMode = isMetadataMode;
        return this;
    }
}

