/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.edi.csv.ClaimCsv;
import hdi.edi.csv.ClaimLineCsv;
import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.CsvUtils;
import hdi.edi.csv.ObjectConversionSchema;
import hdi.edi.dict.DictMgr;
import hdi.edi.parser.TransactionType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class IncludedExcludedFields {
    private static final Set<String> globalExcludedFields = Set.of("ObjectType", "*provider*gender*", "*provider*BirthDate*", "*pay*gender*", "*Pay*BirthDate", "*pa*taxonomy*", "*entityRole*", "*taxonomyType*", "*desc", "*Categories", "*Procedure*Type", "*Procedure*Amount", "*ProcedureModifier*Modifiers", "*Adj*Reason", "*ChangeReason", "*Contact*FunctionCode");
    private static final String billingProvExcludedFields = "EntityType, CommunicationNumber";
    private static final String payerPayeeExcludedFields = "EntityType, TaxId, FirstName, MiddleName";
    private static final String paymentPatSubProvExcludedFields = "EntityType,AdditionalIds,TaxId,ContactName,CommunicationNumber,Address, ProviderTaxonomy,BirthDate,Gender, contacts";
    private static final String paymentCrossoverExcludedFields = "EntityType, TaxId, FirstName, MiddleName,EntityType,AdditionalIds,TaxId,ContactName,CommunicationNumber,Address, ProviderTaxonomy,BirthDate,Gender, contacts";
    private static final String paymentRenderingProvExcludedFields = "EntityType,TaxId,ContactName,CommunicationNumber, Address, ProviderTaxonomy,BirthDate,Gender";
    private static final String codeEntAlwaysExcluded = "EnumName, Type,subType,DescFromClaim, Amount,FormattedCode, OccurrenceDate, occurrenceEndDate, PresentOnAdmissionIndicator, amount, IssuingOrg, StartDate, EndDate, DescFromClaim, fullDesc, ShortDesc, instructionDesc, desc";
    private static final String subscriberExcluded = "insurancePlanType, PayerContact*, PayerClaimControlNumber,payerPaidAmount, nonCoveredAmount, remainingPatientLiabilityAmount,adjustment*,provider*,AdditionalIds,PayerFirstName, PayerMiddleName,*CommunicationNumber,*ProviderTaxonomy,*EntityType,PayerPriorAuthorizationNumber,PayerReferralNumber,PayerPredeterminationOfBenefitsIdentifier,propertyCasualtyClaimNumber,inpatientAdjudication,outpatientAdjudication";
    private static final String subscriber837Excluded = "insurancePlanType, PayerContact*, PayerClaimControlNumber,payerPaidAmount, nonCoveredAmount, remainingPatientLiabilityAmount,adjustment*,provider*,AdditionalIds,PayerFirstName, PayerMiddleName,*CommunicationNumber,*ProviderTaxonomy,*EntityType,PayerPriorAuthorizationNumber,PayerReferralNumber,PayerPredeterminationOfBenefitsIdentifier,propertyCasualtyClaimNumber,inpatientAdjudication,outpatientAdjudication,Contacts,*ContactName,";
    private static final String patientExcluded = "insurancePlanType, PayerContact*, PayerClaimControlNumber,payerPaidAmount, nonCoveredAmount, remainingPatientLiabilityAmount,adjustment*,provider*,AdditionalIds,PayerFirstName, PayerMiddleName,*CommunicationNumber,*ProviderTaxonomy,*EntityType,PayerPriorAuthorizationNumber,PayerReferralNumber,PayerPredeterminationOfBenefitsIdentifier,propertyCasualtyClaimNumber,inpatientAdjudication,outpatientAdjudication,Contacts,*ContactName,,IdentificationType,Identifier,payer*,*taxId, GroupOrPolicyNumber, GroupName,ClaimFilingIndicatorCode ";
    private static final String otherSubExcluded = "insurancePlanType, PayerContact*, Contacts, provider*,AdditionalIds,PayerFirstName, PayerMiddleName,*CommunicationNumber,*ContactName,EntityType,*ProviderTaxonomy,*EntityType,*BirthDate,*Gender,*DeathDate,*Weight,*pregnancy*,Adjustment*Reason,PayerPriorAuthorizationNumber,PayerReferralNumber,PayerPredeterminationOfBenefitsIdentifier,propertyCasualtyClaimNumber,inpatientAdjudication,outpatientAdjudication";
    private static final String Tran834GlobalExcludes = "SupplementalIdentifier?Type";
    private static final String providerNameFields = "identifier,lastNameOrOrgName,firstName,middleName";
    private static final ObjectConversionSchema DEFAULT_PROVIDER_OBJECT_CONVERSION_SCHEMA = new ObjectConversionSchema("identifier,lastNameOrOrgName,firstName,middleName,additionalIds");
    private static final String nameOnlyFields = "identifier,lastNameOrOrgName";
    private static final String dateFields = "qualifierCode,date";
    private static final String refFields = "qualifierCode,identification";

    public static Set<String> getExcludedFields(TransactionType transactionType) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>(globalExcludedFields);
        if (transactionType == TransactionType.PAYMENT) {
            fields.addAll(IncludedExcludedFields.prefixFields("Payer", payerPayeeExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("Payee", payerPayeeExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("CrossoverCarrier", paymentCrossoverExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("CorrectedPayer", paymentCrossoverExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("Patient", paymentPatSubProvExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("Subscriber", paymentPatSubProvExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("CorrectedPatient", paymentPatSubProvExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("OtherSubscriber", paymentPatSubProvExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("ServiceProvider", paymentRenderingProvExcludedFields));
        } else if (transactionType.isClaim()) {
            fields.addAll(IncludedExcludedFields.prefixFields("BillingProvider", billingProvExcludedFields));
            fields.addAll(IncludedExcludedFields.prefixFields("Subscriber", subscriber837Excluded));
            fields.addAll(IncludedExcludedFields.prefixFields("OtherSubscriber", otherSubExcluded));
            fields.addAll(IncludedExcludedFields.prefixFields("Patient", patientExcluded));
            fields.addAll(DictMgr.getExcludedFieldsForTransaction(ClaimCsv.class, transactionType, null));
            fields.addAll(DictMgr.getExcludedFieldsForTransaction(ClaimLineCsv.class, transactionType, "Line"));
        } else if (transactionType == TransactionType.MEMBER_COVERAGE) {
            fields.addAll(IncludedExcludedFields.prefixFields("Member", subscriberExcluded));
            fields.remove("*ChangeReason");
            fields.remove("*entityRole*");
            fields.remove("*Categories");
            fields.remove("*desc");
            fields.add("*Contact*Name");
        }
        return fields;
    }

    public static void populateObjectSchemas(ConversionSchema conversionSchema, TransactionType transactionType) {
        conversionSchema.addObjectSchema("procedure", "code, modifiers");
        conversionSchema.addObjectSchema("originalProcedure", "code, modifiers");
        conversionSchema.addDefaultEntObjectSchema("modifier", "providerTaxonomy", "drug");
        conversionSchema.addDefaultEntObjectSchema("facility");
        if (transactionType.isClaim()) {
            conversionSchema.addObjectSchema("procedure", "code, modifiers, descFromClaim");
            IncludedExcludedFields.addDefaultProviderSchema(conversionSchema, "referringProvider", "supervisingProvider", "operatingPhysician", "otherOperatingPhysician");
            conversionSchema.addObjectSchema("orderingProvider", "identifier,lastNameOrOrgName,firstName,middleName,additionalIds,address,contacts");
            conversionSchema.addObjectSchema("ambulancePickUp", "address");
            conversionSchema.addObjectSchema("ambulanceDropOff", "lastNameOrOrgName,address");
            conversionSchema.addDefaultEntObjectSchema("condition");
            if (transactionType == TransactionType.INST) {
                conversionSchema.addDefaultEntObjectSchema("principalDiag", "admittingDiag", "reasonForVisitDiag", "externalCauseOfInjuryDiag", "drg", "revenueCode");
                conversionSchema.addObjectSchema("otherDiag", "code, presentOnAdmissionIndicator");
                conversionSchema.addObjectSchema("principalProcedure", "code, occurrenceDate");
                conversionSchema.addObjectSchema("otherProcedure", "code, occurrenceDate");
                conversionSchema.addObjectSchema("occurrence", "code, occurrenceDate");
                conversionSchema.addObjectSchema("occurrenceSpan", "code, occurrenceDate, occurrenceEndDate");
                conversionSchema.addObjectSchema("valueInfo", "code, amount");
                conversionSchema.addObjectSchema("attendingProvider", "identifier,lastNameOrOrgName,firstName,middleName,providerTaxonomy,additionalIds");
                IncludedExcludedFields.addDefaultProviderSchema(conversionSchema, "renderingProvider");
                conversionSchema.addObjectSchema("serviceFacility", "identifier,lastNameOrOrgName,additionalIds,address");
            } else {
                conversionSchema.addObjectSchema("renderingProvider", "identifier,lastNameOrOrgName,firstName,middleName,providerTaxonomy,additionalIds");
                conversionSchema.addObjectSchema("serviceFacility", "identifier,lastNameOrOrgName,additionalIds,address,contacts");
                conversionSchema.addObjectSchema("purchasedServiceProvider", "identifier,additionalIds");
                conversionSchema.addDefaultEntObjectSchema("diag", "anesthesiaProcedure");
            }
        } else if (transactionType == TransactionType.MEMBER_COVERAGE) {
            conversionSchema.addObjectSchema("sponsor", nameOnlyFields);
            conversionSchema.addObjectSchema("tpa", "identifier,lastNameOrOrgName,accountNumber,accountNumber2");
            conversionSchema.addObjectSchema("insurer", nameOnlyFields);
            conversionSchema.addObjectSchema("supplementalIdentifier", refFields);
            conversionSchema.addObjectSchema("statusInfoEffectiveDate", dateFields);
            conversionSchema.addObjectSchema("contractAmount", "qualifierCode,amount");
            conversionSchema.addObjectSchema("coverageDate", dateFields);
            conversionSchema.addObjectSchema("groupOrPolicyNumber", refFields);
            conversionSchema.addObjectSchema("provider", "identifier,lastNameOrOrgName,firstName,middleName,entityRole,entityType,address,contacts, changeReason");
            conversionSchema.addObjectSchema("employer", "identifier,lastNameOrOrgName,firstName,middleName,address,contacts");
            conversionSchema.addObjectSchema("school", "identifier,lastNameOrOrgName,address,contacts");
            conversionSchema.addObjectSchema("responsiblePerson", "identifier,lastNameOrOrgName,firstName,middleName,entityRole,address,contacts");
            conversionSchema.addObjectSchema("custodialParent", "identifier,lastNameOrOrgName,firstName,middleName,address,contacts");
            conversionSchema.addObjectSchema("HealthCoverages.insurer", "identifier,lastNameOrOrgName,entityRole,address,contacts");
            conversionSchema.addObjectSchema("fileEffectiveDate", dateFields);
            conversionSchema.addObjectSchema("dropOffLocation", "lastNameOrOrgName,firstName,middleName,address");
            conversionSchema.addObjectSchema("incorrectMember", "lastNameOrOrgName,firstName,middleName,identifier,birthDate,gender,maritalStatusCode,ethnicityCode,citizenshipCode");
        }
    }

    public static void addDefaultProviderSchema(ConversionSchema conversionSchema, String ... objectKeys) {
        for (String objectKey : objectKeys) {
            conversionSchema.addObjectSchema(objectKey, DEFAULT_PROVIDER_OBJECT_CONVERSION_SCHEMA);
        }
    }

    static Set<String> prefixFields(String prefix, String fieldsList) {
        return IncludedExcludedFields.prefixFields(prefix, CsvUtils.stringListToSet(fieldsList));
    }

    static Set<String> prefixFields(String prefix, Collection<String> fields) {
        LinkedHashSet<String> prefixedFields = new LinkedHashSet<String>();
        for (String f : fields) {
            prefixedFields.add(IncludedExcludedFields.prefixField(prefix, f));
        }
        return prefixedFields;
    }

    static String prefixField(String prefix, String field) {
        return prefix + field;
    }
}

