/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.model.Reference;
import hdi.model.orgperson.Address;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.ContactNumber;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.orgperson.ProviderHolder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CsvUtils {
    static OrgOrPerson prepProvider(ProviderHolder providerHolder, EntityRole entityRole) {
        return CsvUtils.prepOrgOrPerson(providerHolder.getProvider(entityRole), entityRole);
    }

    public static OrgOrPerson prepOrgOrPerson(OrgOrPerson orgOrPerson, EntityRole entityRole) {
        if (orgOrPerson == null) {
            orgOrPerson = new OrgOrPerson();
            orgOrPerson.entityRole(entityRole);
        } else if ((orgOrPerson = new OrgOrPerson(orgOrPerson)).entityRole() == null) {
            orgOrPerson.entityRole(entityRole);
        }
        if (orgOrPerson.address() == null) {
            orgOrPerson.address(new Address());
        }
        EntityRole role = orgOrPerson.entityRole();
        if (role.oneOf(EntityRole.PAYER, EntityRole.PAYEE, EntityRole.RENDERING, EntityRole.BILLING_PROVIDER, EntityRole.REFERRING, EntityRole.SERVICE_FACILITY, EntityRole.SUPERVISING, EntityRole.PURCHASE_SERVICE, EntityRole.ORDERING, EntityRole.ATTENDING, EntityRole.OPERATING, EntityRole.OTHER_OPERATING)) {
            CsvUtils.prepOrgOrPersonWithAdditionalIds(orgOrPerson);
        }
        if (role.oneOf(EntityRole.PAYER, EntityRole.BILLING_PROVIDER, EntityRole.SERVICE_FACILITY, EntityRole.ORDERING, EntityRole.CUSTODIAL_PARENT)) {
            CsvUtils.prepContactInfo(orgOrPerson);
        }
        if (role.oneOf(EntityRole.BILLING_PROVIDER, EntityRole.RENDERING, EntityRole.ATTENDING)) {
            CodeEntity taxonomy = CsvUtils.prepCodeEnt(orgOrPerson.providerTaxonomy(), PrimaryCodeType.PROVIDER_TAXONOMY);
            orgOrPerson.providerTaxonomy(taxonomy);
        }
        return orgOrPerson;
    }

    public static void prepContactInfo(OrgOrPerson orgOrPerson) {
        orgOrPerson.contacts(CsvUtils.prepList(orgOrPerson.contacts(), new ContactInfo()));
        ContactInfo contact = orgOrPerson.contacts().get(0);
        contact.contactNumbers(CsvUtils.prepList(contact.contactNumbers(), new ContactNumber()));
    }

    private static void prepOrgOrPersonWithAdditionalIds(OrgOrPerson orgOrPerson) {
        orgOrPerson.additionalIds(CsvUtils.prepReferenceList(orgOrPerson.additionalIds()));
    }

    public static List<Reference> prepReferenceList(List<Reference> references) {
        return CsvUtils.prepList(references, new Reference());
    }

    public static <T> List<T> prepList(List<T> list, T obj) {
        if ((list = list == null ? new ArrayList<T>() : new ArrayList<T>(list)).isEmpty()) {
            list.add(obj);
        }
        return list;
    }

    static String codeFromCodeEnt(CodeEntity codeEnt) {
        return codeEnt != null ? codeEnt.code() : null;
    }

    public static List<CodeEntity> prepCodeEnts(List<CodeEntity> inputCodeEnts, PrimaryCodeType type) {
        CodeEntity codeEnt = CsvUtils.prepCodeEnt(null, type);
        return CsvUtils.prepList(inputCodeEnts, codeEnt);
    }

    public static CodeEntity prepCodeEnt(CodeEntity codeEnt, PrimaryCodeType type) {
        if ((codeEnt = codeEnt == null ? new CodeEntity(type) : new CodeEntity(codeEnt)).type() == null) {
            codeEnt.type(type);
        }
        if (codeEnt.type() == PrimaryCodeType.PROCEDURE) {
            codeEnt.modifiers(CsvUtils.prepList(codeEnt.modifiers(), new CodeEntity()));
        }
        return codeEnt;
    }

    public static Set<String> stringListToSet(String stringList) {
        if (StringUtils.isBlank((CharSequence)stringList)) {
            return Set.of();
        }
        String[] fields = StringUtils.split((String)stringList, (char)',');
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        for (String f : fields) {
            fieldSet.add(StringUtils.strip((String)f));
        }
        return fieldSet;
    }
}

