/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.edi.csv.CsvUtils;
import hdi.util.GlobUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CsvTransposer {
    private final List<Column> columns = new ArrayList<Column>();

    public CsvTransposer(File csvFile) {
        this.transposeFromFile(csvFile);
    }

    public CsvTransposer(String csvStr) {
        this.transposeFromReader(new StringReader(csvStr));
    }

    private void transposeFromFile(File csvFile) {
        try (FileReader reader = new FileReader(csvFile);){
            this.transposeFromReader(reader);
        }
    }

    private void transposeFromReader(Reader csvReader) {
        try (BufferedReader reader = new BufferedReader(csvReader);){
            String line;
            String headerLine = reader.readLine();
            if (headerLine != null) {
                String[] headers = headerLine.split(",");
                for (int i = 0; i < headers.length; ++i) {
                    Column column = new Column();
                    column.name(headers[i]);
                    column.index(i);
                    this.columns.add(column);
                }
            }
            while ((line = reader.readLine()) != null) {
                String[] values = StringUtils.splitPreserveAllTokens((String)line, (String)",");
                for (int i = 0; i < values.length && i < this.columns.size(); ++i) {
                    this.columns.get(i).values().add(values[i]);
                }
            }
        }
    }

    public void print(String columnsToInclude) {
        Set<String> includedColumns = CsvUtils.stringListToSet(columnsToInclude);
        for (Column column : this.columns) {
            if (!StringUtils.isBlank((CharSequence)columnsToInclude) && !GlobUtils.matchesOneOfPatterns(column.name, includedColumns)) continue;
            System.err.println(column.toColumnLine());
        }
    }

    public String toFormattedString() {
        StringBuilder sb = new StringBuilder();
        for (Column column : this.columns) {
            sb.append(column.toColumnLine());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String transposeString(String csvStr) {
        return new CsvTransposer(csvStr).toFormattedString();
    }

    public static class Column {
        private String name;
        private int index;
        private List<String> values = new ArrayList<String>();

        public String toColumnLine() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(": ");
            int i = 0;
            for (String value : this.values) {
                if (i > 0) {
                    sb.append(",");
                }
                if (value == null) {
                    value = "";
                }
                sb.append(value);
                ++i;
            }
            return sb.toString();
        }

        @Generated
        public Column() {
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public int index() {
            return this.index;
        }

        @Generated
        public List<String> values() {
            return this.values;
        }

        @Generated
        public Column name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Column index(int index) {
            this.index = index;
            return this;
        }

        @Generated
        public Column values(List<String> values) {
            this.values = values;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.index() != other.index()) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$values = this.values();
            List<String> other$values = other.values();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Column;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.index();
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $values = this.values();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CsvTransposer.Column(name=" + this.name() + ", index=" + this.index() + ", values=" + String.valueOf(this.values()) + ")";
        }
    }
}

