/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.edi.converter.NamedWriter;
import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.ListConversionSchema;
import hdi.edi.csv.OutputMgr;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvOutputMgr
implements Closeable,
OutputMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CsvOutputMgr.class);
    private final Map<String, Writer> writers = new LinkedHashMap<String, Writer>();
    private final Map<String, Integer> lineCounts = new LinkedHashMap<String, Integer>();
    private final Map<String, File> files = new LinkedHashMap<String, File>();
    private final ConversionSchema schema;
    private final DecimalFormat decimalFormat;
    private boolean isWritersCloseable = false;

    private CsvOutputMgr(ConversionSchema schema) {
        this.schema = schema;
        this.decimalFormat = new DecimalFormat("000.00");
        this.decimalFormat.setMinimumFractionDigits(2);
        this.decimalFormat.setMaximumFractionDigits(2);
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
    }

    public static CsvOutputMgr createForStrings(ConversionSchema schema) {
        List<String> listNames = schema.getListNamesForOutput();
        CsvOutputMgr outputMgr = new CsvOutputMgr(schema);
        for (String listName : listNames) {
            StringWriter writer = new StringWriter();
            outputMgr.writers.put(listName, writer);
        }
        return outputMgr;
    }

    public static CsvOutputMgr createForFirstWriter(ConversionSchema schema, Writer writer) {
        return CsvOutputMgr.createForWriters(schema, List.of(new NamedWriter(schema.getListNamesForOutput().get(0), writer)));
    }

    public static CsvOutputMgr createForWriters(ConversionSchema schema, List<NamedWriter> listNamedWriters) {
        CsvOutputMgr outputMgr = new CsvOutputMgr(schema);
        for (NamedWriter listNameAndWriter : listNamedWriters) {
            outputMgr.writers.put(listNameAndWriter.name(), listNameAndWriter.writer());
        }
        return outputMgr;
    }

    public static CsvOutputMgr createForFiles(ConversionSchema schema, File mainOutputFile) {
        List<String> listNames = schema.getListNamesForOutput();
        CsvOutputMgr outputMgr = new CsvOutputMgr(schema);
        outputMgr.isWritersCloseable = true;
        for (String listName : listNames) {
            ListConversionSchema listSchema;
            File file = mainOutputFile;
            Object fileSuffix = null;
            if (!"Main".equals(listName)) {
                fileSuffix = "-" + listName;
            }
            if ((listSchema = schema.getListSchema(listName)) != null && listSchema.fileSuffix() != null) {
                fileSuffix = listSchema.fileSuffix();
            }
            if (fileSuffix != null && listNames.size() > 1) {
                file = CsvOutputMgr.createFileForList(mainOutputFile, (String)fileSuffix);
            }
            FileUtils.forceMkdirParent((File)file);
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            outputMgr.writers.put(listName, writer);
            outputMgr.files.put(listName, file);
        }
        return outputMgr;
    }

    private static File createFileForList(File mainFile, String fileSuffix) {
        String baseName = FilenameUtils.getBaseName((String)mainFile.getAbsolutePath());
        String ext = FilenameUtils.getExtension((String)mainFile.getAbsolutePath());
        String newFileName = baseName + fileSuffix;
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            newFileName = newFileName + "." + ext;
        }
        File parent = mainFile.getParentFile();
        return new File(parent, newFileName);
    }

    public List<String> getStringOutputs() {
        ArrayList<String> strings = new ArrayList<String>();
        for (Writer writer : this.writers.values()) {
            if (writer instanceof StringWriter) {
                StringWriter stringWriter = (StringWriter)writer;
                strings.add(stringWriter.getBuffer().toString());
                continue;
            }
            throw new IllegalStateException("Output was not initialized with string writers");
        }
        return strings;
    }

    @Override
    public void writeRow(String listName, List<Object> row) {
        Writer writer = this.getWriter(listName);
        if (writer != null) {
            this.write(listName, writer, row);
            this.incrementCount(listName);
        }
    }

    private void incrementCount(String listName) {
        this.lineCounts.put(listName, this.lineCounts.getOrDefault(listName, 0) + 1);
    }

    @Override
    public void writeRows(String listName, List<List<Object>> rows) {
        Writer writer = this.getWriter(listName);
        if (writer != null) {
            for (List<Object> row : rows) {
                this.write(listName, writer, row);
                this.incrementCount(listName);
            }
        }
    }

    private Writer getWriter(String name) {
        Writer writer = this.writers.get(name);
        if (writer == null) {
            log.warn("Writer for the list {} is null", (Object)name);
        }
        return writer;
    }

    private void write(String listName, Writer writer, List<Object> row) {
        List<String> stringRow = this.convertToStrings(row);
        String s = StringUtils.join(stringRow, (String)this.schema.separator());
        Integer count = this.lineCounts.getOrDefault(listName, 0);
        if (count > 0) {
            writer.write(System.lineSeparator());
        }
        writer.write(s);
    }

    @Override
    public void close() throws IOException {
        if (this.isWritersCloseable) {
            for (Writer writer : this.writers.values()) {
                writer.close();
            }
        }
    }

    private List<String> convertToStrings(List<Object> row) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object val : row) {
            strings.add(this.convertValue(val));
        }
        return strings;
    }

    private String convertValue(Object val) {
        String stringVal;
        if (val == null) {
            stringVal = this.schema.nullValue();
        } else if (val instanceof BigDecimal) {
            BigDecimal number = (BigDecimal)val;
            stringVal = number.toPlainString();
        } else {
            stringVal = val.toString();
        }
        return this.escapeAndQuote(stringVal);
    }

    private String escapeAndQuote(String val) {
        if (StringUtils.containsAnyIgnoreCase((CharSequence)val, (CharSequence[])new CharSequence[]{this.schema.separator(), "\n", "\""})) {
            val = "\"" + ((String)val).replace("\"", "\"\"") + "\"";
        }
        return val;
    }

    @Generated
    public Map<String, Writer> writers() {
        return this.writers;
    }

    @Generated
    public Map<String, Integer> lineCounts() {
        return this.lineCounts;
    }

    @Generated
    public Map<String, File> files() {
        return this.files;
    }

    @Generated
    public ConversionSchema schema() {
        return this.schema;
    }

    @Generated
    public DecimalFormat decimalFormat() {
        return this.decimalFormat;
    }

    @Generated
    public boolean isWritersCloseable() {
        return this.isWritersCloseable;
    }
}

