/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CsvConversionResults {
    private final List<Object> rootValues = new ArrayList<Object>();
    private final Map<String, List<Object>> valuesToRepeatForRepeatedRows = new HashMap<String, List<Object>>();
    private final Map<String, List<List<Object>>> valuesByListName = new HashMap<String, List<List<Object>>>();

    public void add(Object val) {
        this.rootValues.add(val);
    }

    public void add(List<Object> values) {
        this.rootValues.addAll(values);
    }

    public void add(String path, List<Object> values) {
        List rows = this.valuesByListName.getOrDefault(path, new ArrayList());
        this.valuesByListName.put(path, rows);
        rows.add(values);
    }

    public Map<String, List<List<Object>>> getLists() {
        ArrayList<List<Object>> topList = new ArrayList<List<Object>>();
        topList.add(this.rootValues);
        HashMap<String, List<List<Object>>> allLists = new HashMap<String, List<List<Object>>>(this.valuesByListName);
        allLists.put("Main", topList);
        return allLists;
    }

    public Map<String, List<Object>> getTopRows() {
        HashMap<String, List<Object>> listsByName = new HashMap<String, List<Object>>();
        listsByName.put("Main", this.rootValues);
        for (Map.Entry<String, List<List<Object>>> nameAndList : this.valuesByListName.entrySet()) {
            List<List<Object>> list = nameAndList.getValue();
            String name = nameAndList.getKey();
            if (list.isEmpty()) {
                throw new IllegalStateException("Rows are empty for " + name);
            }
            listsByName.put(name, list.get(0));
        }
        return listsByName;
    }

    public List<Object> getRepeatedValues(String listName) {
        List<Object> repeatedVals = this.valuesToRepeatForRepeatedRows.get(listName);
        if (repeatedVals == null) {
            repeatedVals = List.of();
        }
        return repeatedVals;
    }

    public void addRepeatedField(String listName, Object val) {
        List repeatedVals = this.valuesToRepeatForRepeatedRows.getOrDefault(listName, new ArrayList());
        repeatedVals.add(val);
        this.valuesToRepeatForRepeatedRows.put(listName, repeatedVals);
    }

    public void clearRepeatedValues(String listName) {
        this.valuesToRepeatForRepeatedRows.remove(listName);
    }

    @Generated
    public List<Object> rootValues() {
        return this.rootValues;
    }

    @Generated
    public Map<String, List<Object>> valuesToRepeatForRepeatedRows() {
        return this.valuesToRepeatForRepeatedRows;
    }
}

