/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hdi.edi.csv.CsvConversionException;
import hdi.edi.csv.CsvConversionResults;
import hdi.edi.csv.CsvConverter;
import hdi.edi.csv.JsonToCsvConverter;
import hdi.edi.csv.ListConversionMeta;
import hdi.edi.csv.ListConversionSchema;
import hdi.edi.csv.ListConversionStrategy;
import hdi.edi.csv.ObjectConversionSchema;
import hdi.edi.parser.TransactionType;
import hdi.util.GlobUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ConversionSchema {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConversionSchema.class);
    public static final String HEADER_LIST_NAME = "Main";
    public static final String LINE_LIST_NAME = "Lines";
    public static final String DEFAULT_SCHEMA_NAME = "default";
    public static final String TWO_FILES_SCHEMA_NAME = "two-files";
    public static final String SINGLE_FILE_SCHEMA_REPEAT_FIRST_ROW = "lines-with-header-repeat-first-row";
    public static final String SINGLE_FILE_SCHEMA_NAME = "lines-with-header-repeat-first-row";
    public static final String SINGLE_FILE_REPEAT_ALL_SCHEMA_NAME = "lines-with-header-repeat-each-row";
    public static final String HEADER_ONLY_SCHEMA_NAME = "header-only";
    public static final String LINES_ONLY_SCHEMA_NAME = "lines-only";
    public static final String KEY_FIELDS_SCHEMA_NAME = "key-fields";
    public static final ListConversionSchema DEFAULT_LIST_CONVERSION_SCHEMA = new ListConversionSchema();
    private static final ObjectConversionSchema DEFAULT_OBJECT_CONVERSION_SCHEMA = new ObjectConversionSchema();
    private static final ObjectConversionSchema DEFAULT_CODE_ENT_OBJECT_CONVERSION_SCHEMA = new ObjectConversionSchema("code");
    public static final ListConversionSchema DEFAULT_MAIN_LIST_SINGLE_FILE_CONVERSION_SCHEMA = new ListConversionSchema("Main", ListConversionStrategy.ROWS);
    @JsonProperty(required=true)
    private List<String> transactionTypes = new ArrayList<String>();
    private boolean isOutputHeaders = true;
    @JsonProperty(required=true)
    private String name;
    private List<String> aliases = new ArrayList<String>();
    private String baseName;
    private String separator;
    private String nullValue;
    private String pathDelimiter = "";
    private Set<String> excludedFields = new LinkedHashSet<String>();
    private Set<String> includedFields = new LinkedHashSet<String>();
    private Map<String, JsonNode> headerJsonForLists = new HashMap<String, JsonNode>();
    private Object headerObject;
    private List<ListConversionSchema> listSchemas = new ArrayList<ListConversionSchema>();
    private TransactionType transactionTypeInUse;
    private Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private Map<String, ListConversionMeta> listMetas = new HashMap<String, ListConversionMeta>();
    private Map<String, ObjectConversionSchema> objectSchemasByName = new HashMap<String, ObjectConversionSchema>();
    private Map<String, ObjectConversionSchema> objectSchemasByNameAndParent = new HashMap<String, ObjectConversionSchema>();

    public ConversionSchema(ConversionSchema anotherSchema) {
        this.name = anotherSchema.name;
        this.baseName = anotherSchema.baseName;
        this.transactionTypes = new ArrayList<String>(anotherSchema.transactionTypes);
        this.transactionTypeInUse = anotherSchema.transactionTypeInUse;
        this.isOutputHeaders = anotherSchema.isOutputHeaders;
        this.separator = anotherSchema.separator;
        this.nullValue = anotherSchema.nullValue;
        this.pathDelimiter = anotherSchema.pathDelimiter;
        this.includedFields = new HashSet<String>(anotherSchema.includedFields);
        this.excludedFields = new HashSet<String>(anotherSchema.excludedFields);
        this.listSchemas = new ArrayList<ListConversionSchema>(anotherSchema.listSchemas);
        this.headers = new HashMap<String, List<Object>>(anotherSchema.headers);
        this.headerObject = anotherSchema.headerObject;
        this.listMetas = new HashMap<String, ListConversionMeta>(anotherSchema.listMetas);
        this.headerJsonForLists = new HashMap<String, JsonNode>(anotherSchema.headerJsonForLists);
        this.objectSchemasByName = new HashMap<String, ObjectConversionSchema>(anotherSchema.objectSchemasByName);
        this.objectSchemasByNameAndParent = new HashMap<String, ObjectConversionSchema>(anotherSchema.objectSchemasByNameAndParent);
        this.aliases = new ArrayList<String>(anotherSchema.aliases);
    }

    public void mergeFromBaseSchema(ConversionSchema anotherSchema) {
        if (this.separator == null) {
            this.separator = anotherSchema.separator;
        }
        if (this.nullValue == null) {
            this.nullValue = anotherSchema.nullValue;
        }
        if (this.pathDelimiter == null) {
            this.pathDelimiter = anotherSchema.pathDelimiter;
        }
        this.excludedFields.addAll(anotherSchema.excludedFields);
        this.includedFields.addAll(anotherSchema.includedFields);
        ArrayList<ListConversionSchema> combinedListSchemas = new ArrayList<ListConversionSchema>(anotherSchema.listSchemas);
        combinedListSchemas.addAll(this.listSchemas);
        this.listSchemas = combinedListSchemas;
    }

    public boolean matchesName(String name) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.name, (CharSequence)name)) {
            return true;
        }
        for (String alias : this.aliases) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)alias, (CharSequence)name)) continue;
            return true;
        }
        return false;
    }

    public String separator() {
        if (this.separator == null) {
            return ",";
        }
        return this.separator;
    }

    public String nullValue() {
        if (this.nullValue == null) {
            return "";
        }
        return this.nullValue;
    }

    public boolean matchesTransactionType(TransactionType transactionType) {
        boolean matches = GlobUtils.matchesOneOfPatterns(transactionType.ediCode(), this.transactionTypes);
        if (!matches) {
            matches = GlobUtils.matchesOneOfPatterns(transactionType.name(), this.transactionTypes);
        }
        return matches;
    }

    void initMeta(Collection<String> enabledLists) {
        JsonToCsvConverter jsonConverter = new JsonToCsvConverter(this);
        JsonNode rootNode = CsvConverter.JSON_SERIALIZER_FOR_CSV.valueToTree(this.headerObject);
        CsvConversionResults conversionResults = jsonConverter.createHeaders((ObjectNode)rootNode);
        Map<String, List<Object>> allListsHeaders = conversionResults.getTopRows();
        if (enabledLists == null || enabledLists.isEmpty()) {
            enabledLists = new ArrayList<String>();
        }
        if (enabledLists.isEmpty()) {
            Set<String> allListNames = allListsHeaders.keySet();
            for (String listName : allListNames) {
                ListConversionSchema listSchema = this.getListSchema(listName);
                if (!listSchema.isWriteOutput()) continue;
                enabledLists.add(listName);
            }
        }
        for (String listName : enabledLists) {
            List<Object> listHeaders = allListsHeaders.get(listName);
            if (listHeaders == null) {
                throw new CsvConversionException("List '%s' is not defied in the schema for transaction %s", new Object[]{listName, this.transactionTypeInUse});
            }
            this.headers.put(listName, listHeaders);
        }
    }

    public ListConversionSchema getListSchema(String listName) {
        ListConversionSchema matchedSchema = DEFAULT_LIST_CONVERSION_SCHEMA;
        int i = 0;
        for (ListConversionSchema listSchema : this.listSchemas) {
            log.debug("Matching {} against schema {} {}", new Object[]{listName, listSchema.names(), i});
            if (listSchema.matches(listName) && !listSchema.isDisabled()) {
                matchedSchema = listSchema;
            }
            ++i;
        }
        return matchedSchema;
    }

    public ObjectConversionSchema getObjectSchema(String parentListName, String objectName) {
        ObjectConversionSchema objectSchema;
        Object key = objectName;
        if (StringUtils.isNotBlank((CharSequence)parentListName)) {
            key = parentListName + "." + objectName;
        }
        if ((objectSchema = this.objectSchemasByName.get(key)) == null) {
            objectSchema = this.objectSchemasByName.get(objectName);
        }
        if (objectSchema == null) {
            objectSchema = DEFAULT_OBJECT_CONVERSION_SCHEMA;
        }
        return objectSchema;
    }

    public void addObjectSchema(String objectKey, ObjectConversionSchema objectSchema) {
        this.objectSchemasByName.put(objectKey, objectSchema);
    }

    public void addDefaultEntObjectSchema(String ... objectKeys) {
        for (String objectKey : objectKeys) {
            this.objectSchemasByName.put(objectKey, DEFAULT_CODE_ENT_OBJECT_CONVERSION_SCHEMA);
        }
    }

    public void addObjectSchema(String objectKey, String includedFieldsStr) {
        ObjectConversionSchema objSchema = new ObjectConversionSchema();
        objSchema.addIncludedFields(includedFieldsStr);
        this.objectSchemasByName.put(objectKey, objSchema);
    }

    public List<String> getListNamesForOutput() {
        return new ArrayList<String>(this.headers.keySet());
    }

    public boolean isValidListName(String listName) {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        names.addAll(this.getListNamesForOutput());
        return names.contains(listName);
    }

    public ListConversionMeta getListMeta(String listName) {
        ListConversionMeta meta = this.listMetas.get(listName);
        if (meta == null) {
            meta = new ListConversionMeta(listName, this.getListSchema(listName), this.excludedFields, this.includedFields);
            this.listMetas.put(listName, meta);
        }
        return meta;
    }

    @JsonProperty(required=true)
    @Generated
    public List<String> transactionTypes() {
        return this.transactionTypes;
    }

    @Generated
    public boolean isOutputHeaders() {
        return this.isOutputHeaders;
    }

    @JsonProperty(required=true)
    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public List<String> aliases() {
        return this.aliases;
    }

    @Generated
    public String baseName() {
        return this.baseName;
    }

    @Generated
    public String pathDelimiter() {
        return this.pathDelimiter;
    }

    @Generated
    public Set<String> excludedFields() {
        return this.excludedFields;
    }

    @Generated
    public Set<String> includedFields() {
        return this.includedFields;
    }

    @Generated
    public Map<String, JsonNode> headerJsonForLists() {
        return this.headerJsonForLists;
    }

    @Generated
    public Object headerObject() {
        return this.headerObject;
    }

    @Generated
    public List<ListConversionSchema> listSchemas() {
        return this.listSchemas;
    }

    @Generated
    public TransactionType transactionTypeInUse() {
        return this.transactionTypeInUse;
    }

    @Generated
    public Map<String, List<Object>> headers() {
        return this.headers;
    }

    @Generated
    public Map<String, ListConversionMeta> listMetas() {
        return this.listMetas;
    }

    @Generated
    public Map<String, ObjectConversionSchema> objectSchemasByName() {
        return this.objectSchemasByName;
    }

    @Generated
    public Map<String, ObjectConversionSchema> objectSchemasByNameAndParent() {
        return this.objectSchemasByNameAndParent;
    }

    @Generated
    public ConversionSchema() {
    }

    @Generated
    public String toString() {
        return "ConversionSchema(transactionTypes=" + String.valueOf(this.transactionTypes()) + ", isOutputHeaders=" + this.isOutputHeaders() + ", name=" + this.name() + ", aliases=" + String.valueOf(this.aliases()) + ", baseName=" + this.baseName() + ", separator=" + this.separator() + ", nullValue=" + this.nullValue() + ", pathDelimiter=" + this.pathDelimiter() + ", excludedFields=" + String.valueOf(this.excludedFields()) + ", includedFields=" + String.valueOf(this.includedFields()) + ", headerJsonForLists=" + String.valueOf(this.headerJsonForLists()) + ", headerObject=" + String.valueOf(this.headerObject()) + ", listSchemas=" + String.valueOf(this.listSchemas()) + ", transactionTypeInUse=" + String.valueOf((Object)this.transactionTypeInUse()) + ", headers=" + String.valueOf(this.headers()) + ", listMetas=" + String.valueOf(this.listMetas()) + ", objectSchemasByName=" + String.valueOf(this.objectSchemasByName()) + ", objectSchemasByNameAndParent=" + String.valueOf(this.objectSchemasByNameAndParent()) + ")";
    }

    @Generated
    public ConversionSchema headerObject(Object headerObject) {
        this.headerObject = headerObject;
        return this;
    }

    @Generated
    public ConversionSchema transactionTypeInUse(TransactionType transactionTypeInUse) {
        this.transactionTypeInUse = transactionTypeInUse;
        return this;
    }

    @Generated
    public ConversionSchema headers(Map<String, List<Object>> headers) {
        this.headers = headers;
        return this;
    }

    static {
        DEFAULT_MAIN_LIST_SINGLE_FILE_CONVERSION_SCHEMA.repeatFields().add("*");
        DEFAULT_MAIN_LIST_SINGLE_FILE_CONVERSION_SCHEMA.repeatEachRow().addAll(Set.of("Id", "PatientControlNumber", "PayerControlNumber"));
    }
}

