/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.ClaimLineCsv;
import hdi.edi.csv.CsvUtils;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.parser.TransactionType;
import hdi.model.Attachment;
import hdi.model.PlaceOfServiceType;
import hdi.model.ServiceLine;
import hdi.model.claim.Claim;
import hdi.model.enumtype.ClaimOrEncounterIdentifierType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.DiagType;
import hdi.model.enumtype.ProcType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.Adjustment;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2300"}, seg={"CLM"}, masterClass=Claim.class, csvExample={"837P:837/837P-all-fields.csv", "837I:837/837I-all-fields.csv"}, interactiveExample={"837P:claims/comprehensive/", "837I:claims/institutional-837i/all-fields/"})
public class ClaimCsv {
    @Prop(masterClass=PaymentCsv.class)
    private String id;
    @Prop(masterClass=PaymentCsv.class)
    private String transactionType;
    @Prop(masterClass=PaymentCsv.class)
    private String fileName;
    @Prop(masterClass=PaymentCsv.class)
    private String transactionControlNumber;
    @Prop(edi={"BHT02"})
    private String transactionSetPurposeCode;
    @Prop(edi={"BHT03"})
    private String originatorApplicationTransactionId;
    @Prop(edi={"BHT04", "BHT05"})
    private LocalDateTime transactionCreationDateTime;
    @Prop(edi={"BHT06"})
    private ClaimOrEncounterIdentifierType claimOrEncounterIdentifierType;
    @Prop(desc={"Patient control number"}, edi={"CLM01"})
    private String patientControlNumber;
    @Prop(edi={"CLM02"})
    private BigDecimal chargeAmount;
    @Prop(desc={"Place of service as a string constant (enum)"}, edi={"CLM05"}, tran={TransactionType.PROF})
    private PlaceOfServiceType placeOfService;
    @Prop(edi={"CLM05-1"}, objType=ObjType.FACILITY, desc={"Place of service code for professional/dental claims or UB facility code for institutional claims"})
    private CodeEntity facility;
    @Prop(edi={"CLM05-3"}, codeLookupQuery="type=frequency_code")
    private String frequencyTypeCode;
    @Prop(edi={"CLM06"}, tran={TransactionType.PROF})
    private String providerSignatureIndicator;
    @Prop(edi={"CLM07"})
    private String assignmentParticipationCode;
    @Prop(edi={"CLM08"})
    private String assignmentCertificationIndicator;
    @Prop(edi={"CLM09"})
    private String releaseOfInformationCode;
    @Prop(edi={"CLM20"})
    private String delayReasonCode;
    @Prop(edi={"NM1"}, entityRole=EntityRole.BILLING_PROVIDER, objType=ObjType.PROVIDER)
    private OrgOrPerson billingProvider;
    @Prop(edi={"NM1"}, entityRole=EntityRole.SUBSCRIBER, objType=ObjType.SUBSCRIBER, desc={"The insured (subscriber)"})
    private PatientSubscriber subscriber;
    @Prop(edi={"NM1"}, entityRole=EntityRole.PATIENT, objType=ObjType.PATIENT, desc={"Patient if different from the the insured (subscriber)"})
    private PatientSubscriber patient;
    @Prop(isDerived=true, tran={TransactionType.PROF}, desc={"The earliest service date from service lines"})
    private LocalDate serviceDateFrom;
    @Prop(isDerived=true, tran={TransactionType.PROF}, desc={"The latest service date from service lines"})
    private LocalDate serviceDateTo;
    @Prop(tran={TransactionType.INST}, dateType={DateType.STATEMENT})
    private LocalDate statementDateFrom;
    @Prop(tran={TransactionType.INST}, dateType={DateType.STATEMENT})
    private LocalDate statementDateTo;
    private LocalTime dischargeTime;
    private LocalDateTime admissionDateAndHour;
    private String admissionTypeCode;
    private String admissionSourceCode;
    private String patientStatusCode;
    private LocalDate onsetOfCurrentIllnessOrInjuryDate;
    private LocalDate initialTreatmentDate;
    private LocalDate lastSeenDate;
    private LocalDate acuteManifestationDate;
    private LocalDate accidentDate;
    private LocalDate lastMenstrualPeriodDate;
    private LocalDate lastXRayDate;
    private LocalDate prescriptionDate;
    private LocalDate assumedCareDate;
    private LocalDate relinquishedCareDate;
    private LocalDate admissionDate;
    private LocalDate dischargeDate;
    @Prop(masterClass=Claim.class)
    private BigDecimal patientPaidAmount;
    private BigDecimal patientResponsibilityAmount;
    private String serviceAuthorizationExceptionCode;
    private String referralNumber;
    private String priorAuthorizationNumber;
    @Prop(masterClass=Claim.class, fieldName="originalReferenceNumber")
    private String payerClaimControlNumber;
    private String clearinghouseTraceNumber;
    private String repricedReferenceNumber;
    private String adjustedRepricedReferenceNumber;
    private String accidentState;
    private String medicalRecordNumber;
    private String demonstrationProjectIdentifier;
    @Prop(masterClass=Claim.class, fieldName="claimNote")
    private String note;
    private String billingNote;
    @Prop(desc={"Principal diagnosis"}, tran={TransactionType.INST}, diagType={DiagType.ICD_10_PRINCIPAL}, objType=ObjType.INST_DIAGNOSIS)
    private CodeEntity principalDiag;
    @Prop(desc={"Admitting diagnosis"}, tran={TransactionType.INST}, diagType={DiagType.ICD_10_ADMITTING}, objType=ObjType.DIAG)
    private CodeEntity admittingDiag;
    @Prop(tran={TransactionType.INST}, diagType={DiagType.ICD_10_REASON_FOR_VISIT}, objType=ObjType.DIAG)
    private List<CodeEntity> reasonForVisitDiags;
    @Prop(tran={TransactionType.INST}, diagType={DiagType.ICD_10_EXTERNAL_CAUSE_OF_INJURY}, objType=ObjType.DIAG)
    private List<CodeEntity> externalCauseOfInjuryDiags;
    @Prop(tran={TransactionType.INST}, objType=ObjType.CODE)
    private CodeEntity drg;
    @Prop(tran={TransactionType.INST}, diagType={DiagType.ICD_10}, objType=ObjType.INST_DIAGNOSIS)
    private List<CodeEntity> otherDiags;
    @Prop(tran={TransactionType.PROF}, diagType={DiagType.ICD_10_PRINCIPAL, DiagType.ICD_10}, objType=ObjType.DIAG)
    private List<CodeEntity> diags;
    @Prop(tran={TransactionType.INST}, objType=ObjType.PROCEDURE_WITH_DATE, procType={ProcType.ICD_10_PCS_PRINCIPAL, ProcType.ABC_PRINCIPAL})
    private CodeEntity principalProcedure;
    @Prop(tran={TransactionType.PROF}, objType=ObjType.PROCEDURE_NO_MODS, procType={ProcType.HCPCS_PRINCIPAL})
    private CodeEntity anesthesiaProcedure;
    @Prop(tran={TransactionType.INST}, objType=ObjType.PROCEDURE_WITH_DATE, procType={ProcType.ICD_10_PCS})
    private List<CodeEntity> otherProcedures;
    private List<CodeEntity> occurrences;
    private List<CodeEntity> occurrenceSpans;
    private List<CodeEntity> conditions;
    private List<CodeEntity> valueInfos;
    @Prop(edi={"PWK"}, objType=ObjType.ATTACHMENT)
    private List<Attachment> attachments;
    @Prop(tran={TransactionType.INST}, entityRole=EntityRole.ATTENDING, objType=ObjType.PARTY)
    private OrgOrPerson attendingProvider;
    @Prop(tran={TransactionType.INST}, entityRole=EntityRole.OPERATING, objType=ObjType.PROVIDER)
    private OrgOrPerson operatingPhysician;
    @Prop(tran={TransactionType.INST}, entityRole=EntityRole.OTHER_OPERATING, objType=ObjType.PARTY)
    private OrgOrPerson otherOperatingPhysician;
    @Prop(entityRole=EntityRole.REFERRING, objType=ObjType.PARTY)
    private OrgOrPerson referringProvider;
    @Prop(entityRole=EntityRole.RENDERING, objType=ObjType.PROVIDER)
    private OrgOrPerson renderingProvider;
    @Prop(entityRole=EntityRole.SERVICE_FACILITY, objType=ObjType.PARTY)
    private OrgOrPerson serviceFacility;
    @Prop(tran={TransactionType.PROF}, entityRole=EntityRole.SUPERVISING, objType=ObjType.PARTY)
    private OrgOrPerson supervisingProvider;
    @Prop(tran={TransactionType.PROF}, entityRole=EntityRole.PICKUP_ADDRESS, objType=ObjType.PARTY)
    private OrgOrPerson ambulancePickUp;
    @Prop(tran={TransactionType.PROF}, entityRole=EntityRole.DROP_OFF_LOCATION, objType=ObjType.PARTY)
    private OrgOrPerson ambulanceDropOff;
    @Prop(objType=ObjType.OTHER_SUBSCRIBER, loop={"835:2100", "837:2320"}, desc={"835:Other subscriber; only one other subscriber is allowed on 835", "837:Other subscribers and their payer's information"})
    private List<PatientSubscriber> otherSubscribers;
    @Prop(desc={"Service lines"}, loop={"835:2110", "837:2400"}, objType=ObjType.PROF_LINE_CSV)
    private List<ClaimLineCsv> lines;

    public ClaimCsv(Claim claim, TransactionType tranType) {
        if (claim.transaction() == null) {
            EdiTransaction transaction = new EdiTransaction();
            transaction.transactionType(tranType);
            claim.transaction(transaction);
        }
        if (claim.transaction().fileInfo() != null) {
            this.fileName = claim.transaction().fileInfo().name();
        }
        this.transactionType = tranType.ediCode();
        this.transactionControlNumber = claim.transaction().controlNumber();
        this.transactionSetPurposeCode = claim.transaction().purposeCode();
        this.originatorApplicationTransactionId = claim.transaction().originatorApplicationTransactionId();
        this.transactionCreationDateTime = claim.transaction().getCreationDateTime();
        this.claimOrEncounterIdentifierType = claim.transaction().claimOrEncounterIdentifierType();
        this.patientControlNumber = claim.patientControlNumber();
        this.chargeAmount = claim.chargeAmount();
        this.placeOfService = claim.placeOfServiceType();
        this.facility = CsvUtils.prepCodeEnt(claim.facilityCode(), PrimaryCodeType.FACILITY_TYPE);
        this.frequencyTypeCode = CsvUtils.codeFromCodeEnt(claim.frequencyCode());
        this.providerSignatureIndicator = claim.providerSignatureIndicator();
        this.assignmentParticipationCode = claim.assignmentParticipationCode();
        this.assignmentCertificationIndicator = claim.assignmentCertificationIndicator();
        this.releaseOfInformationCode = claim.releaseOfInformationCode();
        this.delayReasonCode = claim.delayReasonCode();
        this.referralNumber = claim.referralNumber();
        this.billingProvider = CsvUtils.prepOrgOrPerson(claim.billingProvider(), EntityRole.BILLING_PROVIDER);
        this.subscriber = this.prepOptionalSub(claim.subscriber());
        this.patient = this.prepOptionalSub(claim.patient());
        this.otherSubscribers = new ArrayList<PatientSubscriber>();
        if (claim.otherSubscribers() != null && !claim.otherSubscribers().isEmpty()) {
            for (PatientSubscriber otherSub : claim.otherSubscribers()) {
                PatientSubscriber otherSubscriber = this.prepOptionalSub(otherSub);
                otherSubscriber.adjustments(CsvUtils.prepList(otherSubscriber.adjustments(), new Adjustment()));
                this.otherSubscribers.add(otherSubscriber);
            }
        } else {
            PatientSubscriber otherSubscriber = this.prepOptionalSub(null);
            otherSubscriber.adjustments(CsvUtils.prepList(otherSubscriber.adjustments(), new Adjustment()));
            this.otherSubscribers.add(otherSubscriber);
        }
        this.serviceDateFrom = claim.serviceDateFrom();
        this.serviceDateTo = claim.serviceDateTo();
        this.statementDateFrom = claim.statementDateFrom();
        this.statementDateTo = claim.statementDateTo();
        this.dischargeTime = claim.dischargeTime();
        this.admissionDateAndHour = claim.admissionDateAndHour();
        this.admissionTypeCode = claim.admissionTypeCode();
        this.admissionSourceCode = claim.admissionSourceCode();
        this.patientStatusCode = claim.patientStatusCode();
        if (tranType == TransactionType.INST) {
            this.reasonForVisitDiags = CsvUtils.prepCodeEnts(claim.getDiagsByType(DiagType.ICD_10_REASON_FOR_VISIT), PrimaryCodeType.DIAGNOSIS);
            this.externalCauseOfInjuryDiags = CsvUtils.prepCodeEnts(claim.getDiagsByType(DiagType.ICD_10_EXTERNAL_CAUSE_OF_INJURY), PrimaryCodeType.DIAGNOSIS);
            this.drg = CsvUtils.prepCodeEnt(claim.drg(), PrimaryCodeType.UB_CODE);
            this.otherDiags = CsvUtils.prepCodeEnts(claim.getDiagsByType(DiagType.ICD_10), PrimaryCodeType.DIAGNOSIS);
            this.principalDiag = CsvUtils.prepCodeEnt(claim.getPrincipalDiagnosis(), PrimaryCodeType.DIAGNOSIS);
            this.admittingDiag = CsvUtils.prepCodeEnt(claim.getDiagByType(DiagType.ICD_10_ADMITTING), PrimaryCodeType.DIAGNOSIS);
            this.principalProcedure = CsvUtils.prepCodeEnt(claim.getProcByType(ProcType.ICD_10_PCS_PRINCIPAL), PrimaryCodeType.PROCEDURE);
            this.otherProcedures = CsvUtils.prepCodeEnts(claim.getProcsByType(ProcType.ICD_10_PCS), PrimaryCodeType.PROCEDURE);
            this.occurrences = CsvUtils.prepCodeEnts(claim.occurrences(), PrimaryCodeType.UB04_OCCURRENCE_CODE);
            this.occurrenceSpans = CsvUtils.prepCodeEnts(claim.occurrenceSpans(), PrimaryCodeType.UB04_OCCURRENCE_SPAN_CODE);
            this.valueInfos = CsvUtils.prepCodeEnts(claim.valueInfos(), PrimaryCodeType.UB04_VALUE_CODE);
        } else if (tranType == TransactionType.PROF) {
            this.diags = CsvUtils.prepCodeEnts(claim.diags(), PrimaryCodeType.DIAGNOSIS);
            this.anesthesiaProcedure = CsvUtils.prepCodeEnt(claim.getProcByType(ProcType.HCPCS_PRINCIPAL), PrimaryCodeType.PROCEDURE);
        }
        this.conditions = CsvUtils.prepCodeEnts(claim.conditions(), PrimaryCodeType.UB04_CONDITION_CODE);
        this.patientPaidAmount = claim.patientPaidAmount();
        this.patientResponsibilityAmount = claim.patientResponsibilityAmount();
        this.serviceAuthorizationExceptionCode = claim.serviceAuthorizationExceptionCode();
        this.lines = this.prepLines(claim.lines());
        EntityRole providerRole = EntityRole.REFERRING;
        this.referringProvider = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.RENDERING;
        this.renderingProvider = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.SERVICE_FACILITY;
        this.serviceFacility = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.SUPERVISING;
        this.supervisingProvider = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.PICKUP_ADDRESS;
        this.ambulancePickUp = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.DROP_OFF_LOCATION;
        this.ambulanceDropOff = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.ATTENDING;
        this.attendingProvider = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.OPERATING;
        this.operatingPhysician = CsvUtils.prepProvider(claim, providerRole);
        providerRole = EntityRole.OTHER_OPERATING;
        this.otherOperatingPhysician = CsvUtils.prepProvider(claim, providerRole);
        this.onsetOfCurrentIllnessOrInjuryDate = claim.onsetOfCurrentIllnessOrInjuryDate();
        this.initialTreatmentDate = claim.initialTreatmentDate();
        this.lastSeenDate = claim.lastSeenDate();
        this.acuteManifestationDate = claim.acuteManifestationDate();
        this.accidentDate = claim.accidentDate();
        this.lastMenstrualPeriodDate = claim.lastMenstrualPeriodDate();
        this.lastXRayDate = claim.lastXRayDate();
        this.prescriptionDate = claim.prescriptionDate();
        this.assumedCareDate = claim.assumedCareDate();
        this.relinquishedCareDate = claim.relinquishedCareDate();
        this.admissionDate = claim.admissionDate();
        this.dischargeDate = claim.dischargeDate();
        this.priorAuthorizationNumber = claim.priorAuthorizationNumber();
        this.payerClaimControlNumber = claim.originalReferenceNumber();
        this.clearinghouseTraceNumber = claim.clearinghouseTraceNumber();
        this.repricedReferenceNumber = claim.repricedReferenceNumber();
        this.adjustedRepricedReferenceNumber = claim.adjustedRepricedReferenceNumber();
        this.accidentState = claim.accidentState();
        this.demonstrationProjectIdentifier = claim.demonstrationProjectIdentifier();
        this.medicalRecordNumber = claim.medicalRecordNumber();
        this.note = claim.claimNote();
        this.billingNote = claim.billingNote();
        this.attachments = CsvUtils.prepList(claim.attachments(), new Attachment());
    }

    private List<ClaimLineCsv> prepLines(List<ServiceLine> serviceLines) {
        List<ClaimLineCsv> lines;
        if (serviceLines == null || serviceLines.isEmpty()) {
            lines = CsvUtils.prepList(null, new ClaimLineCsv());
        } else {
            lines = new ArrayList<ClaimLineCsv>();
            for (ServiceLine serviceLine : serviceLines) {
                ClaimLineCsv lineCsv = new ClaimLineCsv(serviceLine);
                lines.add(lineCsv);
            }
        }
        return lines;
    }

    private PatientSubscriber prepOptionalSub(PatientSubscriber patientSubscriber) {
        patientSubscriber = patientSubscriber == null ? new PatientSubscriber() : new PatientSubscriber(patientSubscriber);
        patientSubscriber.person(CsvUtils.prepOrgOrPerson(patientSubscriber.person(), EntityRole.SUBSCRIBER));
        patientSubscriber.payer(CsvUtils.prepOrgOrPerson(patientSubscriber.payer(), EntityRole.PAYER));
        return patientSubscriber;
    }

    @Generated
    public ClaimCsv id(String id) {
        this.id = id;
        return this;
    }
}

