/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.converter;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public record NamedWriter(String name, Writer writer) implements Closeable
{
    public static final String STD_OUT_NAME = "StdOut";
    public static final String API_RESPONSE_NAME = "API Response";

    NamedWriter(Writer writer) {
        this("Writer", writer);
    }

    @Override
    public void close() throws IOException {
        if (this.isApiResponse()) {
            return;
        }
        if (!this.isStdOut()) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    public boolean isStdOut() {
        return STD_OUT_NAME.equals(this.name);
    }

    public boolean isApiResponse() {
        return API_RESPONSE_NAME.equals(this.name);
    }

    public static NamedWriter stdOut() {
        return new NamedWriter(STD_OUT_NAME, new OutputStreamWriter(System.out));
    }
}

