/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.converter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;

class JsonObjectSerializer
implements Closeable {
    private static final ObjectMapper JSON_SERIALIZER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, false).configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false).configure(SerializationFeature.CLOSE_CLOSEABLE, false).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    private final JsonGenerator jsonGenerator;
    private final boolean isJsonLines;
    private final boolean isFormatJson;
    private int objCount = 0;
    private boolean isArrayOpened = false;

    public JsonObjectSerializer(Writer writer, boolean isJsonLines, boolean isFormatJson) {
        this.isJsonLines = isJsonLines;
        this.isFormatJson = isFormatJson;
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.setCodec((ObjectCodec)JSON_SERIALIZER);
        jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jsonFactory.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        this.jsonGenerator = jsonFactory.createGenerator(writer);
        this.jsonGenerator.setRootValueSeparator((SerializableString)new SerializedString(""));
        if (isFormatJson && !isJsonLines) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        }
    }

    public void writeStart() throws IOException {
        if (!this.isJsonLines) {
            this.jsonGenerator.writeStartArray();
            if (this.isFormatJson) {
                this.writeNewLine();
            }
            this.isArrayOpened = true;
        }
    }

    public void writeEnd() throws IOException {
        if (!this.isJsonLines && this.isArrayOpened) {
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeNewLine() throws IOException {
        this.jsonGenerator.writeRaw("\n");
    }

    public void serialize(Object object) throws IOException {
        if (this.objCount > 0 && this.isJsonLines) {
            this.writeNewLine();
        }
        if (object instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)object;
            this.jsonGenerator.writeTree((TreeNode)jsonNode);
        } else {
            this.jsonGenerator.writeObject(object);
        }
        if (this.isFormatJson && !this.isJsonLines) {
            this.writeNewLine();
        }
        ++this.objCount;
    }

    public void flush() throws IOException {
        this.jsonGenerator.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.jsonGenerator != null) {
            this.jsonGenerator.close();
        }
    }
}

