/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.codecollector;

import hdi.codeent.CodeEntity;
import hdi.edi.qualifier.EdiQualifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class CodeEntityHolder {
    private final List<CodeEntity> codes = new ArrayList<CodeEntity>();
    private final Map<String, CodeEntity> codeById = new HashMap<String, CodeEntity>();
    private final MultiValuedMap<Class<? extends EdiQualifier>, CodeEntity> codesByType = new ArrayListValuedHashMap();

    public CodeEntity add(CodeEntity codeEntity) {
        this.codes.add(codeEntity);
        this.codesByType.put(codeEntity.subType().getClass(), (Object)codeEntity);
        this.codeById.putIfAbsent(codeEntity.id(), codeEntity);
        return codeEntity;
    }

    public void addAll(Collection<CodeEntity> codeEntities) {
        for (CodeEntity ce : codeEntities) {
            this.add(ce);
        }
    }

    public Collection<CodeEntity> getByType(Class<? extends EdiQualifier> codeType) {
        return this.codesByType.get(codeType);
    }

    public CodeEntity findBy(EdiQualifier qualifier, String code) {
        String idToLookFor = CodeEntity.createId(qualifier, code);
        return this.codeById.get(idToLookFor);
    }

    @Generated
    public List<CodeEntity> codes() {
        return this.codes;
    }

    @Generated
    public Map<String, CodeEntity> codeById() {
        return this.codeById;
    }
}

