/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.codecollector;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.codecollector.CodeEntityHolder;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.enumtype.CarcRarcType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.UbCodeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class CodeEntityCollector {
    private final EdiObjectMapper<CodeEntity> codeEntityMapper = new EdiObjectMapper();

    public CodeEntityHolder processEdi(List<EdiSeg> segs) {
        CodeEntityHolder codeEntityHolder = new CodeEntityHolder();
        this.processEdi(segs, codeEntityHolder);
        return codeEntityHolder;
    }

    public void processEdi(List<EdiSeg> segs, CodeEntityHolder codeEntityHolder) {
        for (EdiSeg seg : segs) {
            if (seg.eltSet() != null) {
                this.processEltSet(seg.eltSet(), codeEntityHolder);
            }
            if (seg.childSegs().isEmpty()) continue;
            this.processEdi(seg.childSegs(), codeEntityHolder);
        }
    }

    private void processEltSet(EltSet eltSet, CodeEntityHolder codeEntityHolder) {
        EdiQualifier qualifier = null;
        String code = null;
        int i = 0;
        Elt eltWithCode = null;
        ArrayList<CodeEntity> codeEntitiesForThisEltSet = new ArrayList<CodeEntity>();
        for (Elt elt : eltSet.elts()) {
            if (elt.dataType() == DataType.QUALIFIER) {
                qualifier = elt.qualifier();
                eltWithCode = eltSet.eltByIndex(i + 1);
                if (eltWithCode != null && eltWithCode.dataType() == DataType.STR) {
                    code = eltWithCode.valAsStr();
                    break;
                }
            } else if (elt.dataType() == DataType.ELT_SET) {
                this.processEltSet(elt.eltSet(), codeEntityHolder);
            }
            ++i;
        }
        if (qualifier != null && code != null && qualifier.isMedicalCode()) {
            CodeEntity codeEntity = new CodeEntity(qualifier, code);
            this.codeEntityMapper.populateObject(codeEntity, eltSet);
            codeEntity = codeEntityHolder.add(codeEntity);
            eltSet.codeEntity(codeEntity);
            eltWithCode.codeEntity(codeEntity);
            if (codeEntity.subType() instanceof ProcType) {
                codeEntity.mapFromEdi(eltSet.elts());
                if (codeEntity.modifiers() != null) {
                    codeEntitiesForThisEltSet.addAll(codeEntity.modifiers());
                    codeEntityHolder.addAll(codeEntity.modifiers());
                }
            }
            codeEntitiesForThisEltSet.add(codeEntity);
        }
        for (Elt elt : eltSet.elts()) {
            CodeEntity codeEntity = this.attemptToIdentifyCodeByFieldName(elt, eltSet.parentSeg());
            if (codeEntity == null) continue;
            codeEntityHolder.add(codeEntity);
            codeEntitiesForThisEltSet.add(codeEntity);
            elt.codeEntity(codeEntity);
        }
        if (eltSet.parentSeg() != null && (eltSet.parentSeg().entity() != null || eltSet.parentSeg().codeEntityConsumer() != null)) {
            for (CodeEntity codeEnt : codeEntitiesForThisEltSet) {
                if (eltSet.parentSeg().entity() != null) {
                    eltSet.parentSeg().entity().addCodeEntityForSeg(codeEnt);
                }
                if (eltSet.parentSeg().codeEntityConsumer() == null) continue;
                eltSet.parentSeg().codeEntityConsumer().accept(codeEnt);
            }
        }
    }

    private CodeEntity attemptToIdentifyCodeByFieldName(Elt elt, EdiSeg seg) {
        if (elt.dataType() != DataType.STR) {
            return null;
        }
        String nm = elt.name().toLowerCase(Locale.ROOT);
        String code = StringUtils.stripToNull((String)elt.valAsStr());
        switch (nm) {
            case "revenue_code": {
                return new CodeEntity(PrimaryCodeType.UB04_REVENUE_CODE, UbCodeType.REVENUE_CODE, code);
            }
            case "facility_type_code": {
                return new CodeEntity(PrimaryCodeType.FACILITY_TYPE, UbCodeType.FACILITY_TYPE, code);
            }
            case "place_of_service_code": {
                return new CodeEntity(PrimaryCodeType.FACILITY_TYPE, UbCodeType.PLACE_OF_SERVICE, code);
            }
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)nm, (CharSequence)"frequency_code")) {
            return new CodeEntity(PrimaryCodeType.FREQUENCY_CODE, UbCodeType.FREQUENCY_CODE, code);
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)nm, (CharSequence)"adjustment_reason_code") && seg.type() == SegmentType.CAS) {
            CarcRarcType codeSubType = CarcRarcType.CARC;
            return new CodeEntity(PrimaryCodeType.CARC_RARC, codeSubType, code);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)nm, (CharSequence)"remark_code")) {
            return new CodeEntity(PrimaryCodeType.CARC_RARC, CarcRarcType.RARC, code);
        }
        return null;
    }
}

