/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.cli;

import hdi.edi.cli.CliException;
import hdi.edi.csv.CsvConversionException;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.InvalidEdiException;
import hdi.license.LicenseException;
import hdi.model.IllegalTransactionException;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import picocli.CommandLine;

class PrintExceptionMessageHandler
implements CommandLine.IExecutionExceptionHandler {
    PrintExceptionMessageHandler() {
    }

    public int handleExecutionException(Exception ex, CommandLine cmd, CommandLine.ParseResult parseResult) {
        if (ex instanceof CliException || ex instanceof EdiParserException || ex instanceof InvalidEdiException || ex instanceof LicenseException || ex instanceof IllegalTransactionException || ex instanceof CsvConversionException || ex instanceof IOException) {
            String msg = ex.getMessage();
            if (ex instanceof IOException) {
                msg = ExceptionUtils.getStackTrace((Throwable)ex);
            }
            cmd.getErr().println(cmd.getColorScheme().errorText(msg));
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : cmd.getCommandSpec().exitCodeOnExecutionException();
        }
        throw new CliException("Unexpected error, please contact support", (Throwable)ex, new Object[0]);
    }
}

