/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeent;

import hdi.codeent.CodeEntity;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.enumtype.ProviderTaxonomyType;
import hdi.util.SearchWordsUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class NormalizedCodeEntity {
    public static final String UNKNOWN_CODE_DESC = "Unknown code?";
    public static final Collection<String> UNKNOWN_CODE_DESC_WORDS = SearchWordsUtils.tokenizeTextFields(List.of("Unknown code?"));
    private String code;
    private String formattedCode;
    private String description;
    private String shortDescription;
    private EdiQualifier subType;
    private Set<String> searchWords;
    private List<CodeEntity> categories;
    private int lineCount = 0;
    private BigDecimal chargeAmount;
    private BigDecimal paymentAmount;
    private BigDecimal adjustmentAmount;

    public NormalizedCodeEntity() {
    }

    public NormalizedCodeEntity(CodeEntity codeEntity) {
        this.code = codeEntity.code();
        this.formattedCode = codeEntity.formattedCode();
        this.description = StringUtils.stripToNull((String)codeEntity.desc());
        this.shortDescription = StringUtils.stripToNull((String)codeEntity.shortDesc());
        this.subType = codeEntity.subType();
        this.searchWords = codeEntity.prepSearchWords();
        if (this.description == null && !(codeEntity.subType() instanceof ProviderTaxonomyType)) {
            this.description = UNKNOWN_CODE_DESC;
            this.searchWords.addAll(UNKNOWN_CODE_DESC_WORDS);
        }
        this.categories = codeEntity.categories();
    }

    public void merge(CodeEntity codeEntity) {
        this.searchWords.addAll(codeEntity.prepSearchWords());
    }

    @Generated
    public String code() {
        return this.code;
    }

    @Generated
    public String formattedCode() {
        return this.formattedCode;
    }

    @Generated
    public String description() {
        return this.description;
    }

    @Generated
    public String shortDescription() {
        return this.shortDescription;
    }

    @Generated
    public EdiQualifier subType() {
        return this.subType;
    }

    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }

    @Generated
    public List<CodeEntity> categories() {
        return this.categories;
    }

    @Generated
    public int lineCount() {
        return this.lineCount;
    }

    @Generated
    public BigDecimal chargeAmount() {
        return this.chargeAmount;
    }

    @Generated
    public BigDecimal paymentAmount() {
        return this.paymentAmount;
    }

    @Generated
    public BigDecimal adjustmentAmount() {
        return this.adjustmentAmount;
    }

    @Generated
    public String toString() {
        return "NormalizedCodeEntity(code=" + this.code() + ", formattedCode=" + this.formattedCode() + ", description=" + this.description() + ", shortDescription=" + this.shortDescription() + ", subType=" + String.valueOf(this.subType()) + ", searchWords=" + String.valueOf(this.searchWords()) + ", categories=" + String.valueOf(this.categories()) + ", lineCount=" + this.lineCount() + ", chargeAmount=" + String.valueOf(this.chargeAmount()) + ", paymentAmount=" + String.valueOf(this.paymentAmount()) + ", adjustmentAmount=" + String.valueOf(this.adjustmentAmount()) + ")";
    }

    @Generated
    public NormalizedCodeEntity lineCount(int lineCount) {
        this.lineCount = lineCount;
        return this;
    }

    @Generated
    public NormalizedCodeEntity chargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @Generated
    public NormalizedCodeEntity paymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
        return this;
    }

    @Generated
    public NormalizedCodeEntity adjustmentAmount(BigDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
        return this;
    }
}

