/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import hdi.codeedit.CodeEditRule;
import hdi.codeent.CategoriesRenderingInfo;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.dict.VariantType;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.DataType;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.ServiceLine;
import hdi.model.enumtype.DrugIdentificationType;
import hdi.model.enumtype.ModifierType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ProviderTaxonomyType;
import hdi.model.enumtype.RbcsCategoryType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UbCodeType;
import hdi.util.FormattingUtils;
import hdi.util.NdcUtils;
import hdi.util.SearchWordsPrefix;
import hdi.util.SearchWordsUtils;
import hdi.util.WordStringUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class CodeEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeEntity.class);
    public static final String TYPE_NAME = "type";
    public static final String SUB_TYPE_NAME = "subType";
    @EdiElt.Exclude
    @JsonIgnore
    private String id;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private int index;
    @Transient
    @JsonIgnore
    private EltSet eltSet;
    @EdiElt.Exclude
    private String enumName;
    @EdiElt.Exclude
    private PrimaryCodeType type;
    @EdiElt.Exclude
    @Prop(desc={"Healthcare code subtype, such as CPT, HCPCS, ICD_10, NDC"}, objType=ObjType.STRING, isRequired=true)
    private EdiQualifier subType;
    @EdiElt.Exclude
    @Prop(desc={"Healthcare code"}, isRequired=true)
    private String code;
    @EdiElt.Exclude
    @Prop(desc={"Code description "})
    private String desc;
    @EdiElt.Exclude
    private String fullDesc;
    @EdiElt.Exclude
    private String instructionDesc;
    @EdiElt.Exclude
    private String shortDesc;
    @EdiElt.Exclude
    @JsonIgnore
    private String category;
    @EdiElt.Exclude
    private LocalDate startDate;
    @EdiElt.Exclude
    private LocalDate endDate;
    @EdiElt.Exclude
    private String formattedCode;
    @Prop(tran={TransactionType.INST}, edi={"HI01-9"}, variantTypes={VariantType.INST_DIAGNOSIS})
    private String presentOnAdmissionIndicator;
    @Prop(tran={TransactionType.INST}, edi={"HI01-4"}, relatedFieldName="occurrenceEndDate", variantTypes={VariantType.CODE_DATE}, isRequired=true)
    @EdiElt(value={"date_time_period", "date"})
    private LocalDate occurrenceDate;
    @EdiElt(value={"date_time_period_to", "date_to"})
    private LocalDate occurrenceEndDate;
    @Prop(tran={TransactionType.INST}, edi={"HI01-5"}, variantTypes={VariantType.CODE_AMOUNT}, isDerived=true)
    @EdiElt(value={"value_code_amount"})
    private BigDecimal amount;
    @EdiElt(value={"description"})
    private String descFromClaim;
    private String issuingOrg;
    @EdiElt.Exclude
    @Prop(edi={"SV101-3-6,SV201-3-6,SVC01-3-6"}, isDerived=true, objType=ObjType.CODE, codeTypeFieldFilter=PrimaryCodeType.PROCEDURE)
    private List<CodeEntity> modifiers;
    @EdiElt.Exclude
    @JsonIgnore
    private Set<String> searchWords;
    @JsonIgnore
    private Boolean isModifiersAllowed;
    @JsonProperty(value="edits")
    private CodeEditRule editsHolder;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private ServiceLine line;
    @EdiElt.Exclude
    private List<CodeEntity> categories;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private String fileName;
    @JsonIgnore
    private LocalDateTime createTimestamp;

    public CodeEntity(PrimaryCodeType primaryCodeType) {
        this.type = primaryCodeType;
    }

    public CodeEntity(PrimaryCodeType primaryCodeType, EdiQualifier ediQualifier, String code) {
        this(ediQualifier, code);
        this.type = primaryCodeType;
    }

    public CodeEntity(EdiQualifier ediQualifier, String code) {
        this.code = code = StringUtils.strip((String)code);
        this.subType = this.adjustQualifierBasedOnCode(ediQualifier, code);
    }

    public CodeEntity(CodeEntity anotherCodeEntity) {
        this.id = anotherCodeEntity.id;
        this.index = anotherCodeEntity.index;
        this.code = anotherCodeEntity.code;
        this.desc = anotherCodeEntity.desc;
        this.fullDesc = anotherCodeEntity.fullDesc;
        this.instructionDesc = anotherCodeEntity.instructionDesc;
        this.shortDesc = anotherCodeEntity.shortDesc;
        this.category = anotherCodeEntity.category;
        this.startDate = anotherCodeEntity.startDate;
        this.endDate = anotherCodeEntity.endDate;
        this.formattedCode = anotherCodeEntity.formattedCode;
        this.presentOnAdmissionIndicator = anotherCodeEntity.presentOnAdmissionIndicator;
        this.occurrenceDate = anotherCodeEntity.occurrenceDate;
        this.occurrenceEndDate = anotherCodeEntity.occurrenceEndDate;
        this.amount = anotherCodeEntity.amount;
        this.descFromClaim = anotherCodeEntity.descFromClaim;
        this.issuingOrg = anotherCodeEntity.issuingOrg;
        this.modifiers = anotherCodeEntity.modifiers;
        this.isModifiersAllowed = anotherCodeEntity.isModifiersAllowed;
        this.line = anotherCodeEntity.line;
        this.categories = anotherCodeEntity.categories;
        this.fileName = anotherCodeEntity.fileName;
    }

    public String id() {
        return CodeEntity.createId(this.subType, this.code);
    }

    public String presentOnAdmissionIndicatorAsYesNo() {
        return WordStringUtils.decodeYN(this.presentOnAdmissionIndicator);
    }

    public static String createId(EdiQualifier q, String code) {
        String s = q != null ? q.name() + ":" : "";
        return s + code;
    }

    @JsonIgnore
    public boolean isModifiersAllowed() {
        return this.isModifiersAllowed != null && this.isModifiersAllowed != false;
    }

    public String codeAndType() {
        return this.code + this.subType.getClass().getName();
    }

    @JsonIgnore
    public boolean isUnknownCode() {
        return this.desc == null;
    }

    public boolean containsCategory(CodeEntity catCodeEnt) {
        if (this.categories == null) {
            return false;
        }
        for (CodeEntity cat : this.categories) {
            if (!CodeEntity.isSameCode(cat, catCodeEnt)) continue;
            return true;
        }
        return false;
    }

    public Set<String> prepSearchWords() {
        List<String> textFields = WordStringUtils.createList(this.code, this.formattedCode, this.desc, this.header(), this.descFromClaim, this.subType.desc(), this.subType.shortDesc(), this.enumName);
        if (this.modifiers != null && !this.modifiers.isEmpty()) {
            for (CodeEntity modEnt : this.modifiers) {
                textFields.add(modEnt.code());
            }
        }
        Set<String> searchWords = SearchWordsUtils.tokenizeTextFields(textFields);
        SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.SUBTYPE, this.subType.name());
        searchWords.add(EdiQualifier.enumNameToNameWithDashes(this.subType.name()));
        if (this.editsHolder != null) {
            searchWords.addAll(this.editsHolder.prepSearchWordsWithPTPCodes());
        }
        if (!(this.subType instanceof ProviderTaxonomyType) && !(this.subType instanceof RbcsCategoryType)) {
            searchWords.add(StringUtils.toRootLowerCase((String)this.formattedCode()));
            SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.CODE, this.code);
            SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.CODE, this.formattedCode);
            if (this.subType instanceof DrugIdentificationType) {
                String ndc54ProductCode = NdcUtils.productNdcTo54(this.code);
                searchWords.add(ndc54ProductCode);
                SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.CODE, ndc54ProductCode);
            }
        }
        if (this.categories != null) {
            for (CodeEntity cat : this.categories) {
                Set<String> catSearchWords = cat.prepSearchWords();
                searchWords.addAll(cat.prepSearchWords());
                SearchWordsUtils.addWordsWithPrefix(searchWords, SearchWordsPrefix.CAT, catSearchWords);
            }
        }
        SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.CODEDATE, this.startDate);
        if (this.subType != null) {
            SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.CAT, this.subType.name());
        }
        if (this.type != null) {
            SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.CAT, this.type.name());
        }
        return searchWords;
    }

    public String formattedCode() {
        if (StringUtils.isBlank((CharSequence)this.formattedCode)) {
            return this.code;
        }
        return this.formattedCode;
    }

    public String codeAndDescription() {
        return FormattingUtils.formatCodeDesc(this.formattedCode(), this.desc);
    }

    public String codeTypeAndDesc() {
        String s = this.formattedCode();
        s = FormattingUtils.concat(s, this.subType.desc(), " - ");
        s = FormattingUtils.concat(s, this.desc, " - ");
        return s;
    }

    @JsonIgnore
    public boolean isLineLevel() {
        return this.subType instanceof ProcType || this.subType instanceof UbCodeType && this.subType == UbCodeType.REVENUE_CODE || this.subType instanceof RbcsCategoryType;
    }

    public String header() {
        String code;
        Object header = "";
        if (this.subType != null) {
            header = (String)header + StringUtils.trim((String)this.subType.desc());
        }
        if ((code = this.formattedCode()) != null) {
            header = (String)header + " " + code;
        }
        return header;
    }

    public CodeEntity shortDesc(String shortDescription) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.desc, (CharSequence)shortDescription)) {
            this.shortDesc = shortDescription;
        }
        return this;
    }

    public String fullDescOrDesc() {
        return this.fullDesc != null ? this.fullDesc : this.desc;
    }

    public String shortDescOrDesc() {
        return this.shortDesc != null ? this.shortDesc : this.desc;
    }

    public boolean containsModifiers() {
        return this.modifiers != null && !this.modifiers.isEmpty();
    }

    public void mapFromEdi(List<Elt> elts) {
        for (Elt elt : elts) {
            if (elt.dataType() != DataType.STR || !StringUtils.endsWithIgnoreCase((CharSequence)elt.name(), (CharSequence)"modifier")) continue;
            String val = StringUtils.strip((String)elt.valAsStr());
            CodeEntity modifierCodeEnt = new CodeEntity(PrimaryCodeType.MODIFIER, ModifierType.HCPCS_MODIFIER, val);
            elt.codeEntity(modifierCodeEnt);
            this.addModifier(modifierCodeEnt);
        }
    }

    public void addModifiers(List<String> modifierCodes) {
        for (String modifierCode : modifierCodes) {
            this.addModifier(modifierCode);
        }
    }

    public void addModifier(String modifierCode) {
        this.addModifier(new CodeEntity(PrimaryCodeType.MODIFIER, ModifierType.HCPCS_MODIFIER, modifierCode));
    }

    public void addModifier(CodeEntity modifierCodeEnt) {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<CodeEntity>();
        }
        this.modifiers.add(modifierCodeEnt);
    }

    public EdiQualifier adjustQualifierBasedOnCode(EdiQualifier qualifier, String code) {
        if (qualifier == null) {
            return null;
        }
        if (qualifier == ProcType.HCPCS && StringUtils.length((CharSequence)code) == 5 && StringUtils.isNumeric((CharSequence)StringUtils.left((String)code, (int)1))) {
            return ProcType.CPT;
        }
        return qualifier;
    }

    public static boolean isSameCode(CodeEntity codeEnt1, CodeEntity codeEnt2) {
        if (codeEnt1 == null || codeEnt2 == null) {
            return false;
        }
        if (codeEnt1.subType().getClass() != codeEnt2.subType().getClass()) {
            return false;
        }
        return codeEnt1.code().equals(codeEnt2.code());
    }

    public Set<String> modifierCodes() {
        if (this.modifiers == null) {
            return Set.of();
        }
        return this.modifiers.stream().map(CodeEntity::code).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @JsonIgnore
    public boolean isWithoutDesc() {
        return this.subType() instanceof ProviderTaxonomyType || CodeEntity.isNotLoadedDataSet(this.subType());
    }

    @JsonIgnore
    public boolean isDoNotResolve() {
        return this.subType() == null || CodeEntity.isNotLoadedDataSet(this.subType());
    }

    @JsonIgnore
    public boolean isPresentOnAdmission() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.presentOnAdmissionIndicator, (CharSequence)"Y");
    }

    @JsonIgnore
    public CodeEntity isPresentOnAdmission(boolean value) {
        this.presentOnAdmissionIndicator = value ? "Y" : "N";
        return this;
    }

    public static boolean isNotLoadedDataSet(EdiQualifier ediQualifier) {
        return ediQualifier == ProcType.HIPPS || ediQualifier == ProcType.ABC || ediQualifier == UbCodeType.PLACE_OF_SERVICE || ediQualifier == UbCodeType.DRG;
    }

    @JsonIgnore
    public CategoriesRenderingInfo getCategoriesRenderingInfo() {
        if (this.categories == null || this.categories.isEmpty()) {
            return null;
        }
        String header = this.getHeaderForCategories(this);
        ArrayList<String> catLevelNames = new ArrayList<String>();
        ArrayList<String> catLevelValues = new ArrayList<String>();
        for (CodeEntity codeEnt : this.categories) {
            catLevelNames.add(codeEnt.subType().desc());
            String catLevelValue = codeEnt.desc();
            if (StringUtils.isBlank((CharSequence)catLevelValue)) {
                catLevelValue = codeEnt.code();
            }
            catLevelValues.add(catLevelValue);
        }
        String catLevelNamesPath = FormattingUtils.formatCategoriesPath(catLevelNames);
        String catLevelValuesPath = FormattingUtils.formatCategoriesPath(catLevelValues);
        return new CategoriesRenderingInfo(header, catLevelNamesPath, catLevelValuesPath);
    }

    private String getHeaderForCategories(CodeEntity codeEntity) {
        if (codeEntity.subType() == ReferenceType.PROVIDER_TAXONOMY) {
            return "Taxonomy Categories";
        }
        return "RBCS (BETOS) Classification";
    }

    public void trimNiceToHave() {
        this.categories = null;
        if (this.desc != null) {
            this.shortDesc = null;
            this.fullDesc = null;
        }
        this.startDate = null;
        this.endDate = null;
        if (this.modifiers != null) {
            this.modifiers.forEach(CodeEntity::trimNiceToHave);
        }
        if (this.type != null && this.subType != null) {
            this.type = null;
        }
    }

    public void addModifiers(Collection<String> modifierCodes) {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<CodeEntity>();
        }
        modifierCodes.forEach(code -> {
            CodeEntity modifierCodeEnt = new CodeEntity(PrimaryCodeType.MODIFIER, ModifierType.HCPCS_MODIFIER, (String)code);
            this.addModifier(modifierCodeEnt);
        });
    }

    @JsonIgnore
    @Generated
    public int index() {
        return this.index;
    }

    @JsonIgnore
    @Generated
    public EltSet eltSet() {
        return this.eltSet;
    }

    @Generated
    public String enumName() {
        return this.enumName;
    }

    @Generated
    public PrimaryCodeType type() {
        return this.type;
    }

    @Generated
    public EdiQualifier subType() {
        return this.subType;
    }

    @Generated
    public String code() {
        return this.code;
    }

    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public String fullDesc() {
        return this.fullDesc;
    }

    @Generated
    public String instructionDesc() {
        return this.instructionDesc;
    }

    @Generated
    public String shortDesc() {
        return this.shortDesc;
    }

    @JsonIgnore
    @Generated
    public String category() {
        return this.category;
    }

    @Generated
    public LocalDate startDate() {
        return this.startDate;
    }

    @Generated
    public LocalDate endDate() {
        return this.endDate;
    }

    @Generated
    public String presentOnAdmissionIndicator() {
        return this.presentOnAdmissionIndicator;
    }

    @Generated
    public LocalDate occurrenceDate() {
        return this.occurrenceDate;
    }

    @Generated
    public LocalDate occurrenceEndDate() {
        return this.occurrenceEndDate;
    }

    @Generated
    public BigDecimal amount() {
        return this.amount;
    }

    @Generated
    public String descFromClaim() {
        return this.descFromClaim;
    }

    @Generated
    public String issuingOrg() {
        return this.issuingOrg;
    }

    @Generated
    public List<CodeEntity> modifiers() {
        return this.modifiers;
    }

    @JsonIgnore
    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }

    @JsonProperty(value="edits")
    @Generated
    public CodeEditRule editsHolder() {
        return this.editsHolder;
    }

    @JsonIgnore
    @Generated
    public ServiceLine line() {
        return this.line;
    }

    @Generated
    public List<CodeEntity> categories() {
        return this.categories;
    }

    @JsonIgnore
    @Generated
    public String fileName() {
        return this.fileName;
    }

    @JsonIgnore
    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @JsonIgnore
    @Generated
    public CodeEntity id(String id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity index(int index) {
        this.index = index;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity eltSet(EltSet eltSet) {
        this.eltSet = eltSet;
        return this;
    }

    @Generated
    public CodeEntity enumName(String enumName) {
        this.enumName = enumName;
        return this;
    }

    @Generated
    public CodeEntity type(PrimaryCodeType type) {
        this.type = type;
        return this;
    }

    @Generated
    public CodeEntity subType(EdiQualifier subType) {
        this.subType = subType;
        return this;
    }

    @Generated
    public CodeEntity code(String code) {
        this.code = code;
        return this;
    }

    @Generated
    public CodeEntity desc(String desc) {
        this.desc = desc;
        return this;
    }

    @Generated
    public CodeEntity fullDesc(String fullDesc) {
        this.fullDesc = fullDesc;
        return this;
    }

    @Generated
    public CodeEntity instructionDesc(String instructionDesc) {
        this.instructionDesc = instructionDesc;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity category(String category) {
        this.category = category;
        return this;
    }

    @Generated
    public CodeEntity startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Generated
    public CodeEntity endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Generated
    public CodeEntity formattedCode(String formattedCode) {
        this.formattedCode = formattedCode;
        return this;
    }

    @Generated
    public CodeEntity presentOnAdmissionIndicator(String presentOnAdmissionIndicator) {
        this.presentOnAdmissionIndicator = presentOnAdmissionIndicator;
        return this;
    }

    @Generated
    public CodeEntity occurrenceDate(LocalDate occurrenceDate) {
        this.occurrenceDate = occurrenceDate;
        return this;
    }

    @Generated
    public CodeEntity occurrenceEndDate(LocalDate occurrenceEndDate) {
        this.occurrenceEndDate = occurrenceEndDate;
        return this;
    }

    @Generated
    public CodeEntity amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Generated
    public CodeEntity descFromClaim(String descFromClaim) {
        this.descFromClaim = descFromClaim;
        return this;
    }

    @Generated
    public CodeEntity issuingOrg(String issuingOrg) {
        this.issuingOrg = issuingOrg;
        return this;
    }

    @Generated
    public CodeEntity modifiers(List<CodeEntity> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity searchWords(Set<String> searchWords) {
        this.searchWords = searchWords;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity isModifiersAllowed(Boolean isModifiersAllowed) {
        this.isModifiersAllowed = isModifiersAllowed;
        return this;
    }

    @JsonProperty(value="edits")
    @Generated
    public CodeEntity editsHolder(CodeEditRule editsHolder) {
        this.editsHolder = editsHolder;
        return this;
    }

    @Generated
    public CodeEntity categories(List<CodeEntity> categories) {
        this.categories = categories;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public String toString() {
        return "CodeEntity(id=" + this.id() + ", index=" + this.index() + ", type=" + String.valueOf((Object)this.type()) + ", subType=" + String.valueOf(this.subType()) + ", code=" + this.code() + ", desc=" + this.desc() + ", fullDesc=" + this.fullDesc() + ", instructionDesc=" + this.instructionDesc() + ", shortDesc=" + this.shortDesc() + ", category=" + this.category() + ", startDate=" + String.valueOf(this.startDate()) + ", endDate=" + String.valueOf(this.endDate()) + ", formattedCode=" + this.formattedCode() + ", presentOnAdmissionIndicator=" + this.presentOnAdmissionIndicator() + ", occurrenceDate=" + String.valueOf(this.occurrenceDate()) + ", occurrenceEndDate=" + String.valueOf(this.occurrenceEndDate()) + ", amount=" + String.valueOf(this.amount()) + ", descFromClaim=" + this.descFromClaim() + ", isModifiersAllowed=" + this.isModifiersAllowed() + ", editsHolder=" + String.valueOf(this.editsHolder()) + ", fileName=" + this.fileName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeEntity)) {
            return false;
        }
        CodeEntity other = (CodeEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.index() != other.index()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PrimaryCodeType this$type = this.type();
        PrimaryCodeType other$type = other.type();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EdiQualifier this$subType = this.subType();
        EdiQualifier other$subType = other.subType();
        if (this$subType == null ? other$subType != null : !this$subType.equals(other$subType)) {
            return false;
        }
        String this$code = this.code();
        String other$code = other.code();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodeEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index();
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PrimaryCodeType $type = this.type();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EdiQualifier $subType = this.subType();
        result = result * 59 + ($subType == null ? 43 : $subType.hashCode());
        String $code = this.code();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    @Generated
    public CodeEntity() {
    }

    @JsonIgnore
    @Generated
    public CodeEntity line(ServiceLine line) {
        this.line = line;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEntity createTimestamp(LocalDateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
    }
}

