/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeedit;

import hdi.codeedit.Issue;
import hdi.codeedit.Severity;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class QualityScore {
    private Map<Severity, Integer> countBySeverity = new HashMap<Severity, Integer>();
    private Severity maxSeverity;
    private int score;
    private int issuesCount = 0;

    public void updateFromIssues(Collection<Issue> issues) {
        for (Issue issue : issues) {
            Integer severityCount;
            Severity curSeverity = issue.severity();
            if (this.maxSeverity == null || issue.severity().weight() > this.maxSeverity().weight()) {
                this.maxSeverity = issue.severity();
            }
            if ((severityCount = this.countBySeverity.get((Object)curSeverity)) == null) {
                severityCount = 0;
            }
            severityCount = severityCount + 1;
            this.countBySeverity.put(curSeverity, severityCount);
            ++this.issuesCount;
        }
        this.score = this.calcScore();
    }

    private int calcScore() {
        int score = 0;
        for (Severity severity : this.countBySeverity.keySet()) {
            int sevScore = severity.weight() * this.countBySeverity.getOrDefault((Object)severity, 0);
            score += sevScore;
        }
        return score;
    }

    @Generated
    public Map<Severity, Integer> countBySeverity() {
        return this.countBySeverity;
    }

    @Generated
    public Severity maxSeverity() {
        return this.maxSeverity;
    }

    @Generated
    public int score() {
        return this.score;
    }

    @Generated
    public int issuesCount() {
        return this.issuesCount;
    }

    @Generated
    public String toString() {
        return "QualityScore(countBySeverity=" + String.valueOf(this.countBySeverity()) + ", maxSeverity=" + String.valueOf((Object)this.maxSeverity()) + ", score=" + this.score() + ", issuesCount=" + this.issuesCount() + ")";
    }
}

