/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeedit;

import hdi.codeedit.Check;
import hdi.codeedit.Severity;
import hdi.codeedit.ViolationConfidence;
import hdi.codeent.CodeEntity;
import hdi.model.orgperson.OrgOrPerson;
import lombok.Generated;

public class Issue {
    private Check check;
    private Severity severity = Severity.HIGH;
    private CodeEntity codeEntity;
    private String fieldName;
    private String message;
    private String lineId;
    private OrgOrPerson orgOrPerson;
    private ViolationConfidence confidence = ViolationConfidence.HIGH;

    public String getType() {
        return this.check.type().desc();
    }

    public String getCode() {
        return this.codeEntity.code();
    }

    public Issue(Check check) {
        this.check = check;
    }

    public Issue(Check check, String message, CodeEntity codeEntity) {
        this(check);
        this.message = message;
        this.codeEntity = codeEntity;
    }

    public Issue(Check check, String fieldName) {
        this(check);
        this.fieldName = fieldName;
    }

    public Issue(Check check, String fieldName, Severity severity) {
        this(check, fieldName);
        this.severity = severity;
    }

    public Issue(Check check, String message, String fieldName) {
        this(check);
        this.fieldName = fieldName;
        this.message = message;
    }

    public Issue(Check check, ViolationConfidence confidence, String message, CodeEntity codeEntity) {
        this(check, message, codeEntity);
        this.confidence = confidence;
    }

    public String toFriendlyString() {
        StringBuilder s = new StringBuilder(this.check.description());
        if (this.codeEntity != null) {
            s.append(" Code: ");
            s.append(this.codeEntity.code());
        } else if (this.fieldName != null) {
            s.append(" Field: ");
            s.append(this.fieldName);
        }
        s.append(" ");
        s.append((Object)this.check.type());
        s.append(" ");
        if (this.lineId != null) {
            s.append(" Line: ");
            s.append(this.lineId);
        }
        if (this.orgOrPerson != null) {
            s.append(" Failed entity: ");
            s.append(this.orgOrPerson.idNameRole());
        }
        if (this.message != null) {
            s.append(" ").append(this.message);
        }
        return s.toString();
    }

    @Generated
    public String toString() {
        return "Issue(check=" + String.valueOf(this.check()) + ", severity=" + String.valueOf((Object)this.severity()) + ", codeEntity=" + String.valueOf(this.codeEntity()) + ", fieldName=" + this.fieldName() + ", message=" + this.message() + ", lineId=" + this.lineId() + ", orgOrPerson=" + String.valueOf(this.orgOrPerson()) + ", confidence=" + String.valueOf((Object)this.confidence()) + ")";
    }

    @Generated
    public Check check() {
        return this.check;
    }

    @Generated
    public Severity severity() {
        return this.severity;
    }

    @Generated
    public CodeEntity codeEntity() {
        return this.codeEntity;
    }

    @Generated
    public String fieldName() {
        return this.fieldName;
    }

    @Generated
    public String message() {
        return this.message;
    }

    @Generated
    public String lineId() {
        return this.lineId;
    }

    @Generated
    public OrgOrPerson orgOrPerson() {
        return this.orgOrPerson;
    }

    @Generated
    public ViolationConfidence confidence() {
        return this.confidence;
    }

    @Generated
    public Issue() {
    }

    @Generated
    public Issue severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Generated
    public Issue codeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
        return this;
    }

    @Generated
    public Issue fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Generated
    public Issue message(String message) {
        this.message = message;
        return this;
    }

    @Generated
    public Issue lineId(String lineId) {
        this.lineId = lineId;
        return this;
    }

    @Generated
    public Issue orgOrPerson(OrgOrPerson orgOrPerson) {
        this.orgOrPerson = orgOrPerson;
        return this;
    }
}

