/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeedit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import hdi.codeedit.CodeEditRuleCsv;
import hdi.codeedit.EditCodeEntityHolder;
import hdi.codeedit.EditsClaimType;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.model.enumtype.ProcType;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeRestriction
implements EditCodeEntityHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeRestriction.class);
    private String code;
    @JsonProperty(value="modifierAllowed")
    private boolean isModifierAllowed = false;
    private String rationale;
    @JsonIgnore
    private CodeEntity codeEntity;
    private Set<EditsClaimType> claimTypes = new HashSet<EditsClaimType>();

    public static CodeRestriction fromCsv(CodeEditRuleCsv csvRecord) {
        if (csvRecord.secondCode() == null || csvRecord.modifierAllowedCode() == 9) {
            return null;
        }
        CodeRestriction codeRestriction = new CodeRestriction();
        codeRestriction.code = csvRecord.secondCode();
        if (csvRecord.modifierAllowedCode() == 1) {
            codeRestriction.isModifierAllowed = true;
        } else if (csvRecord.modifierAllowedCode() != 0) {
            log.warn("Unknown value for modifiers in PTP: {}", (Object)csvRecord);
        }
        codeRestriction.rationale = csvRecord.ptpRationale();
        codeRestriction.claimTypes.add(csvRecord.claimType());
        return codeRestriction;
    }

    public void setCodeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
    }

    @Override
    public CodeEntity getCodeEntity() {
        if (this.codeEntity == null) {
            this.codeEntity = new CodeEntity(PrimaryCodeType.PROCEDURE, ProcType.HCPCS, this.code);
        }
        this.codeEntity.isModifiersAllowed(this.isModifierAllowed);
        return this.codeEntity;
    }

    public Set<String> prepSearchTokens() {
        HashSet<String> tokens = new HashSet<String>();
        if (this.rationale != null) {
            tokens.add(this.rationale);
        }
        if (this.code != null) {
            tokens.add(this.code);
        }
        if (this.isModifierAllowed) {
            tokens.add("[M]");
        }
        return tokens;
    }

    @Override
    @Generated
    public String code() {
        return this.code;
    }

    @JsonProperty(value="modifierAllowed")
    @Generated
    public boolean isModifierAllowed() {
        return this.isModifierAllowed;
    }

    @Generated
    public String rationale() {
        return this.rationale;
    }

    @JsonIgnore
    @Generated
    public CodeEntity codeEntity() {
        return this.codeEntity;
    }

    @Generated
    public Set<EditsClaimType> claimTypes() {
        return this.claimTypes;
    }

    @Generated
    public CodeRestriction() {
    }

    @Generated
    public String toString() {
        return "CodeRestriction(code=" + this.code() + ", isModifierAllowed=" + this.isModifierAllowed() + ", rationale=" + this.rationale() + ", claimTypes=" + String.valueOf(this.claimTypes()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeRestriction)) {
            return false;
        }
        CodeRestriction other = (CodeRestriction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isModifierAllowed() != other.isModifierAllowed()) {
            return false;
        }
        String this$code = this.code();
        String other$code = other.code();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodeRestriction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isModifierAllowed() ? 79 : 97);
        String $code = this.code();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    @JsonProperty(value="modifierAllowed")
    @Generated
    public CodeRestriction isModifierAllowed(boolean isModifierAllowed) {
        this.isModifierAllowed = isModifierAllowed;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeRestriction codeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
        return this;
    }
}

