/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeedit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import hdi.codeedit.CheckType;
import hdi.codeedit.CodeEditRuleCsv;
import hdi.codeedit.CodeRestriction;
import hdi.codeedit.EditCodeEntityHolder;
import hdi.codeedit.EditsClaimType;
import hdi.codeedit.MueLimit;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.model.enumtype.ProcType;
import hdi.util.SearchWordsPrefix;
import hdi.util.SearchWordsUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeEditRule
implements EditCodeEntityHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeEditRule.class);
    @JsonIgnore
    private String id = ObjectId.get().toHexString();
    private String code;
    @JsonIgnore
    private PrimaryCodeType codeType = PrimaryCodeType.PROCEDURE;
    @Transient
    private String manifestationPrinDiag;
    @Transient
    private String unacceptablePrinDiag;
    @Transient
    private String questionableAdmissionDiag;
    @Transient
    private String unspecifiedDiag;
    private String fileName;
    private Set<MueLimit> mueLimits;
    @JsonIgnore
    private int maxMueValue = -1;
    @JsonIgnore
    private int minAge = -1;
    @JsonIgnore
    private int maxAge = -1;
    private String gender;
    private List<CheckType> checkTypes;
    private CodeEntity codeEntity;
    private List<CodeRestriction> disallowedCodes;
    @JsonIgnore
    private int ptpCount;
    @JsonIgnore
    @Transient
    private final Map<String, CodeRestriction> restrictionsByCode = new HashMap<String, CodeRestriction>();
    @JsonIgnore
    private Set<String> searchWords;
    private LocalDateTime createTimestamp;

    public static CodeEditRule fromCsv(CodeEditRuleCsv csvRecord) {
        CodeRestriction codeRestriction;
        CodeEditRule codeEditRule = new CodeEditRule();
        if (csvRecord.firstCode() != null) {
            csvRecord.code(csvRecord.firstCode());
        }
        codeEditRule.code = StringUtils.stripToNull((String)csvRecord.code());
        codeEditRule.minAge = csvRecord.minAge();
        codeEditRule.maxAge = csvRecord.maxAge();
        codeEditRule.gender = csvRecord.gender();
        if (csvRecord.maxUnits() >= 0) {
            codeEditRule.createMue(csvRecord);
        }
        if ((codeRestriction = CodeRestriction.fromCsv(csvRecord)) != null) {
            codeEditRule.mergeRestriction(codeRestriction);
        }
        return codeEditRule;
    }

    public static CodeEditRule fromCodeRestrictionFields(String codeForTheRule, String restrictedCode, boolean isModifierAllowed, EditsClaimType claimType) {
        CodeEditRuleCsv csvRecord = new CodeEditRuleCsv();
        csvRecord.code(codeForTheRule).secondCode(restrictedCode).modifierAllowedCode(isModifierAllowed ? 1 : 0).claimType(claimType);
        return CodeEditRule.fromCsv(csvRecord);
    }

    public List<CodeRestriction> codeRestrictionsForClaimType(EditsClaimType claimType) {
        ArrayList<CodeRestriction> restrictions = new ArrayList<CodeRestriction>();
        for (CodeRestriction restriction : this.disallowedCodes) {
            if (restriction.claimTypes() != null && !restriction.claimTypes().isEmpty() && !restriction.claimTypes().contains((Object)claimType)) continue;
            restrictions.add(restriction);
        }
        return restrictions;
    }

    public void postRead() {
        if (this.manifestationPrinDiag != null && this.code == null) {
            this.code = this.manifestationPrinDiag;
        } else if (this.unacceptablePrinDiag != null && this.code == null) {
            this.code = this.unacceptablePrinDiag;
        } else if (this.questionableAdmissionDiag != null && this.code == null) {
            this.code = this.questionableAdmissionDiag;
        } else if (this.unspecifiedDiag != null && this.code == null) {
            this.code = this.unspecifiedDiag;
        }
        this.code = StringUtils.stripToNull((String)this.code);
        this.updateEditTypes();
    }

    private void createMue(CodeEditRuleCsv anotherEdit) {
        MueLimit mueLimit = new MueLimit(anotherEdit.claimType(), anotherEdit.maxUnits(), anotherEdit.mueRationale());
        if (this.mueLimits == null) {
            this.mueLimits = new LinkedHashSet<MueLimit>();
        }
        this.mueLimits.add(mueLimit);
        this.maxMueValue = this.getMaxMueValue();
    }

    public void setCodeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
    }

    public void merge(CodeEditRule anotherEdit) {
        if (anotherEdit.disallowedCodes != null) {
            for (CodeRestriction cr : anotherEdit.disallowedCodes) {
                this.mergeRestriction(cr);
            }
        }
        this.codeType = anotherEdit.codeType;
        if (anotherEdit.mueLimits != null && !anotherEdit.mueLimits.isEmpty()) {
            this.mergeMues(anotherEdit);
        }
        if (anotherEdit.minAge() >= 0) {
            this.minAge = anotherEdit.minAge();
        }
        if (anotherEdit.maxAge() >= 0) {
            this.maxAge = anotherEdit.maxAge();
        }
        if (anotherEdit.gender != null) {
            this.gender = anotherEdit.gender;
        }
        if (anotherEdit.unacceptablePrinDiag != null) {
            this.unacceptablePrinDiag = anotherEdit.unacceptablePrinDiag;
        }
        if (anotherEdit.manifestationPrinDiag != null) {
            this.manifestationPrinDiag = anotherEdit.manifestationPrinDiag;
        }
        if (anotherEdit.questionableAdmissionDiag != null) {
            this.questionableAdmissionDiag = anotherEdit.questionableAdmissionDiag;
        }
        if (anotherEdit.unspecifiedDiag != null) {
            this.unspecifiedDiag = anotherEdit.unspecifiedDiag;
        }
        this.updateEditTypes();
    }

    private void mergeMues(CodeEditRule anotherEdit) {
        if (this.mueLimits == null) {
            this.mueLimits = anotherEdit.mueLimits;
        } else {
            this.mueLimits.addAll(anotherEdit.mueLimits);
        }
        this.maxMueValue = this.getMaxMueValue();
    }

    private Set<MueLimit> getMueWithDiffValues() {
        LinkedHashSet<MueLimit> mueLimitsWithDiffValues = new LinkedHashSet<MueLimit>();
        HashSet<Integer> vals = new HashSet<Integer>();
        for (MueLimit mueLimit : this.mueLimits) {
            vals.add(mueLimit.maxUnits());
            if (vals.size() <= 1) continue;
            mueLimitsWithDiffValues.add(mueLimit);
        }
        return mueLimitsWithDiffValues;
    }

    public int getMaxMueValue() {
        if (this.mueLimits == null || this.mueLimits.isEmpty()) {
            return -1;
        }
        int maxVal = -1;
        for (MueLimit mueLimit : this.mueLimits) {
            if (mueLimit.maxUnits() <= maxVal) continue;
            maxVal = mueLimit.maxUnits();
        }
        return maxVal;
    }

    public int getMaxUnitsForClaimType(EditsClaimType claimType) {
        if (this.mueLimits == null || this.mueLimits.isEmpty()) {
            return -1;
        }
        for (MueLimit mueLimit : this.mueLimits) {
            if (mueLimit.claimType() != claimType) continue;
            return mueLimit.maxUnits();
        }
        return -1;
    }

    public MueLimit getMueLimitForClaimTypeOrDME(EditsClaimType claimType) {
        if (this.mueLimits == null || this.mueLimits.isEmpty()) {
            return null;
        }
        MueLimit profOrInstLimit = null;
        MueLimit dmeLimit = null;
        for (MueLimit mueLimit : this.mueLimits) {
            if (mueLimit.claimType() == claimType) {
                profOrInstLimit = mueLimit;
            }
            if (mueLimit.claimType() != EditsClaimType.DME) continue;
            dmeLimit = mueLimit;
        }
        if (dmeLimit == null) {
            return profOrInstLimit;
        }
        if (profOrInstLimit == null || dmeLimit.maxUnits() > profOrInstLimit.maxUnits()) {
            return dmeLimit;
        }
        return profOrInstLimit;
    }

    public MueLimit getMueLimitForClaimType(EditsClaimType claimType) {
        if (this.mueLimits == null || this.mueLimits.isEmpty()) {
            return null;
        }
        MueLimit profOrInstLimit = null;
        for (MueLimit mueLimit : this.mueLimits) {
            if (mueLimit.claimType() != claimType) continue;
            profOrInstLimit = mueLimit;
        }
        return profOrInstLimit;
    }

    private void mergeRestriction(CodeRestriction newRestriction) {
        CodeRestriction restriction = this.restrictionsByCode.get(newRestriction.code());
        if (restriction == null) {
            this.restrictionsByCode().put(newRestriction.code(), newRestriction);
            if (this.disallowedCodes == null) {
                this.disallowedCodes = new ArrayList<CodeRestriction>();
            }
            this.disallowedCodes.add(newRestriction);
        } else {
            restriction.claimTypes().addAll(newRestriction.claimTypes());
        }
        this.ptpCount = this.disallowedCodes.size();
    }

    public String genderString() {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.gender, (CharSequence)"F")) {
            return "Female";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.gender, (CharSequence)"M")) {
            return "Male";
        }
        return "";
    }

    private void updateEditTypes() {
        this.checkTypes = this.deriveCheckTypes();
    }

    @Override
    @JsonIgnore
    public CodeEntity getCodeEntity() {
        if (this.codeEntity == null) {
            this.codeEntity = new CodeEntity(PrimaryCodeType.PROCEDURE, ProcType.HCPCS, this.code);
        }
        return this.codeEntity;
    }

    public List<CheckType> deriveCheckTypes() {
        ArrayList<CheckType> types = new ArrayList<CheckType>();
        if (this.mueLimits != null && !this.mueLimits().isEmpty()) {
            types.add(CheckType.MUE);
        }
        if (this.minAge >= 0) {
            types.add(CheckType.MIN_AGE);
        }
        if (this.maxAge >= 0) {
            types.add(CheckType.MAX_AGE);
        }
        if (this.gender != null) {
            types.add(CheckType.GENDER_EXCLUSION);
        }
        if (this.manifestationPrinDiag != null) {
            types.add(CheckType.MANIFESTATION_PRINCIPAL_DIAG_CODE);
        }
        if (this.unacceptablePrinDiag != null) {
            types.add(CheckType.UNACCEPTABLE_PRINCIPAL_DIAG_CODE);
        }
        if (this.questionableAdmissionDiag != null) {
            types.add(CheckType.QUESTIONABLE_ADMISSION_DIAG_CODE);
        }
        if (this.unspecifiedDiag != null) {
            types.add(CheckType.UNSPECIFIED_DIAG_CODE);
        }
        if (this.disallowedCodes != null && !this.disallowedCodes.isEmpty()) {
            types.add(CheckType.PTP);
        }
        return types;
    }

    public List<CheckType> checkTypes() {
        if (this.checkTypes == null) {
            return this.deriveCheckTypes();
        }
        return this.checkTypes;
    }

    public CodeRestriction findCodeRestriction(String code, EditsClaimType claimType) {
        for (CodeRestriction cr : this.disallowedCodes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)cr.code()) || !cr.claimTypes().contains((Object)claimType)) continue;
            return cr;
        }
        return null;
    }

    public String typesString() {
        return StringUtils.joinWith((String)", ", (Object[])new Object[]{this.checkTypes()});
    }

    public Set<String> prepSearchWords() {
        Set<String> tokens = this.prepSearchWordsWithoutPTP();
        HashSet<String> ptpTokens = new HashSet<String>();
        if (this.disallowedCodes != null) {
            for (CodeRestriction dc : this.disallowedCodes) {
                ptpTokens.addAll(dc.prepSearchTokens());
            }
            tokens.addAll(SearchWordsUtils.tokenizeTextFields(ptpTokens));
        }
        return tokens;
    }

    public Set<String> prepSearchWordsWithPTPCodes() {
        Set<String> tokens = this.prepSearchWordsWithoutPTP();
        Set<String> ptpTokens = this.prepPtpCodeSearchWords();
        tokens.addAll(ptpTokens);
        return tokens;
    }

    public Set<String> prepSearchWordsWithoutPTP() {
        HashSet<String> tokens = new HashSet<String>();
        if (this.codeEntity != null) {
            tokens.addAll(this.codeEntity.prepSearchWords());
        }
        this.addToSearchTokens(tokens, this.maxMueValue);
        this.addToSearchTokens(tokens, this.minAge);
        this.addToSearchTokens(tokens, this.maxAge);
        LinkedHashSet<String> checkTypeNamesForPrefixedSearch = new LinkedHashSet<String>();
        for (CheckType ct : this.checkTypes()) {
            tokens.add(ct.desc());
            tokens.add(ct.shortDesc());
            tokens.add(ct.checkCategory().desc());
            tokens.add(ct.nameForSearch());
            checkTypeNamesForPrefixedSearch.add(ct.nameForSearch());
        }
        Set<String> searchWords = SearchWordsUtils.tokenizeTextFields(tokens);
        if (!this.checkTypes().isEmpty()) {
            SearchWordsUtils.addWordsWithPrefix(searchWords, SearchWordsPrefix.EDIT, checkTypeNamesForPrefixedSearch);
        }
        return searchWords;
    }

    private Set<String> prepPtpCodeSearchWords() {
        HashSet<String> tokens = new HashSet<String>();
        if (this.disallowedCodes != null && !this.disallowedCodes.isEmpty()) {
            for (CodeRestriction ptp : this.disallowedCodes) {
                SearchWordsUtils.addWordWithPrefix(tokens, SearchWordsPrefix.PTP, ptp.code());
            }
        }
        return tokens;
    }

    private void addToSearchTokens(Set<String> tokens, int val) {
        if (val >= 0) {
            tokens.add(Integer.toString(val));
        }
    }

    public void setAgeRange(int minAge, int maxAge) {
        this.minAge = minAge;
        this.maxAge = maxAge;
    }

    @JsonGetter
    public Integer getMinAge() {
        if (this.minAge < 0) {
            return null;
        }
        return this.minAge;
    }

    @JsonGetter
    public Integer getMaxAge() {
        if (this.maxAge < 0) {
            return null;
        }
        return this.maxAge;
    }

    @JsonIgnore
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public String code() {
        return this.code;
    }

    @JsonIgnore
    @Generated
    public PrimaryCodeType codeType() {
        return this.codeType;
    }

    @Generated
    public String manifestationPrinDiag() {
        return this.manifestationPrinDiag;
    }

    @Generated
    public String unacceptablePrinDiag() {
        return this.unacceptablePrinDiag;
    }

    @Generated
    public String questionableAdmissionDiag() {
        return this.questionableAdmissionDiag;
    }

    @Generated
    public String unspecifiedDiag() {
        return this.unspecifiedDiag;
    }

    @Generated
    public String fileName() {
        return this.fileName;
    }

    @Generated
    public Set<MueLimit> mueLimits() {
        return this.mueLimits;
    }

    @JsonIgnore
    @Generated
    public int maxMueValue() {
        return this.maxMueValue;
    }

    @JsonIgnore
    @Generated
    public int minAge() {
        return this.minAge;
    }

    @JsonIgnore
    @Generated
    public int maxAge() {
        return this.maxAge;
    }

    @Generated
    public String gender() {
        return this.gender;
    }

    @Generated
    public CodeEntity codeEntity() {
        return this.codeEntity;
    }

    @Generated
    public List<CodeRestriction> disallowedCodes() {
        return this.disallowedCodes;
    }

    @JsonIgnore
    @Generated
    public int ptpCount() {
        return this.ptpCount;
    }

    @JsonIgnore
    @Generated
    public Map<String, CodeRestriction> restrictionsByCode() {
        return this.restrictionsByCode;
    }

    @JsonIgnore
    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }

    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public String toString() {
        return "CodeEditRule(id=" + this.id() + ", code=" + this.code() + ", codeType=" + String.valueOf((Object)this.codeType()) + ", manifestationPrinDiag=" + this.manifestationPrinDiag() + ", unacceptablePrinDiag=" + this.unacceptablePrinDiag() + ", questionableAdmissionDiag=" + this.questionableAdmissionDiag() + ", unspecifiedDiag=" + this.unspecifiedDiag() + ", mueLimits=" + String.valueOf(this.mueLimits()) + ", maxMueValue=" + this.maxMueValue() + ", minAge=" + this.minAge() + ", maxAge=" + this.maxAge() + ", gender=" + this.gender() + ", checkTypes=" + String.valueOf(this.checkTypes()) + ", disallowedCodes=" + String.valueOf(this.disallowedCodes()) + ", ptpCount=" + this.ptpCount() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeEditRule)) {
            return false;
        }
        CodeEditRule other = (CodeEditRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxMueValue() != other.maxMueValue()) {
            return false;
        }
        if (this.minAge() != other.minAge()) {
            return false;
        }
        if (this.maxAge() != other.maxAge()) {
            return false;
        }
        if (this.ptpCount() != other.ptpCount()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$code = this.code();
        String other$code = other.code();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        PrimaryCodeType this$codeType = this.codeType();
        PrimaryCodeType other$codeType = other.codeType();
        if (this$codeType == null ? other$codeType != null : !((Object)((Object)this$codeType)).equals((Object)other$codeType)) {
            return false;
        }
        String this$manifestationPrinDiag = this.manifestationPrinDiag();
        String other$manifestationPrinDiag = other.manifestationPrinDiag();
        if (this$manifestationPrinDiag == null ? other$manifestationPrinDiag != null : !this$manifestationPrinDiag.equals(other$manifestationPrinDiag)) {
            return false;
        }
        String this$unacceptablePrinDiag = this.unacceptablePrinDiag();
        String other$unacceptablePrinDiag = other.unacceptablePrinDiag();
        if (this$unacceptablePrinDiag == null ? other$unacceptablePrinDiag != null : !this$unacceptablePrinDiag.equals(other$unacceptablePrinDiag)) {
            return false;
        }
        String this$questionableAdmissionDiag = this.questionableAdmissionDiag();
        String other$questionableAdmissionDiag = other.questionableAdmissionDiag();
        if (this$questionableAdmissionDiag == null ? other$questionableAdmissionDiag != null : !this$questionableAdmissionDiag.equals(other$questionableAdmissionDiag)) {
            return false;
        }
        String this$unspecifiedDiag = this.unspecifiedDiag();
        String other$unspecifiedDiag = other.unspecifiedDiag();
        if (this$unspecifiedDiag == null ? other$unspecifiedDiag != null : !this$unspecifiedDiag.equals(other$unspecifiedDiag)) {
            return false;
        }
        String this$fileName = this.fileName();
        String other$fileName = other.fileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        Set<MueLimit> this$mueLimits = this.mueLimits();
        Set<MueLimit> other$mueLimits = other.mueLimits();
        if (this$mueLimits == null ? other$mueLimits != null : !((Object)this$mueLimits).equals(other$mueLimits)) {
            return false;
        }
        String this$gender = this.gender();
        String other$gender = other.gender();
        if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
            return false;
        }
        List<CheckType> this$checkTypes = this.checkTypes();
        List<CheckType> other$checkTypes = other.checkTypes();
        if (this$checkTypes == null ? other$checkTypes != null : !((Object)this$checkTypes).equals(other$checkTypes)) {
            return false;
        }
        CodeEntity this$codeEntity = this.codeEntity();
        CodeEntity other$codeEntity = other.codeEntity();
        if (this$codeEntity == null ? other$codeEntity != null : !((Object)this$codeEntity).equals(other$codeEntity)) {
            return false;
        }
        List<CodeRestriction> this$disallowedCodes = this.disallowedCodes();
        List<CodeRestriction> other$disallowedCodes = other.disallowedCodes();
        if (this$disallowedCodes == null ? other$disallowedCodes != null : !((Object)this$disallowedCodes).equals(other$disallowedCodes)) {
            return false;
        }
        Map<String, CodeRestriction> this$restrictionsByCode = this.restrictionsByCode();
        Map<String, CodeRestriction> other$restrictionsByCode = other.restrictionsByCode();
        if (this$restrictionsByCode == null ? other$restrictionsByCode != null : !((Object)this$restrictionsByCode).equals(other$restrictionsByCode)) {
            return false;
        }
        Set<String> this$searchWords = this.searchWords();
        Set<String> other$searchWords = other.searchWords();
        if (this$searchWords == null ? other$searchWords != null : !((Object)this$searchWords).equals(other$searchWords)) {
            return false;
        }
        LocalDateTime this$createTimestamp = this.createTimestamp();
        LocalDateTime other$createTimestamp = other.createTimestamp();
        return !(this$createTimestamp == null ? other$createTimestamp != null : !((Object)this$createTimestamp).equals(other$createTimestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodeEditRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxMueValue();
        result = result * 59 + this.minAge();
        result = result * 59 + this.maxAge();
        result = result * 59 + this.ptpCount();
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $code = this.code();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        PrimaryCodeType $codeType = this.codeType();
        result = result * 59 + ($codeType == null ? 43 : ((Object)((Object)$codeType)).hashCode());
        String $manifestationPrinDiag = this.manifestationPrinDiag();
        result = result * 59 + ($manifestationPrinDiag == null ? 43 : $manifestationPrinDiag.hashCode());
        String $unacceptablePrinDiag = this.unacceptablePrinDiag();
        result = result * 59 + ($unacceptablePrinDiag == null ? 43 : $unacceptablePrinDiag.hashCode());
        String $questionableAdmissionDiag = this.questionableAdmissionDiag();
        result = result * 59 + ($questionableAdmissionDiag == null ? 43 : $questionableAdmissionDiag.hashCode());
        String $unspecifiedDiag = this.unspecifiedDiag();
        result = result * 59 + ($unspecifiedDiag == null ? 43 : $unspecifiedDiag.hashCode());
        String $fileName = this.fileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        Set<MueLimit> $mueLimits = this.mueLimits();
        result = result * 59 + ($mueLimits == null ? 43 : ((Object)$mueLimits).hashCode());
        String $gender = this.gender();
        result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
        List<CheckType> $checkTypes = this.checkTypes();
        result = result * 59 + ($checkTypes == null ? 43 : ((Object)$checkTypes).hashCode());
        CodeEntity $codeEntity = this.codeEntity();
        result = result * 59 + ($codeEntity == null ? 43 : ((Object)$codeEntity).hashCode());
        List<CodeRestriction> $disallowedCodes = this.disallowedCodes();
        result = result * 59 + ($disallowedCodes == null ? 43 : ((Object)$disallowedCodes).hashCode());
        Map<String, CodeRestriction> $restrictionsByCode = this.restrictionsByCode();
        result = result * 59 + ($restrictionsByCode == null ? 43 : ((Object)$restrictionsByCode).hashCode());
        Set<String> $searchWords = this.searchWords();
        result = result * 59 + ($searchWords == null ? 43 : ((Object)$searchWords).hashCode());
        LocalDateTime $createTimestamp = this.createTimestamp();
        result = result * 59 + ($createTimestamp == null ? 43 : ((Object)$createTimestamp).hashCode());
        return result;
    }

    @Generated
    public CodeEditRule() {
    }

    @JsonIgnore
    @Generated
    public CodeEditRule id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public CodeEditRule code(String code) {
        this.code = code;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEditRule codeType(PrimaryCodeType codeType) {
        this.codeType = codeType;
        return this;
    }

    @Generated
    public CodeEditRule manifestationPrinDiag(String manifestationPrinDiag) {
        this.manifestationPrinDiag = manifestationPrinDiag;
        return this;
    }

    @Generated
    public CodeEditRule unacceptablePrinDiag(String unacceptablePrinDiag) {
        this.unacceptablePrinDiag = unacceptablePrinDiag;
        return this;
    }

    @Generated
    public CodeEditRule questionableAdmissionDiag(String questionableAdmissionDiag) {
        this.questionableAdmissionDiag = questionableAdmissionDiag;
        return this;
    }

    @Generated
    public CodeEditRule unspecifiedDiag(String unspecifiedDiag) {
        this.unspecifiedDiag = unspecifiedDiag;
        return this;
    }

    @Generated
    public CodeEditRule fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public CodeEditRule gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Generated
    public CodeEditRule codeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
        return this;
    }

    @JsonIgnore
    @Generated
    public CodeEditRule searchWords(Set<String> searchWords) {
        this.searchWords = searchWords;
        return this;
    }

    @Generated
    public CodeEditRule createTimestamp(LocalDateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
    }
}

