/*
 * Decompiled with CFR 0.152.
 */
package hdi.codeedit;

import hdi.codeedit.CheckCategory;
import hdi.codeedit.CodeEditRule;
import hdi.codeedit.EditsClaimType;
import hdi.codeedit.MueLimit;
import hdi.util.UiField;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum CheckType {
    MUE(CheckCategory.CODE_EDIT, "MUE", "Medically Unlikely Edit", "MUE", "An MUE for a HCPCS/CPT code is the maximum units of service that a provider would report under most circumstances for a single beneficiary on a single date of service\n"),
    MAX_AGE(CheckCategory.CODE_EDIT, "Age", "Max Age Exceeded", "Max Age", ""),
    MIN_AGE(CheckCategory.CODE_EDIT, "Age", "Below Min Age", "Min Age", ""),
    GENDER_EXCLUSION(CheckCategory.CODE_EDIT, "Gender", "Gender Exclusion", "Gender Exclusion", "Inconsistencies between a patient\u2019s sex and any diagnosis or procedure on the patient\u2019s record.\n For example, a male patient with cervical cancer (diagnosis) or a female patient with a prostatectomy (procedure).\n"),
    PTP(CheckCategory.CODE_EDIT, "PTP", "Procedure-To-Procedure", "PTP", "Edits that prevent improper payment when certain codes are \nsubmitted together for Part B-covered services."),
    MANIFESTATION_PRINCIPAL_DIAG_CODE(CheckCategory.DIAG_CODE_EDIT, "PrinDx", "Manifestation Prin. Diag", "Manifestation Prin. Diag", "Manifestation codes describe the manifestation of an underlying disease, not the disease itself, and therefore should not be used as a principal diagnosis.\n"),
    UNACCEPTABLE_PRINCIPAL_DIAG_CODE(CheckCategory.DIAG_CODE_EDIT, "PrinDx", "Unacceptable Prin. Diag", "Unacceptable Prin. Diag.", "There are selected codes that describe a circumstance which influences an individual\u2019s health status but not a current illness or injury, or codes that are not specific manifestations but may be due to an underlying cause. These codes are considered unacceptable as a principal diagnosis.\n"),
    QUESTIONABLE_ADMISSION_DIAG_CODE(CheckCategory.DIAG_CODE_EDIT, "Admission", "Questionable Admission", "Questionable Admission", "Some diagnoses are not usually sufficient justification for admission to an acute care hospital\n"),
    UNSPECIFIED_DIAG_CODE(CheckCategory.DIAG_CODE_EDIT, "UnspecifiedDX", "Unspecified Code", "Unspecified Code", "Unspecified codes exist in the ICD-10-CM classification for circumstances when documentation in the medical record does not provide the level of detail needed to support reporting a more specific code. However, in the inpatient setting, there should generally be very limited and rare circumstances for which the laterality (right, left, bilateral) of a condition is unable to be documented and reported\n"),
    INVALID_CODE(CheckCategory.CODE_VALIDITY, "Invalid", "Invalid Code", "Invalid Code", ""),
    INACTIVE_CODE(CheckCategory.CODE_VALIDITY, "Inactive", "Inactive Code", "Inactive Code", ""),
    MISSING_PRIN_DIAG(CheckCategory.MISSING_INFO, "Missing", "Missing Principal Diagnosis", "Missing Prin. Diag.", ""),
    MORBIDITY_CODE(CheckCategory.DIAG_CODE_EDIT, "Morbidity", "External Causes of Morbidity", "Ext. Causes of Morbidity", "These codes describe the circumstance causing an injury, not the nature of the injury, and therefore should not be used as a principal diagnosis.\n"),
    MISSING_REQUIRED_FIELD(CheckCategory.MISSING_INFO, "Required", "Missing Required Field", "Missing Required Field", ""),
    INVALID_VALUE(CheckCategory.INVALID_VALUE, "InvalidVal", "Invalid Value", "Invalid Value", ""),
    ALL(null, "All", null, null, null),
    CUSTOM_PROC_CODE_RULE(CheckCategory.CODE_VALIDITY, "Custom", "Custom Proc Rule", "Custom Proc Rule", "");

    private final CheckCategory checkCategory;
    private final String nameForSearch;
    private final String desc;
    private final String shortDesc;
    private final String longDesc;

    public UiField getParameterField(EditsClaimType claimType, CodeEditRule codeEditRule) {
        return switch (this.ordinal()) {
            case 3 -> new UiField("Allowed gender", codeEditRule.gender());
            case 2 -> new UiField("Min age", codeEditRule.minAge());
            case 1 -> new UiField("Max age", codeEditRule.maxAge());
            case 4 -> new UiField("Count", codeEditRule.ptpCount());
            case 0 -> this.createMueUiField(claimType, codeEditRule);
            default -> null;
        };
    }

    private UiField createMueUiField(EditsClaimType claimType, CodeEditRule codeEditRule) {
        MueLimit mueLimit = codeEditRule.getMueLimitForClaimType(claimType);
        if (mueLimit == null) {
            return null;
        }
        return new UiField(WordStringUtils.pluralize("Max unit", mueLimit.maxUnits()), mueLimit.maxUnits());
    }

    public boolean hasCodeEditList() {
        return this.checkCategory != null && this.checkCategory != CheckCategory.CODE_VALIDITY && this != MORBIDITY_CODE && this.checkCategory != CheckCategory.MISSING_INFO && this.checkCategory != CheckCategory.INVALID_VALUE;
    }

    @Generated
    private CheckType(CheckCategory checkCategory, String nameForSearch, String desc, String shortDesc, String longDesc) {
        this.checkCategory = checkCategory;
        this.nameForSearch = nameForSearch;
        this.desc = desc;
        this.shortDesc = shortDesc;
        this.longDesc = longDesc;
    }

    @Generated
    public CheckCategory checkCategory() {
        return this.checkCategory;
    }

    @Generated
    public String nameForSearch() {
        return this.nameForSearch;
    }

    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public String shortDesc() {
        return this.shortDesc;
    }

    @Generated
    public String longDesc() {
        return this.longDesc;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<CheckType, String> {
        public String convert(CheckType enm) {
            return enm.name();
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<String, CheckType> {
        public CheckType convert(@NotNull String s) {
            return (CheckType)EnumUtils.getEnumIgnoreCase(CheckType.class, (String)s);
        }
    }
}

